package com.plutext.samples.mergepptx;
/*
 *  Copyright 2014, Plutext Pty Ltd.
 *   
 *  This file is part of the MergePptx commercial extension to docx4j.
 *
 *  MergePptx is licensed under the Plutext Component Agreement (the "License"); 
 *  you may not use this file except in compliance with the License. 
 *  
 *  In particular, this source code is CONFIDENTIAL, and you must ensure it
 *  stays that way. 
 *
 *  You may obtain a copy of the License at 
 *
 *      http://www.plutext.com/license/Plutext_MergeDocx_Component_License.pdf 
 *
 *  Unless required by applicable law or agreed to in writing, software 
 *  distributed under the License is distributed on an "AS IS" BASIS, 
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 *  See the License for the specific language governing permissions and 
 *  limitations under the License.
 */


import java.io.File;
import java.util.List;

import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.pptx4j.pml.Presentation.SldIdLst.SldId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.plutext.merge.pptx.MergePptxException;
import com.plutext.merge.pptx.PresentationBuilder;
import com.plutext.merge.pptx.SlideRange;

/**
 * Clone a slide, putting it in the presentation 
 * at the specified position.
 * 
 * @author jharrop
 *
 */
public class SlideDuplicator {
		
	static String PPTX_IN = System.getProperty("user.dir")+ "/src/main/resources/sample-pptx/javase.pptx";
	
	
	static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	
	public static void main(String[] args) throws Exception {

		// Configure here...
		
		int SLIDE_INDEX = 4; // zero based index of slide to copy
		
		int INSERT_AT = 2;   // position of insertion
		if (INSERT_AT<0) throw new IndexOutOfBoundsException("Insertion position must be >=0");
		
		
		// OK, do it...
		
		PresentationMLPackage pptx = (PresentationMLPackage)OpcPackage.load(new File(PPTX_IN));
		
		SlideDuplicator duplicator = new SlideDuplicator();
		PresentationMLPackage result = duplicator.duplicateSlide(pptx, SLIDE_INDEX, INSERT_AT);

		result.save(				
			new File(System.getProperty("user.dir") + "/OUT_SlideDuplicate.pptx"));
				
	}
	
	
	PresentationMLPackage duplicateSlide(PresentationMLPackage pptx, int SLIDE_INDEX,  int INSERT_AT) throws MergePptxException {
		
		try {
			
			// Sanity check 1
			if (INSERT_AT<0) throw new IndexOutOfBoundsException("Insertion position must be >=0");
							
			// Sanity check 2
			int size = pptx.getMainPresentationPart().getContents().getSldIdLst().getSldId().size();
			if (INSERT_AT>size) throw new IndexOutOfBoundsException("There are " + size + " slides in this pptx; Insertion position can't exceed that.");
					
			PresentationBuilder builder = new PresentationBuilder();
			
			// Create and add a SlideRange of all slides in this pptx
			// Add the slide range to the output
			builder.addSlideRange(new SlideRange(pptx));
			
			// Create and add a SlideRange of the specific slide
			PresentationMLPackage clone = (PresentationMLPackage)pptx.clone();
			builder.addSlideRange(new SlideRange(clone, SLIDE_INDEX, 1)); // 1 means 1 slide
			
			PresentationMLPackage result = builder.getResult();
			
			// That's added it at the end, do we have to move it?
			if (INSERT_AT==size) {
				// Fine; its at the end already
			} else {
				List<SldId> slideIds= result.getMainPresentationPart().getContents().getSldIdLst().getSldId();
				SldId theSld = slideIds.remove(size);
				slideIds.add(INSERT_AT, theSld);
			}
			
			return result;
			
		} catch (Exception e) {
			throw new MergePptxException(e.getMessage(),e);
		}
	}
	
}
	
