package com.plutext.samples.mergepptx;
/*
 *  Copyright 2012, Plutext Pty Ltd.
 *   
 *  This file is part of the MergePptx commercial extension to docx4j.
 *
 *  MergePptx is licensed under the Plutext Component Agreement (the "License"); 
 *  you may not use this file except in compliance with the License. 
 *  
 *  In particular, this source code is CONFIDENTIAL, and you must ensure it
 *  stays that way. 
 *
 *  You may obtain a copy of the License at 
 *
 *      http://www.plutext.com/license/Plutext_MergeDocx_Component_License.pdf 
 *
 *  Unless required by applicable law or agreed to in writing, software 
 *  distributed under the License is distributed on an "AS IS" BASIS, 
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 *  See the License for the specific language governing permissions and 
 *  limitations under the License.
 */


import java.io.File;
import java.util.ArrayList;
import java.util.List;

import net.engio.mbassy.bus.MBassador;
import net.engio.mbassy.bus.config.BusConfiguration;
import net.engio.mbassy.bus.config.Feature;
import net.engio.mbassy.bus.error.IPublicationErrorHandler;

import org.docx4j.events.Docx4jEvent;
import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.plutext.merge.pptx.PresentationBuilder;
import com.plutext.merge.pptx.SlideRange;
import com.plutext.merge.pptx.ThemeTreatment;

/**
 * Merge/concatenate/append/join pptx files.
 * 
 * @author jharrop
 *
 */
public class MergePptxInDir {
	
	protected static Logger log = LoggerFactory.getLogger(MergeWholePresentations.class);
	
	public final static String DIR_IN = System.getProperty("user.dir")+ "/src/main/resources/sample-pptx/";
	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	private final static boolean listen = true;	
    
	public static void main(String[] args) throws Exception {
		
		long startMS = System.currentTimeMillis();
		
		ListeningBean listener;
		if (listen) {
			// Creation of message bus
			MBassador<Docx4jEvent> bus = new MBassador<Docx4jEvent>(
					new BusConfiguration()
				     .addFeature(Feature.SyncPubSub.Default()) // configure the synchronous message publication
				     .addFeature(Feature.AsynchronousHandlerInvocation.Default()) // configure asynchronous invocation of handlers
				     .addFeature(Feature.AsynchronousMessageDispatch.Default()) // configure asyncronous message publication (fire&forget)
				     .addPublicationErrorHandler(new IPublicationErrorHandler.ConsoleLogger())
				     );
			Docx4jEvent.setEventNotifier(bus);
			//  and registration of listeners
			listener = new ListeningBean();
			bus.subscribe(listener);					
		}
		
		List<PresentationMLPackage> pmlPkgs = new ArrayList<PresentationMLPackage>();
        
        File dir = new File(DIR_IN);
        
        if (dir.isDirectory() ) {
        	
        	File[] files = dir.listFiles();
        	for (int i=0 ; i<files.length; i++) {
        		
        		String path = files[i].getName();
        		
        		if (path.endsWith("pptx")) {

            		log.info("\n\n loading " + path + "\n\n");
            		
        			PresentationMLPackage pmlPkg = (PresentationMLPackage)OpcPackage.load(files[i]);
        			//pmlPkg.setUserData(deck[i]);
        			pmlPkgs.add(pmlPkg);
        			
        		}
        	}
			
		
		} else {
			throw new RuntimeException("Not a dir!");
		}
		
		PresentationBuilder builder = new PresentationBuilder();
		
		// Uncomment to retain look/feel of each presentation
		builder.setThemeTreatment(ThemeTreatment.RESPECT);
		
//		builder.setConserveMemory(true);
				
		List<SlideRange> sources = new ArrayList<SlideRange>();
		for (int i=0 ; i< pmlPkgs.size(); i++) {
			
//    		sources.add(new SlideRange(pmlPkg));
			log.info("\n\n loading " + i + "  " + pmlPkgs.get(i).name() + "\n\n");
			
			// Create a SlideRange representing the slides in this pptx
			SlideRange sr = new SlideRange(pmlPkgs.get(i));
			sr.setName(i+ " " + pmlPkgs.get(i).name());  // PkgIdentifier for ListeningBean
			
			// Add the slide range to the output
			builder.addSlideRange(sr);
		
		}
		
		
		builder.getResult().save(new File(System.getProperty("user.dir") + "/OUT_MergePptxInDir.pptx"));		
		
		if (listen) {
			System.out.println(listener.sw);
		}
		
		// The times above don't include various things, such as Context init, and saving the final docx
		long elapsedMS = System.currentTimeMillis() - startMS;
		int secs = Math.round(elapsedMS/1000);
		System.out.println("time taken: " + secs + "secs");
		
	}
	
}
