package com.plutext.samples.mergepptx;
/*
 *  Copyright 2012, Plutext Pty Ltd.
 *   
 *  This file is part of the MergePptx commercial extension to docx4j.
 *
 *  MergePptx is licensed under the Plutext Component Agreement (the "License"); 
 *  you may not use this file except in compliance with the License. 
 *  
 *  In particular, this source code is CONFIDENTIAL, and you must ensure it
 *  stays that way. 
 *
 *  You may obtain a copy of the License at 
 *
 *      http://www.plutext.com/license/Plutext_MergeDocx_Component_License.pdf 
 *
 *  Unless required by applicable law or agreed to in writing, software 
 *  distributed under the License is distributed on an "AS IS" BASIS, 
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 *  See the License for the specific language governing permissions and 
 *  limitations under the License.
 */


import java.io.File;

import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.plutext.merge.pptx.PresentationBuilder;
import com.plutext.merge.pptx.SlideRange;
import com.plutext.merge.pptx.ThemeTreatment;

/**
 * Merge/concatenate/append/join identified slides.
 * 
 * @author jharrop
 *
 */
public class MergeListedSlides {
	
	
	protected static Logger log = LoggerFactory.getLogger(MergeListedSlides.class);
	
	public final static String DIR_IN = System.getProperty("user.dir")+ "/src/main/resources/sample-pptx/";
	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
    
	public static void main(String[] args) throws Exception {
		
		PresentationBuilder builder = new PresentationBuilder();
		
		// Uncomment to retain look/feel of each presentation
		//builder.setThemeTreatment(ThemeTreatment.RESPECT);
		
		
		int[] range1 = {2,4,6,8};
		builder.addSlideRange( new SlideRange(
								(PresentationMLPackage)OpcPackage.load(new File(DIR_IN + "microsoft1.pptx")),
								range1) );
		
		int[] range2 = {1,3,5};
		builder.addSlideRange( new SlideRange(
								(PresentationMLPackage)OpcPackage.load(new File(DIR_IN + "oracle.pptx")),
								range2) );
		
		builder.getResult().save(new File(System.getProperty("user.dir") + "/OUT_MergeListedSlides.pptx"));
		
	}
	
}
    