package com.plutext.samples.mergepptx;
import java.io.StringWriter;
import java.util.LinkedList;

import net.engio.mbassy.listener.Handler;
import net.engio.mbassy.listener.Listener;
import net.engio.mbassy.listener.References;

import org.docx4j.events.Docx4jEvent;
import org.docx4j.events.StartEvent;

import com.plutext.merge.pptx.MergePptxEventFinished;
import com.plutext.merge.pptx.MergePptxStartEvent;


	/**
	 * This is a sample listening bean you can use
	 * if you want to subscribe to MergePptx events.
	 * See MergeWholePresentations for an example
	 * of usage (be sure to set listen=true).  
	 * 
	 * @author jharrop
	 *
	 */
	@Listener(references = References.Strong)
	public class ListeningBean {
		
		public StringWriter sw = new StringWriter();
		
		LinkedList<Long> startTimes = new LinkedList<Long>();
		
		 // every message of type Docx4jEvent or MergeEvent  will be delivered
	    // to this handler; NPEs etc in this handler will be silently ignored.
	    @Handler
	    public void handleMessage(Docx4jEvent message) {
	    	
	    	try {

	    		//sw.append("\nDEBUG: " + message.getClass().getName()); 
		    	
		    	String state;
		    	if (message instanceof StartEvent) {
		    		state = "starting";
			    	if (message instanceof MergePptxStartEvent) {
			    		startTimes.push(System.currentTimeMillis());
			    	}
		    	} else {
	//	    		sw.append("\nDEBUG: " + message.getClass().getName()); 
		    		state = "finished";
		    	}
		    	
		    	if ((message instanceof MergePptxStartEvent) 
		    			|| (message instanceof MergePptxEventFinished)) {
		    			
		    		
		    		if (message.getPkgIdentifier()==null) {
	
			    		sw.append( message.getClass().getName() +  " " + state );
		    			
		    		} else {
		    			
			    		System.out.println("\n\n\n\n **** " + message.getPkgIdentifier().name() + ": " 
			    				+ " " + state + " ***** \n\n");
			    		
			    		sw.append("\n" + message.getPkgIdentifier().name() + ": " 
			    				+  " " + state );
		    		} 
			    	
		    	}
	
		    	if (message instanceof MergePptxEventFinished) { // ie end event
	
		    		long elapsedMS = System.currentTimeMillis() - startTimes.pop();
		    		//int secs = Math.round(elapsedMS/1000);
	//	    		sw.append("time taken: " + secs + "secs");
		    		sw.append("\ntime taken: " + elapsedMS + "ms \n\n");
		    	}
		    	
	    	} catch (Throwable e) {
	    		e.printStackTrace();
	    	}
	    }
		
	}
