package com.plutext.samples.mergepptx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.openpackaging.io.SaveToZipFile;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.PresentationML.MainPresentationPart;
import org.pptx4j.pml.Presentation.SldIdLst;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.plutext.merge.pptx.PresentationBuilder;
import com.plutext.merge.pptx.SlideRange;


/**
 * Splits a presentation in half.
 * Useful for working out which slide is causing problems
 * in a problematic deck.
 * @author jharrop
 *
 */
public class Halve {

	protected static Logger log = LoggerFactory.getLogger(Halve.class);
	
	public final static String PRES_IN = System.getProperty("user.dir")+ "/src/main/resources/sample-pptx/javase.pptx";
	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
    
	public static void main(String[] args) throws Exception {
		
		PresentationMLPackage pmlPkg = (PresentationMLPackage)OpcPackage.load(new File(PRES_IN));

		MainPresentationPart presentation = pmlPkg.getMainPresentationPart();
        SldIdLst sldIdLst = presentation.getJaxbElement().getSldIdLst();
        int slideCount = sldIdLst.getSldId().size();
        
        int firstN = Math.round(slideCount/2);
        

		PresentationBuilder builder = new PresentationBuilder();
        SlideRange range = new SlideRange(pmlPkg, 0, firstN);
		builder.addSlideRange(range);		
		builder.getResult().save(new File(System.getProperty("user.dir") + "/OUT_Halve_first.pptx"));
		
		// 2nd half
		builder = new PresentationBuilder();
		pmlPkg = (PresentationMLPackage)OpcPackage.load(new File(PRES_IN)); //reload
        range = new SlideRange(pmlPkg, firstN, slideCount-firstN);
		builder.addSlideRange(range);
		builder.getResult().save(new File(System.getProperty("user.dir") + "/OUT_Halve_second.pptx"));
				
		
	}
	
}
    