package com.plutext.samples.ole;
/*
 *  Copyright 2013, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */


import java.io.File;

import org.apache.commons.io.FileUtils;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;

import com.plutext.ole.pdf.PdfOleHelperXlsx;

/**
 * Example of how to link or embed a PDF file
 * inside an XLSX  
 * 
 * @author Jason Harrop
 */
public class Xlsx_ole_PDF_icon {
	
	final static org.xlsx4j.sml.ObjectFactory smlObjectFactory = org.xlsx4j.jaxb.Context.getsmlObjectFactory();	
	
	public static void main(String[] args) throws Exception {
	
		
		// Link or embed?
		boolean OLE_LINK_ONLY = false;
		
		// Open or create your docx/pptx/xlsx package using docx4j
		SpreadsheetMLPackage pkg = SpreadsheetMLPackage.createPackage();
		WorksheetPart sheet = pkg.createWorksheetPart(new PartName("/xl/worksheets/sheet1.xml"), "Sheet1", 1);
		
		PdfOleHelperXlsx pdfOleHelper = new PdfOleHelperXlsx(pkg); 

		File pdfFile = new  File(System.getProperty("user.dir")+ "/sample.pdf");
		
		String caption = "a longish filename.pdf"; // used if displaying icon; could be null otherwise 
		
		// You also need to say where on the sheet the OLE object is to go.
		// see http://webapp.docx4java.org/OnlineDemo/ecma376/VML/Anchor.html
		/*
		 * The value is a comma-separated list of data written out as: 
		 *    LeftColumn, LeftOffset, TopRow, TopOffset, RightColumn, RightOffset, BottomRow, BottomOffset.


				LeftColumn:   The left anchor column of the object (left-most column is 0). [Example: An object whose left anchor was off of the third column would have a LeftColumn value of 2. end example]
				
				LeftOffset:   The offset of the object's left edge from the left edge of the left anchor column. This value is measured in pixels.
				
				TopRow:       The top anchor row of the object (top-most column is 0). [Example: An object whose top anchor was off of the fifth row would have a TopRow value of 4. end example]
				
				TopOffset:    The offset of the object's top edge from the top edge of the top anchor row. This value is measured in pixels.
				
				RightColumn:  The right anchor column of the object (left-most column is 0). [Example: An object whose right anchor was off of the tenth column would have a RightColumn value of 9. end example]
				
				RightOffset:  The offset of the object's right edge from the left edge of the right anchor column. This value is measured in pixels.
				
				BottomRow:    The bottom anchor row of the object (top-most column is 0). [Example: An object whose bottom anchor was off of the tenth row would have a BottomRow value of 9. end example]
				
				BottomOffset: The offset of the object's bottom edge from the bottom edge of the bottom anchor row. This value is measured in pixels.
		 */		
		int cols = (int)Math.max(1, Math.round( caption.length()/5)); // crude accommodation for long caption
		int firstCol=4;
		int lastCol=firstCol+cols;
		int[] anchorLocation = {firstCol, 0, 4, 0, lastCol, 0, 7, 5}; // fixed at just over 3 rows high, good for a file icon
		
		if (OLE_LINK_ONLY) {

			pdfOleHelper.linkUsingIcon(sheet, anchorLocation,  
					"file:///C:\\Users\\jharrop\\git\\docx4j-OLE\\pdf4.pdf", 
					caption);

		    // Save the resulting xlsx
			pkg.save(new java.io.File(System.getProperty("user.dir") + "/OUT_PDF_icon_LINKED.xlsx"));	
			
		} else {
						
			
			byte[] pdfBytes = FileUtils.readFileToByteArray(pdfFile);
			pdfOleHelper.embedUsingIcon(sheet, anchorLocation, pdfBytes, caption);	
						
		    // Save the resulting xlsx
			pkg.save(new java.io.File(System.getProperty("user.dir") + "/OUT_PDF_icon_EMBEDDED.xlsx"));			
		}
        


	}
	

	
}
