package com.plutext.samples.ole;
/*
 *  Copyright 2013, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */


import java.io.File;

import org.apache.commons.io.FileUtils;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;

import com.plutext.ole.pdf.PdfOleHelperXlsx;

/**
 * Example of how to link or embed a PDF file
 * inside an XLSX  
 * 
 * @author Jason Harrop
 */
public class Xlsx_ole_PDF_Multiple {
	
	final static org.xlsx4j.sml.ObjectFactory smlObjectFactory = org.xlsx4j.jaxb.Context.getsmlObjectFactory();	
	
	public static void main(String[] args) throws Exception {
	
		
		// Link or embed?
		boolean OLE_LINK_ONLY = false;
		
		// Open or create your docx/pptx/xlsx package using docx4j
		SpreadsheetMLPackage pkg = SpreadsheetMLPackage.createPackage();
		WorksheetPart sheet = pkg.createWorksheetPart(new PartName("/xl/worksheets/sheet1.xml"), "Sheet1", 1);
		
		PdfOleHelperXlsx pdfOleHelper = new PdfOleHelperXlsx(pkg); 
		
		File pdfFile = new  File(System.getProperty("user.dir")+ "/sample.pdf");
		int[] anchorLocation = {4, 0, 4, 0, 9, 0, 22, 0}; // see http://webapp.docx4java.org/OnlineDemo/ecma376/VML/Anchor.html
		
		if (OLE_LINK_ONLY) {

			pdfOleHelper.link(sheet, anchorLocation,  "file:///C:\\Users\\jharrop\\git\\docx4j-OLE\\pdf4.pdf", FileUtils.readFileToByteArray(pdfFile));

			// the second object
			int[] anchorLocation2 = {2, 0, 2, 0, 7, 0, 16, 0}; // see http://webapp.docx4java.org/OnlineDemo/ecma376/VML/Anchor.html
			pdfOleHelper.link(sheet, anchorLocation2,  "file:///C:\\Users\\jharrop\\git\\docx4j-OLE\\pdf4.pdf", FileUtils.readFileToByteArray(pdfFile));
			
		    // Save the resulting xlsx
			pkg.save(new java.io.File(System.getProperty("user.dir") + "/OUT_pdf_LINKED_multiple.xlsx"));	
			
		} else {
			
			pdfOleHelper.embed(sheet, anchorLocation,
					FileUtils.readFileToByteArray(pdfFile));			

			// the second object
			int[] anchorLocation2 = {2, 0, 2, 0, 7, 0, 16, 0}; // see http://webapp.docx4java.org/OnlineDemo/ecma376/VML/Anchor.html
			pdfOleHelper.embed(sheet, anchorLocation2,
					FileUtils.readFileToByteArray(pdfFile));			
			
		    // Save the resulting xlsx
			pkg.save(new java.io.File(System.getProperty("user.dir") + "/OUT_pdf_EMBEDDED_multiple.xlsx"));			
		}
        


	}
	

	
}
