package com.plutext.samples.ole;
/*
 *  Copyright 2013, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */


import java.io.File;

import org.apache.commons.io.FileUtils;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;

import com.plutext.ole.pdf.PdfOleHelperXlsx;

/**
 * Example of how to link or embed a PDF file
 * inside an XLSX  
 * 
 * @author Jason Harrop
 */
public class Xlsx_ole_PDF {
	
	final static org.xlsx4j.sml.ObjectFactory smlObjectFactory = org.xlsx4j.jaxb.Context.getsmlObjectFactory();	
	
	public static void main(String[] args) throws Exception {
	
		
		// Link or embed?
		boolean OLE_LINK_ONLY = false;
		
		// Open or create your docx/pptx/xlsx package using docx4j
		SpreadsheetMLPackage pkg = SpreadsheetMLPackage.createPackage();
		WorksheetPart sheet = pkg.createWorksheetPart(new PartName("/xl/worksheets/sheet1.xml"), "Sheet1", 1);
		
		PdfOleHelperXlsx pdfOleHelper = new PdfOleHelperXlsx(pkg); 
		
		File pdfFile = new  File(System.getProperty("user.dir")+ "/src/main/resources/sample.pdf");
		int[] anchorLocation = {4, 0, 4, 0, 9, 0, 22, 0}; // see http://webapp.docx4java.org/OnlineDemo/ecma376/VML/Anchor.html
		// Excel 2010 will scale the image to match anchorLocation
		// (trumping @style).  On Activation, image will be resized to its intrinsic size
		// (and the anchorLocation values overwritten to match).
		// So if you wish to avoid resizing on activation, you'd have to calculate
		// and provide initial anchorLocation values (based on intrinsic image size,
		// and knowledge of cell heights and widths).
		
		byte[] imageBytes =FileUtils.readFileToByteArray(new File(System.getProperty("user.dir")+"/src/main/resources/greentick.png" ));
		
		if (OLE_LINK_ONLY) {

			pdfOleHelper.link(sheet, anchorLocation,  "file:///C:\\Users\\jharrop\\git\\docx4j-OLE\\pdf4.pdf", FileUtils.readFileToByteArray(pdfFile));

		    // Save the resulting xlsx
			pkg.save(new java.io.File(System.getProperty("user.dir") + "/OUT_pdf_LINKED.xlsx"));	
			
		} else {
						
			byte[] pdfBytes = FileUtils.readFileToByteArray(pdfFile);
			
			
//			pdfOleHelper.embed(sheet, anchorLocation, pdfBytes);
			
			pdfOleHelper.embedUsingImage(sheet, anchorLocation, pdfBytes, imageBytes, "image/png");	
			
			
			// To avoid temp file creation, use instead
//			ThumbnailViaJPedal thumbnail = new ThumbnailViaJPedal(pdfBytes);
//			byte[] imageBytes = thumbnail.getThumbnail();
//			pdfOleHelper.embedUsingImage(sheet, anchorLocation, pdfBytes, imageBytes, 
//			thumbnail.getMime());	
			
		    // Save the resulting xlsx
			pkg.save(new java.io.File(System.getProperty("user.dir") + "/OUT_pdf_EMBEDDED.xlsx"));			
		}
        


	}
	

	
}
