package com.plutext.samples.ole;
/*
 *  Copyright 2013, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */


import java.io.File;

import org.apache.commons.io.FileUtils;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;

import com.plutext.ole.EmbeddingType;
import com.plutext.ole.odf.OdfOleHelperXlsx;
import com.plutext.ole.pdf.PdfOleHelperXlsx;

/**
 * Example of how to link or embed a ODF file
 * inside an XLSX  
 * 
 * @author Jason Harrop
 */
public class Xlsx_ole_ODF {
	
	
	public static void main(String[] args) throws Exception {
	
		
		////////////////////////////////////////////////////////
		// For this sample, create a xlsx package using docx4j
		SpreadsheetMLPackage pkg = SpreadsheetMLPackage.createPackage();
		WorksheetPart sheet = pkg.createWorksheetPart(new PartName("/xl/worksheets/sheet1.xml"), "Sheet1", 1);
		
		////////////////////////////////////////////////////////
		// OLE config
		
		byte[] odfBytes = FileUtils.readFileToByteArray(
				new java.io.File(System.getProperty("user.dir") + "/Hello world.odt")
				);
		
		EmbeddingType embeddingType = EmbeddingType.ODT; // ODT, ODP, ODS, to match filetype above
		
		int[] anchorLocation = {4, 0, 4, 0, 9, 0, 22, 0}; // see http://webapp.docx4java.org/OnlineDemo/ecma376/VML/Anchor.html
		// Excel 2010 will scale the image to match anchorLocation
		// (trumping @style).  On Activation, image will be resized to its intrinsic size
		// (and the anchorLocation values overwritten to match).
		// So if you wish to avoid resizing on activation, you'd have to calculate
		// and provide initial anchorLocation values (based on intrinsic image size,
		// and knowledge of cell heights and widths).
		
		String caption = embeddingType.name();
		String targetURL = "file:///C:\\Users\\jharrop\\git\\docx4j-OLE\\foo." + embeddingType.name();
		
		
		////////////////////////////////////////////////////////
		// Perform OLE

		// Link or embed?
		boolean OLE_LINK_ONLY = false;
		
		OdfOleHelperXlsx odfOleHelper = new OdfOleHelperXlsx(pkg); 
		if (OLE_LINK_ONLY) {

			odfOleHelper.linkUsingIcon(sheet, anchorLocation, embeddingType, targetURL, 
					caption);

		    // Save the resulting xlsx
			pkg.save(new java.io.File(System.getProperty("user.dir") + "/OUT_"
			+ embeddingType.name() +"_LINKED.xlsx"));	
			
		} else {
			
			//odfOleHelper.embedUsingIcon(sheet,  anchorLocation, embeddingType, odfBytes, caption);
			
			odfOleHelper.embedEditInPlace(sheet, anchorLocation, embeddingType, odfBytes, null, null);
						
		    // Save the resulting xlsx
			pkg.save(new java.io.File(System.getProperty("user.dir") + "/OUT_"
			+ embeddingType.name() +"_EMBEDDED.xlsx"));			
		}
        
		/* If you get the error:
		 * 
		 *   The program used to create this object is Excel.  That program is either not 
		 *   installed on your computer or it is not responding.  To edit this object,
		 *   install Excel or ensure that any dialog boxes in Word are closed.
		 *   
		 * when you try to activate in Word the object in the resulting xlsx, 
		 * check that Excel is able to open the ODF object you are trying to embed.
		 * If Word says "The file .. cannot be opened because there are problems with the
		 * contents", this is probably the cause of the error ie Excel doesn't like
		 * the original ODF object.
		 * 
		 * My Excel 2010 x64 wants to repair the simplest ODT created in OO 4.0.14
		 * or LO 4.1.4, so to maximise chances of compatibility,
		 * recommend you save your ODT using Excel itself 
		 * 
		 * The reason is that Office 2010 only supports ODF 1.1, but
		 * OO 4.0.14 and LO 4.1.4 both create ODF 1.2 files.  
		 * Office 2013 can read ODF 1.2 files.
		 * 
		 */

	}
	

	
}
