package com.plutext.samples.ole;
/*
 *  Copyright 2013, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */


import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorkbookPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;
import org.xlsx4j.sml.Worksheet;

import com.plutext.ole.EmbeddingType;
import com.plutext.ole.OLEException;
import com.plutext.ole.OleHelperXlsx;

/**
 * Example of how to link or embed a txt file
 * as an OleObjectBinaryPart inside an XLSX  
 * 
 * @author Jason Harrop
 */
public class Xlsx_Embed_Multiple_Objects {
	
	public static void main(String[] args) throws Exception {
		
		String outputfilepath = System.getProperty("user.dir") + "/OUT_text_MULTIPLE.xlsx";

		////////////////////////////////////////////////////////
		// For this sample, create a xlsx package using docx4j
		SpreadsheetMLPackage pkg = SpreadsheetMLPackage.createPackage();
		
		WorkbookPart workbook= pkg.getWorkbookPart();
		if (workbook==null) {
			throw new OLEException("No WorkbookPart found in pkg");
		}

        // create two worksheets
		// .. worksheet 1
		WorksheetPart sheet = pkg.createWorksheetPart(new PartName("/xl/worksheets/sheet1.xml"), "Sheet1", 1);
		String openXML = "<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\" >"
	            + "<dimension ref=\"A1\"/>"
	            + "<sheetViews>"
	                + "<sheetView tabSelected=\"1\" workbookViewId=\"0\"/>"
	            +"</sheetViews>"
	            + "<sheetFormatPr defaultRowHeight=\"15\" />"
	            + "<sheetData/>"
	            + "<pageMargins bottom=\"0.75\" footer=\"0.3\" header=\"0.3\" left=\"0.7\" right=\"0.7\" top=\"0.75\"/>"
	        +"</worksheet>";

		Worksheet worksheet = (Worksheet)XmlUtils.unwrap(
						XmlUtils.unmarshalString(openXML, org.xlsx4j.jaxb.Context.jcSML));
		sheet.setJaxbElement(worksheet);

		// .. worksheet 2
		WorksheetPart sheet2 = pkg.createWorksheetPart(new PartName("/xl/worksheets/sheet2.xml"), "Sheet2", 2);

		Worksheet worksheet2 = (Worksheet)XmlUtils.unwrap(
						XmlUtils.unmarshalString(openXML, org.xlsx4j.jaxb.Context.jcSML));
		sheet2.setJaxbElement(worksheet2);
		
		////////////////////////////////////////////////////////
		// OLE config
		
		EmbeddingType embeddingType = EmbeddingType.TXT; 
		byte[] yourContent =  "Your content goes here...".getBytes(); 
		
		String caption = "a longish filename.txt"; // used if displaying icon; could be null otherwise 
		
		// You also need to say where on the sheet the OLE object is to go.
		// see http://webapp.docx4java.org/OnlineDemo/ecma376/VML/Anchor.html
		/*
		 * The value is a comma-separated list of data written out as: 
		 *    LeftColumn, LeftOffset, TopRow, TopOffset, RightColumn, RightOffset, BottomRow, BottomOffset.


				LeftColumn:   The left anchor column of the object (left-most column is 0). [Example: An object whose left anchor was off of the third column would have a LeftColumn value of 2. end example]
				
				LeftOffset:   The offset of the object's left edge from the left edge of the left anchor column. This value is measured in pixels.
				
				TopRow:       The top anchor row of the object (top-most column is 0). [Example: An object whose top anchor was off of the fifth row would have a TopRow value of 4. end example]
				
				TopOffset:    The offset of the object's top edge from the top edge of the top anchor row. This value is measured in pixels.
				
				RightColumn:  The right anchor column of the object (left-most column is 0). [Example: An object whose right anchor was off of the tenth column would have a RightColumn value of 9. end example]
				
				RightOffset:  The offset of the object's right edge from the left edge of the right anchor column. This value is measured in pixels.
				
				BottomRow:    The bottom anchor row of the object (top-most column is 0). [Example: An object whose bottom anchor was off of the tenth row would have a BottomRow value of 9. end example]
				
				BottomOffset: The offset of the object's bottom edge from the bottom edge of the bottom anchor row. This value is measured in pixels.
		 */
		int cols = (int)Math.max(1, Math.round( caption.length()/5)); // crude accommodation for long caption
		int leftCol=4;
		int rightCol=leftCol+cols;
		int topRow=4;
		int bottomRow=topRow+3;
		
		int[] anchorLocation1 = {leftCol, 0, topRow, 0, rightCol, 0, bottomRow, 5}; // fixed at just over 3 rows high, good for a file icon
		int[] anchorLocation2 = {leftCol+4, 0, topRow, 0, rightCol+4, 0, bottomRow, 5}; // fixed at just over 3 rows high, good for a file icon
			// you can make it bigger if you are supplying a larger image

		// the image on the worksheet
		byte[] imageBytes = null; //IconGenerator.createIcon(embeddingType, caption);
		// if imageBytes was null, IconGenerator would be used like that anyway
		String mime = null; // ifyou are providing an image, and know its mime type, you can set this
		
		// Both link and embed require this
        String filepath = "C:\\Users\\jharrop\\Documents\\alpha.txt";    // typically the original file location
		
        // For link only
		String command = filepath;  // for embed case, Word uses a tmp file location. But link case points to the original file
		
		////////////////////////////////////////////////////////
		// Perform OLE

		// Link or embed?
		boolean OLE_LINK_ONLY = false;
		
		OleHelperXlsx oleHelperXlsx = new OleHelperXlsx(pkg);
		if (OLE_LINK_ONLY) {
			
			oleHelperXlsx.link(sheet, anchorLocation1, imageBytes, mime,   embeddingType, caption, filepath);
			
		} else {
			
			oleHelperXlsx.embed(sheet, anchorLocation1, generateContent("_1_1"), imageBytes, mime,   embeddingType, "file_1_1.txt", filepath, command);
			oleHelperXlsx.embed(sheet, anchorLocation2, generateContent("_1_2"), imageBytes, mime,   embeddingType, "file_1_2.txt", filepath, command);

			oleHelperXlsx.embed(sheet2, anchorLocation1, generateContent("_2_1"), imageBytes, mime,   embeddingType, "file_2_1.txt", filepath, command);
			oleHelperXlsx.embed(sheet2, anchorLocation2, generateContent("_2_2"), imageBytes, mime,   embeddingType, "file_2_2.txt", filepath, command);
			
		}

		////////////////////////////////////////////////////////
		// Save the result
		pkg.save(new java.io.File(outputfilepath));
	}
	
	private static byte[] generateContent(String suffix) {
		
		String content = "Your content goes here..." + suffix;
		return content.getBytes(); 
		
	}	

	
}
