package com.plutext.samples.ole;
/*
 *  Copyright 2013, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */




import java.io.File;

import org.apache.commons.io.FileUtils;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.MainPresentationPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;

import com.plutext.ole.EmbeddingType;
import com.plutext.ole.OleHelperPptx;


/**
 * Example of how to link or embed a vsdx
 * as an OleObjectBinaryPart inside a pptx  
 * 
 * @author Jason Harrop
 */
public class Pptx_ole_vsdx  {
	
	
	public static void main(String[] args) throws Exception {

		// Where will we save our new .ppxt?
		String outputfilepath = System.getProperty("user.dir") + "/OUT_vsdx.pptx";

		
		////////////////////////////////////////////////////////
		// For this sample, create a pptx package using docx4j
		
		// Open or create your docx/pptx/xlsx package using docx4j
		// .. create skeletal package, including a MainPresentationPart and a SlideLayoutPart
		PresentationMLPackage pkg = PresentationMLPackage.createPackage(); 
		// Need references to these parts to create a slide
		// Please note that these parts *already exist* - they are
		// created by createPackage() above.  See that method
		// for instruction on how to create and add a part.
		// .. create a slide
		// Slide part
		SlidePart slidePart = new SlidePart();
		slidePart.setJaxbElement( SlidePart.createSld() );

		// Add slide to presentation
		MainPresentationPart pp = (MainPresentationPart)pkg.getParts().getParts().get(
				new PartName("/ppt/presentation.xml"));		
		pp.addSlide(slidePart);
		
		// Slide layout part
		SlideLayoutPart layoutPart = (SlideLayoutPart)pkg.getParts().getParts().get(
				new PartName("/ppt/slideLayouts/slideLayout1.xml"));
		slidePart.addTargetPart(layoutPart);

		
		////////////////////////////////////////////////////////
		// OLE config

		EmbeddingType embeddingType = EmbeddingType.VSDX; 

		// Link or embed?
		boolean OLE_LINK_ONLY = true;
		
		// Embed
        byte[] yourContent =  FileUtils.readFileToByteArray(new File(System.getProperty("user.dir") 
				+"/src/samples/OLE/resources/Drawing1.vsdx" ));

        // or link 
        String targetURL = "file:///F:/ole-visio/Drawing1.vsdx";    // the actual location
        
		// the image on the worksheet
		byte[] imageBytes = null;	// just use an icon
		String mime = null;
		// if you know your image mime type and filename ext, you can avoid image introspection (which avoids temp file creation)
		// .. otherwise, set those to null
		
		String caption = "Visio"; // can be anything, but may be used if displaying content rather than icon 
		
		// position in points
		int topPts = 100; 
		int leftPts = 200;
		

		
		////////////////////////////////////////////////////////
		// Perform OLE
		
		OleHelperPptx oleHelperPptx = new OleHelperPptx(pkg);
		if (OLE_LINK_ONLY) {
			
			oleHelperPptx.linkOffice(slidePart, topPts,  leftPts, imageBytes, mime,   embeddingType, caption, targetURL);
			
		} else {
			
			oleHelperPptx.embed(slidePart, topPts,  leftPts, yourContent, imageBytes, mime,  embeddingType, caption, null, null);
			
		}

		////////////////////////////////////////////////////////
		// Save the result
		pkg.save(new java.io.File(outputfilepath));
		
	}	
	
	
	
}
