package com.plutext.samples.ole;
/*
 *  Copyright 2013, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */




import java.io.File;

import org.apache.commons.io.FileUtils;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.MainPresentationPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;

import com.plutext.ole.pdf.PdfOleHelperPptx;


/**
 * @author jharrop
 *
 */
public class Pptx_ole_PDF_icon  {
	
	
	
		
	public static void main(String[] args) throws Exception {
		
		
		////////////////////////////////////////////////////////
		// For this sample, create a pptx package using docx4j
		
		// Open or create your docx/pptx/xlsx package using docx4j
		// .. create skeletal package, including a MainPresentationPart and a SlideLayoutPart
		PresentationMLPackage pkg = PresentationMLPackage.createPackage(); 
		// Need references to these parts to create a slide
		// Please note that these parts *already exist* - they are
		// created by createPackage() above.  See that method
		// for instruction on how to create and add a part.
		// .. create a slide
		// Slide part
		SlidePart slidePart = new SlidePart();
		slidePart.setJaxbElement( SlidePart.createSld() );

		// Add slide to presentation
		MainPresentationPart pp = (MainPresentationPart)pkg.getParts().getParts().get(
				new PartName("/ppt/presentation.xml"));		
		pp.addSlide(slidePart);
		
		// Slide layout part
		SlideLayoutPart layoutPart = (SlideLayoutPart)pkg.getParts().getParts().get(
				new PartName("/ppt/slideLayouts/slideLayout1.xml"));
		slidePart.addTargetPart(layoutPart);

		
		////////////////////////////////////////////////////////
		// OLE config
		
		File pdfFile = new  File(System.getProperty("user.dir")+ "/src/main/resources/sample.pdf");
		
		// the image on the worksheet
		byte[] imageBytes = null; //FileUtils.readFileToByteArray(new File(System.getProperty("user.dir")+"/greentick.png" ));
		
		String caption = "f1.pdf";
		
		// position in points
		int topPts = 100; 
		int leftPts = 200;

		byte[] pdfBytes = FileUtils.readFileToByteArray(pdfFile);
			// Not required for linking (as opposed to embedding) unless you
			// wish to use the PDF to create the image
		
		String targetURL = "file:///C:\\Users\\jharrop\\git\\docx4j-OLE\\pdf4.pdf";
			// Required for linking; not required for embedding
		
		
		////////////////////////////////////////////////////////
		// Perform OLE
		
		// Link or embed?
		boolean OLE_LINK_ONLY = false;
		
		PdfOleHelperPptx helper = new PdfOleHelperPptx(pkg);
		
		if (OLE_LINK_ONLY) {
			
			helper.linkUsingIcon(slidePart, topPts,  leftPts, targetURL, caption);			
			
			// All done: save it
			pkg.save(new java.io.File(System.getProperty("user.dir") + "/OUT_PDF_icon_linked.pptx"));
			
		} else {
			
			helper.embedUsingIcon(slidePart, topPts,  leftPts, pdfBytes, caption);			
			
			// All done: save it
			pkg.save(new java.io.File(System.getProperty("user.dir") + "/OUT_PDF_icon_embedded.pptx"));
			
		}
		
		
		
	}	
	
	
}
