package com.plutext.samples.ole;
/*
 *  Copyright 2013, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */




import java.io.File;

import org.apache.commons.io.FileUtils;
import org.docx4j.dml.CTTransform2D;
import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.MainPresentationPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;

import com.plutext.ole.EmbeddingType;
import com.plutext.ole.odf.OdfOleHelperPptx;
import com.plutext.ole.pdf.PdfOleHelperPptx;


/**
 * Example of how to link or embed an existing ODF
 * (eg ODT text file or ODP presentation)
 * as an OleObjectBinaryPart inside a pptx  
 * 
 * OLE handling of ODF is a bit
 * different to how most other OLE objects are handled.
 * 
 * @author Jason Harrop
 */
public class Pptx_ole_ODF  {
	
	
	
		
	public static void main(String[] args) throws Exception {
		
		
		////////////////////////////////////////////////////////
		// For this sample, create a pptx package using docx4j
		
		// Open or create your docx/pptx/xlsx package using docx4j
		// .. create skeletal package, including a MainPresentationPart and a SlideLayoutPart
		PresentationMLPackage pkg = PresentationMLPackage.createPackage(); 
		// Need references to these parts to create a slide
		// Please note that these parts *already exist* - they are
		// created by createPackage() above.  See that method
		// for instruction on how to create and add a part.
		// .. create a slide
		// Slide part
		SlidePart slidePart = new SlidePart();
		slidePart.setJaxbElement( SlidePart.createSld() );

		// Add slide to presentation
		MainPresentationPart pp = (MainPresentationPart)pkg.getParts().getParts().get(
				new PartName("/ppt/presentation.xml"));		
		pp.addSlide(slidePart);
		
		// Slide layout part
		SlideLayoutPart layoutPart = (SlideLayoutPart)pkg.getParts().getParts().get(
				new PartName("/ppt/slideLayouts/slideLayout1.xml"));
		slidePart.addTargetPart(layoutPart);

		
		////////////////////////////////////////////////////////
		// OLE config
		
		byte[] odfBytes = FileUtils.readFileToByteArray(
				new java.io.File(System.getProperty("user.dir") + "/hello world.ods")
				);
		
		EmbeddingType embeddingType = EmbeddingType.ODS; // ODT, ODP, ODS, to match filetype above
		
        // Set the size and position of your anchor image to suit
		// position in points
		int topPts = 100; 
		int leftPts = 200;
		//CTTransform2D sizeAndPos = PMLOleObjectHelper.createSizeAndPositionEMU(719138, 4181475, 3829050, 5418137);

		String caption = embeddingType.name();
		String targetURL = "file:///C:\\Users\\jharrop\\git\\docx4j-OLE\\foo." + embeddingType.name();
			// Required for linking; not required for embedding
		
		
		////////////////////////////////////////////////////////
		// Perform OLE
		
		// Link or embed?
		boolean OLE_LINK_ONLY = false;
		
		OdfOleHelperPptx helper = new OdfOleHelperPptx(pkg);
		
		if (OLE_LINK_ONLY) {
			
			helper.linkUsingIcon(slidePart, topPts,  leftPts, embeddingType, targetURL, caption);			
			
			// All done: save it
			pkg.save(new java.io.File(System.getProperty("user.dir") + "/OUT_"
			+ embeddingType.name() +"_linked.pptx"));
			
		} else {
			
			//helper.embedUsingIcon(slidePart, topPts,  leftPts, embeddingType, odfBytes, caption);
			helper.embedEditInPlace(slidePart, topPts, leftPts, embeddingType, odfBytes, null);
			
			// All done: save it
			pkg.save(new java.io.File(System.getProperty("user.dir") + "/OUT_" 
			+ embeddingType.name() +"_embedded.pptx"));
			
		}
		
		/* If you get the error:
		 * 
		 *   The program used to create this object is Powerpoint.  That program is either not 
		 *   installed on your computer or it is not responding.  To edit this object,
		 *   install Word or ensure that any dialog boxes in Powerpoint are closed.
		 *   
		 * when you try to activate in Word the object in the resulting pptx, 
		 * check that Powerpoint is able to open the ODF object you are trying to embed.
		 * If Powerpoint says "The file .. cannot be opened because there are problems with the
		 * contents", this is probably the cause of the error ie Powerpoint doesn't like
		 * the original ODF object.
		 * 
		 * My Powerpoint 2010 x64 wants to repair the simplest ODT created in OO 4.0.14
		 * or LO 4.1.4, so to maximise chances of compatibility,
		 * recommend you save your ODT using Powerpoint itself 
		 * 
		 * The reason is that Office 2010 only supports ODF 1.1, but
		 * OO 4.0.14 and LO 4.1.4 both create ODF 1.2 files.  
		 * Office 2013 can read ODF 1.2 files.
		 * 
		 */
		
	}	
	
	
}
