package com.plutext.samples.ole;
/*
 *  Copyright 2013, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */




import org.docx4j.openpackaging.packages.PresentationMLPackage;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.PresentationML.MainPresentationPart;
import org.docx4j.openpackaging.parts.PresentationML.SlideLayoutPart;
import org.docx4j.openpackaging.parts.PresentationML.SlidePart;

import com.plutext.ole.EmbeddingType;
import com.plutext.ole.OleHelperPptx;


/**
 * @author jharrop
 *
 */
public class Pptx_Embed_Multiple_Objects  {
	
	
	
		
	public static void main(String[] args) throws Exception {

		// Where will we save our new .ppxt?
		String outputfilepath = System.getProperty("user.dir") + "/OUT_MULTIPLE.pptx";
		
		
		////////////////////////////////////////////////////////
		// For this sample, create a pptx package using docx4j
		
		// Open or create your docx/pptx/xlsx package using docx4j
		// .. create skeletal package, including a MainPresentationPart and a SlideLayoutPart
		PresentationMLPackage pkg = PresentationMLPackage.createPackage(); 
		// Need references to these parts to create a slide
		// Please note that these parts *already exist* - they are
		// created by createPackage() above.  See that method
		// for instruction on how to create and add a part.
		// .. create a slide
		// Slide part 1
		SlidePart slidePart = new SlidePart();
		slidePart.setJaxbElement( SlidePart.createSld() );

		SlidePart slidePart2 = new SlidePart();
		slidePart2.setJaxbElement( SlidePart.createSld() );

		SlidePart slidePart3 = new SlidePart();
		slidePart3.setJaxbElement( SlidePart.createSld() );
		
		// Add slide to presentation
		MainPresentationPart pp = (MainPresentationPart)pkg.getParts().getParts().get(
				new PartName("/ppt/presentation.xml"));		
		pp.addSlide(slidePart);
		pp.addSlide(slidePart2);
		pp.addSlide(slidePart3);
		
		// Slide layout part
		SlideLayoutPart layoutPart = (SlideLayoutPart)pkg.getParts().getParts().get(
				new PartName("/ppt/slideLayouts/slideLayout1.xml"));
		slidePart.addTargetPart(layoutPart);
		slidePart2.addTargetPart(layoutPart);
		slidePart3.addTargetPart(layoutPart);

		
		////////////////////////////////////////////////////////
		// OLE config

		EmbeddingType embeddingType = EmbeddingType.TXT; 
//		byte[] yourContent =  "Your content goes here...".getBytes(); 
		
		// the image on the worksheet
		byte[] imageBytes = null; //FileUtils.readFileToByteArray(new File(System.getProperty("user.dir")+"/greentick.png" ));
		
		// if you know your image dimensions (CTTransform2D sizeAndPos) and mime type, you can avoid image introspection (which avoids temp file creation)
		String mime = "image/png"; // .. otherwise, set this to null
		
		// position in points
		int topPts = 100; 
		int leftPts = 200;
		// or create CTTransform2D sizeAndPos
				
		// Both link and embed require this
        String filepath = "C:\\Users\\jharrop\\Documents\\alpha.txt";    // typically the original file location
		String caption = "file.txt"; // can be anything, but for Powerpoint, avoid the form "aaa (bbb.txt)" 
		
        // For link only
		String command = filepath;  // for embed case, Word uses a tmp file location. But link case points to the original file
		
		////////////////////////////////////////////////////////
		// Perform OLE

		// Link or embed?
		boolean OLE_LINK_ONLY = false;
		
		OleHelperPptx oleHelperPptx = new OleHelperPptx(pkg);
		if (OLE_LINK_ONLY) {
			
			oleHelperPptx.link(slidePart, topPts,  leftPts, imageBytes, mime,    embeddingType, caption, filepath);
			oleHelperPptx.link(slidePart2, topPts,  leftPts, imageBytes, mime,    embeddingType, caption, filepath);
			
		} else {
			
			oleHelperPptx.embed(slidePart, topPts,  leftPts, generateContent("1_1"), imageBytes, mime,  embeddingType, "file_1_1.txt", filepath, command);
			oleHelperPptx.embed(slidePart, topPts,  leftPts+100, generateContent("1_2"), imageBytes, mime,  embeddingType, "file_1_2.txt", filepath, command);

			oleHelperPptx.embed(slidePart2, topPts,  leftPts, generateContent("2_1"), imageBytes, mime,  embeddingType, "file_2_1.txt", filepath, command);
			oleHelperPptx.embed(slidePart2, topPts,  leftPts+100, generateContent("2_2"), imageBytes, mime,  embeddingType, "file_2_2.txt", filepath, command);
			oleHelperPptx.embed(slidePart2, topPts,  leftPts+200, generateContent("2_3"), imageBytes, mime,  embeddingType, "file_2_3.txt", filepath, command);

			oleHelperPptx.embed(slidePart3, topPts,  leftPts, generateContent("3_1"), imageBytes, mime,  embeddingType, "file_3_1.txt", filepath, command);
			
		}

		////////////////////////////////////////////////////////
		// Save the result
		pkg.save(new java.io.File(outputfilepath));
		
	}	
	
	private static byte[] generateContent(String suffix) {
		
		String content = "Your content goes here..." + suffix;
		return content.getBytes(); 
		
	}
	
	
}
