package com.plutext.samples.ole;
/*
 *  Copyright 2013, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */


import java.util.ArrayList;
import java.util.List;

import org.docx4j.TraversalUtil;
import org.docx4j.TraversalUtil.CallbackImpl;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.vml.CTImageData;
import org.docx4j.vml.CTShape;
import org.docx4j.vml.officedrawing.CTOLEObject;
import org.docx4j.wml.CTObject;

public class OLEObjectFinder {

	
	/**
	 * Example of how to find OLEObjects and their related parts
	 * 
        <w:object w:dxaOrig="1087" w:dyaOrig="1074">
          <v:shapetype id="_x0000_t75" coordsize="21600,21600" o:spt="75" o:preferrelative="t" path="m@4@5l@4@11@9@11@9@5xe" filled="f" stroked="f">
            <v:stroke joinstyle="miter"/>
            <v:formulas>
              <v:f eqn="if lineDrawn pixelLineWidth 0"/>
              <v:f eqn="sum @0 1 0"/>
              <v:f eqn="sum 0 0 @1"/>
              <v:f eqn="prod @2 1 2"/>
              <v:f eqn="prod @3 21600 pixelWidth"/>
              <v:f eqn="prod @3 21600 pixelHeight"/>
              <v:f eqn="sum @0 0 1"/>
              <v:f eqn="prod @6 1 2"/>
              <v:f eqn="prod @7 21600 pixelWidth"/>
              <v:f eqn="sum @8 21600 0"/>
              <v:f eqn="prod @7 21600 pixelHeight"/>
              <v:f eqn="sum @10 21600 0"/>
            </v:formulas>
            <v:path o:extrusionok="f" gradientshapeok="t" o:connecttype="rect"/>
            <o:lock v:ext="edit" aspectratio="t"/>
          </v:shapetype>
          <v:shape id="_x0000_i1032" type="#_x0000_t75" style="width:54.35pt;height:53.65pt" o:ole="">
            <v:imagedata r:id="rId5" o:title=""/>
          </v:shape>
          <o:OLEObject Type="Embed" ProgID="MDLDrawOLE.MDLDrawObject.1" ShapeID="_x0000_i1032" DrawAspect="Content" ObjectID="_1426939992" r:id="rId6">
            <o:FieldCodes>\s</o:FieldCodes>
          </o:OLEObject>
        </w:object>	
        
         or 
         
        <w:object w:dxaOrig="1074" w:dyaOrig="992">
          <v:shape id="_x0000_i1030" type="#_x0000_t75" style="width:53.65pt;height:49.6pt" o:ole="">
            <v:imagedata r:id="rId7" o:title=""/>
          </v:shape>
          <o:OLEObject Type="Embed" ProgID="MDLDrawOLE.MDLDrawObject.1" ShapeID="_x0000_i1030" DrawAspect="Content" ObjectID="_1426939993" r:id="rId8">
            <o:FieldCodes>\s</o:FieldCodes>
          </o:OLEObject>
        </w:object>
         
	 */
	public static void main(String[] args) throws Exception {

		String inputfilepath = System.getProperty("user.dir") + "/OleObject.docx";
				
		WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new java.io.File(inputfilepath));		
		MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
				
    	Finder finder = new Finder(CTObject.class); // <----- change this to suit
		new TraversalUtil(documentPart.getContent(), finder);
		
		System.out.println("got " + finder.results.size() + " of type " +  finder.typeToFind.getName() );
		
		for (Object o : finder.results) {
						
			CTObject object = (CTObject) XmlUtils.unwrap(o); 
			
			CTOLEObject oleObject = getOLEObject(object); 
			if (oleObject==null) {
				System.out.println("No OLEObject in this Object");			
			} else {
				Part target = documentPart.getRelationshipsPart().getPart(oleObject.getId());
				System.out.println(target.getClass().getName());
				// expect org.docx4j.openpackaging.parts.WordprocessingML.OleObjectBinaryPart
			}
			
			CTShape shape = getShape(object); 
			if (shape==null) {
				System.out.println("No Shape in this Object");			
			} else {
				CTImageData imageData = (CTImageData)XmlUtils.unwrap(shape.getPathOrFormulasOrHandles().get(0));
					// You should make this more robust
				if (imageData==null) {
					System.out.println("No imagedata in this Object");								
				} else {
					Part target = documentPart.getRelationshipsPart().getPart(imageData.getId());
					System.out.println(target.getClass().getName());
					// expect org.docx4j.openpackaging.parts.WordprocessingML.MetafileEmfPart
				}
			}
		}
								
	}
	
	  public static class Finder extends CallbackImpl {
		  
		  protected Class<?> typeToFind;
		  
		  protected Finder(Class<?> typeToFind) {
			  this.typeToFind = typeToFind;
		  }
			
			public List<Object> results = new ArrayList<Object>(); 
			
			@Override
			public List<Object> apply(Object o) {
				
				// Adapt as required
				if (o.getClass().equals(typeToFind)) {
					results.add(o);
				}
				return null;
			}
	  }
	  
	  private static CTOLEObject getOLEObject(CTObject object) {
		  
		  for (Object o : object.getAnyAndAny()) {
			  Object o2 = XmlUtils.unwrap(o);
			  if(o2 instanceof CTOLEObject) return (CTOLEObject)o2;			  
		  } 
		  return null;
	  }
	  
	  private static CTShape getShape(CTObject object) {
		  
		  for (Object o : object.getAnyAndAny()) {
			  Object o2 = XmlUtils.unwrap(o);
			  if(o2 instanceof CTShape) return (CTShape)o2;			  
		  } 
		  return null;
	  }
		
}
