package com.plutext.samples.ole;
/*
 *  Copyright 2016, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */




import java.io.File;

import org.apache.commons.io.FileUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.P;
import org.docx4j.wml.R;

import com.plutext.ole.EmbeddingType;
import com.plutext.ole.OleHelperDocx;

/**
 * Example of how to link or embed an existing binary .vsd
 * as an OleObjectBinaryPart inside a docx
 * 
 * OLE handling of binary doc/ppt/vsd/xls is a bit
 * different to how other OLE objects are handled.
 * 
 * @author Jason Harrop
 */
public class Docx_ole_vsd {

	static org.docx4j.wml.ObjectFactory wmlObjectFactory = org.docx4j.jaxb.Context.getWmlObjectFactory();
	
	public static void main(String[] args) throws Exception {
		
				
		////////////////////////////////////////////////////////
		// For this sample, create a docx package using docx4j

		WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
		MainDocumentPart mdp = wordMLPackage.getMainDocumentPart();

		
		////////////////////////////////////////////////////////
		// OLE config

		EmbeddingType embeddingType = EmbeddingType.VSD;

		// Link or embed?
		boolean OLE_LINK_ONLY = false;
		
		// Embed
		byte[] contentBytes = FileUtils.readFileToByteArray(
				new File(System.getProperty("user.dir")
						+"/src/samples/OLE/resources/Drawing1.vsd" ));
		
        // or link 
        String targetURL = "file:///F:/Drawing1.vsd";    // the actual location
		
		// the image on the document surface
		byte[] imageBytes = null; // use a file icon
		// imageBytes = FileUtils.readFileToByteArray(new File(System.getProperty("user.dir")+"/greentick.png" ));
		
		// if you know your image mime type, you can avoid image introspection (which avoids temp file creation)
		String mime = "image/png"; // .. otherwise, set this to null
		
		String caption = "the caption"; // can be anything, but may be used if displaying content rather than icon 		
		
		// position in docx content list
		int index = -1; // place at end
				
		
		
		////////////////////////////////////////////////////////
		// Perform OLE

		P p = new P();
		if (index < 0) {
			mdp.getContents().getContent().add(p);
		} else {
			mdp.getContents().getContent().add(index, p);			
		}
		
		OleHelperDocx OleHelperDocx = new OleHelperDocx(wordMLPackage);
		if (OLE_LINK_ONLY) { 
			
			R r = OleHelperDocx.linkOffice(embeddingType, caption, targetURL, imageBytes);
			p.getContent().add(r);

		    // Save the resulting docx
			wordMLPackage.save(new File(System.getProperty("user.dir")
					+ "/OUT_vsd_linked.docx"));
			
		} else {
			
			R r = OleHelperDocx.embedOffice(embeddingType, caption,				 
					contentBytes, imageBytes);
			p.getContent().add(r);

		    // Save the resulting docx
			wordMLPackage.save(new File(System.getProperty("user.dir")
					+ "/OUT_vsd_embedded.docx"));
			
		}
	}
		
	


}
