package com.plutext.samples.ole;
/*
 *  Copyright 2013, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */




import java.io.File;

import org.apache.commons.io.FileUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.P;
import org.docx4j.wml.R;

import com.plutext.ole.EmbeddingType;
import com.plutext.ole.OleHelperDocx;

/**
 * Example of how to link or embed csv text content
 * as an OleObjectBinaryPart inside a docx 
 * 
 * Note that the extension in String command is
 * used to work out which application opens the file.
 * It has to be .csv if you want Excel to open the CSV.
 *  
 * 
 * @author Jason Harrop
 */
public class Docx_ole_csv {

	
	public static void main(String[] args) throws Exception {
		
		
		////////////////////////////////////////////////////////
		// For this sample, create a docx package using docx4j

		WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
		MainDocumentPart mdp = wordMLPackage.getMainDocumentPart();
		
		////////////////////////////////////////////////////////
		// OLE config

		EmbeddingType embeddingType = EmbeddingType.CSV; // CSV is a text format, so could use TXT

		// Link or embed?
		boolean OLE_LINK_ONLY = false;
		
		// Embed
		byte[] contentBytes = FileUtils.readFileToByteArray(new File(System.getProperty("user.dir")+"/Book1.csv" ));
		
		// the image on the document surface
		byte[] imageBytes = FileUtils.readFileToByteArray(new File(System.getProperty("user.dir")+"/greentick.png" ));
		
		// if you know your image mime type, you can avoid image introspection (which avoids temp file creation)
		String mime = "image/png"; // .. otherwise, set this to null
		
		// position in docx content list
		int index = -1; // place at end
				
		// Both link and embed require this
        String filepath = "C:\\Users\\jharrop\\Documents\\yoursheetname.csv";    // typically the original file location
		String caption = "file.txt"; // can be anything, but may be used if displaying content rather than icon 
        // must use csv extension in below if you want Excel to open the embedded file
		String command ="C:\\Users\\jharrop\\AppData\\Local\\Temp\\yoursheetname.csv"; // a temp file location
		
        // For link only
		String targetURL = "file:///" + command;

		
		////////////////////////////////////////////////////////
		// Perform OLE
		
		P p = new P();
		if (index < 0) {
			mdp.getContents().getContent().add(p);
		} else {
			mdp.getContents().getContent().add(index, p);			
		}
		
		OleHelperDocx OleHelperDocx = new OleHelperDocx(wordMLPackage);
		if (OLE_LINK_ONLY) {
			
			R r = OleHelperDocx.link( embeddingType, 
					caption, filepath, command, targetURL, imageBytes);
			p.getContent().add(r);

		    // Save the resulting docx
			wordMLPackage.save(new File(System.getProperty("user.dir")
					+ "/OUT_csv_linked.docx"));
			
		} else {
			
			R r = OleHelperDocx.embed( embeddingType, 
					caption, filepath, command, 
					contentBytes, imageBytes);
			p.getContent().add(r);

		    // Save the resulting docx
			wordMLPackage.save(new File(System.getProperty("user.dir")
					+ "/OUT_csv_embedded.docx"));
			
		}



		
		
		
	}
	
	
}
