package com.plutext.samples.ole;
/*
 *  Copyright 2013, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */




import java.io.File;

import org.apache.commons.io.FileUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.P;

import com.plutext.ole.pdf.PdfOleHelperDocx;

/**
 * Example of how to link or embed an existing PDF
 * as an OleObjectBinaryPart inside a docx  
 * 
 * OLE handling of PDF is a bit
 * different to how other OLE objects are handled.
 * 
 * @author Jason Harrop
 */
public class Docx_ole_PDF  {

	static org.docx4j.wml.ObjectFactory wmlObjectFactory = org.docx4j.jaxb.Context.getWmlObjectFactory();
	
	public static void main(String[] args) throws Exception {

		
		
		////////////////////////////////////////////////////////
		// For this sample, create a docx package using docx4j

		WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
		MainDocumentPart mdp = wordMLPackage.getMainDocumentPart();
		
		////////////////////////////////////////////////////////
		// OLE config


		// Link or embed?
		boolean OLE_LINK_ONLY = false;
		
		// Embed
		byte[] contentBytes = FileUtils.readFileToByteArray(new File(System.getProperty("user.dir")+"/src/main/resources/sample.pdf" ));
		
		// typically here you'd use an image representation of the first page of your PDF;
		// creating that is outside the scope of docx4j, but see https://stackoverflow.com/questions/23326562/convert-pdf-files-to-images-with-pdfbox
		byte[] imageBytes =FileUtils.readFileToByteArray(new File(System.getProperty("user.dir")+"/src/main/resources/greentick.png" ));


		////////////////////////////////////////////////////////
		// Perform OLE
		
		PdfOleHelperDocx pdfOleHelper = new PdfOleHelperDocx(wordMLPackage);
		if (OLE_LINK_ONLY) {

			pdfOleHelper.link(-1, "file:///C:\\Users\\jharrop\\git\\docx4j-OLE\\pdf4.pdf", contentBytes);

		    // Save the resulting docx		
			wordMLPackage.save(new File(System.getProperty("user.dir")
					+ "/OUT_PDF_linked.docx"));
			
		} else {			

//			pdfOleHelper.embedUsingImage(
//					contentBytes, -1, null,
//				"image/png",  null);	// null style should be ok		

			pdfOleHelper.embedUsingImage(
					contentBytes, -1, imageBytes);			
			
		    // Save the resulting docx		
			wordMLPackage.save(new File(System.getProperty("user.dir")
					+ "/OUT_PDF_embedded.docx"));
			
		}
		
						
	}
	
	
	
	
}
