package com.plutext.samples.ole;
/*
 *  Copyright 2013, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */




import java.io.File;

import org.apache.commons.io.FileUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.P;

import com.plutext.ole.EmbeddingType;
import com.plutext.ole.odf.OdfOleHelperDocx;
import com.plutext.ole.pdf.PdfOleHelperDocx;

/**
 * Example of how to link or embed an existing ODF
 * (eg ODT text file or ODP presentation)
 * as an OleObjectBinaryPart inside a docx  
 * 
 * OLE handling of ODF is a bit
 * different to how most other OLE objects are handled.
 * 
 * @author Jason Harrop
 */
public class Docx_ole_ODF  {

	static org.docx4j.wml.ObjectFactory wmlObjectFactory = org.docx4j.jaxb.Context.getWmlObjectFactory();
	
	public static void main(String[] args) throws Exception {

		
		////////////////////////////////////////////////////////
		// For this sample, create a docx package using docx4j

		WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
		MainDocumentPart mdp = wordMLPackage.getMainDocumentPart();
		
		////////////////////////////////////////////////////////
		// OLE config

		byte[] contentBytes = FileUtils.readFileToByteArray(
				new java.io.File(System.getProperty("user.dir") + "/hello world.ods")
				);
		
		EmbeddingType embeddingType = EmbeddingType.ODS; // ODT, ODP, ODS, to match filetype above

		// Link or embed?
		boolean OLE_LINK_ONLY = false;

		
		/* If you get the error:
		 * 
		 *   The program used to create this object is Word.  That program is either not 
		 *   installed on your computer or it is not responding.  To edit this object,
		 *   install Word or ensure that any dialog boxes in Word are closed.
		 *   
		 * when you try to activate in Word the object in the resulting docx, 
		 * check that Word is able to open the ODF object you are trying to embed.
		 * If Word says "The file .. cannot be opened because there are problems with the
		 * contents", this is probably the cause of the error ie Word doesn't like
		 * the original ODF object.
		 * 
		 * My Word 2010 x64 wants to repair the simplest ODT created in OO 4.0.14
		 * or LO 4.1.4, so to maximise chances of compatibility,
		 * recommend you save your ODT using Word itself 
		 * 
		 * The reason is that Office 2010 only supports ODF 1.1, but
		 * OO 4.0.14 and LO 4.1.4 both create ODF 1.2 files.  
		 * Office 2013 can read ODF 1.2 files.
		 * 
		 */

		byte[] imageBytes =FileUtils.readFileToByteArray(new File(System.getProperty("user.dir")+"/greentick.png" ));
        String filepath = "C:\\Users\\jharrop\\Documents\\alpha.ods";    // typically the original file location
		String command = filepath;  // for embed case, Word uses a tmp file location. But link case points to the original file
		

		////////////////////////////////////////////////////////
		// Perform OLE
		
		
		OdfOleHelperDocx odfOleHelper = new OdfOleHelperDocx(wordMLPackage);
		if (OLE_LINK_ONLY) {

			odfOleHelper.linkUsingIcon(embeddingType, "file:///C:\\Users\\jharrop\\git\\docx4j-OLE\\Untitled.odt", -1, "some caption");

		    // Save the resulting docx		
			wordMLPackage.save(new File(System.getProperty("user.dir")
					+ "/OUT_" + embeddingType.name() +"_linked.docx"));
			
		} else {			

//			odfOleHelper.embedUsingIcon(embeddingType, contentBytes, -1, "some caption");		
			odfOleHelper.embedEditInPlace(embeddingType, contentBytes, -1, imageBytes);

		    // Save the resulting docx		
			wordMLPackage.save(new File(System.getProperty("user.dir")
					+ "/OUT_" + embeddingType.name() +"_embedded.docx"));
			
		}
		
						
	}
	
	
	
	
}
