package com.plutext.samples.ole;
/*
 *  Copyright 2013, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */




import java.io.File;

import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.P;
import org.docx4j.wml.R;

import com.plutext.ole.EmbeddingType;
import com.plutext.ole.OleHelperDocx;

/**
 * Example of how to link or embed text content
 * as an OleObjectBinaryPart inside a docx  
 * 
 * @author Jason Harrop
 */
public class Docx_ole_MHT_WebArchive {

	static org.docx4j.wml.ObjectFactory wmlObjectFactory = org.docx4j.jaxb.Context.getWmlObjectFactory();
	
	public static void main(String[] args) throws Exception {
				
		////////////////////////////////////////////////////////
		// For this sample, create a docx package using docx4j

		WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
		MainDocumentPart mdp = wordMLPackage.getMainDocumentPart();
		
		////////////////////////////////////////////////////////
		// OLE config

		EmbeddingType embeddingType = EmbeddingType.MHT; 

		// Link or embed?
		boolean OLE_LINK_ONLY = false;
		
		// Embed
		byte[] contentBytes = FileUtils.readFileToByteArray(
				new java.io.File(System.getProperty("user.dir") + "/sample_web.mht")
				);
		
		
		// position in docx content list
		int index = -1; // place at end
				
		// Both link and embed require this
        String filepath = "C:\\Users\\jharrop\\Documents\\the.mht";     // typically the original file location
		String caption = "the.html"; // can be anything
		//String command ="C:\\Users\\jharrop\\AppData\\Local\\Temp\\my.html"; // a temp file location, will be used by Chrome
		String command ="Q:\\foo.mht"; // You should get the file extension correct, since it will determine what program opens it
		// the path doesn't matter; it will become something like file:///C:/Users/jharrop/AppData/Local/Temp/
		
		// the image on the document surface
		byte[] imageBytes = null; //IconGenerator.createIcon(embeddingType, caption);
				// if imageBytes was null, IconGenerator would be used like that anyway
		
        // For link only
		String targetURL = "file:///" + command;

		
		////////////////////////////////////////////////////////
		// Perform OLE
		
		P p = new P();
		if (index < 0) {
			mdp.getContents().getContent().add(p);
		} else {
			mdp.getContents().getContent().add(index, p);			
		}
		
		OleHelperDocx OleHelperDocx = new OleHelperDocx(wordMLPackage);
		if (OLE_LINK_ONLY) {
			
			R r = OleHelperDocx.link( embeddingType, caption, filepath, command, targetURL, imageBytes);
			p.getContent().add(r);

		    // Save the resulting docx
			wordMLPackage.save(new File(System.getProperty("user.dir")
					+ "/OUT_MHT_linked.docx"));
			
		} else {
			
			R r = OleHelperDocx.embed( embeddingType, 
					caption, filepath, command, 
					contentBytes, imageBytes);
			p.getContent().add(r);

		    // Save the resulting docx
			wordMLPackage.save(new File(System.getProperty("user.dir")
					+ "/OUT_MHT_embedded.docx"));
			
		}

		
	}
	
	
}
