package com.plutext.samples.ole;
/*
 *  Copyright 2013, Plutext Pty Ltd.
 *   
 *  This sample file is licensed under the Apache License, Version 2.0 (the "License"); 
    you may not use this file except in compliance with the License. 

    You may obtain a copy of the License at 

        http://www.apache.org/licenses/LICENSE-2.0 

    Unless required by applicable law or agreed to in writing, software 
    distributed under the License is distributed on an "AS IS" BASIS, 
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
    See the License for the specific language governing permissions and 
    limitations under the License.

 */




import java.io.File;

import org.apache.commons.io.FileUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;

import com.plutext.ole.EmbeddingType;
import com.plutext.ole.OleHelperDocx;

/**
 * Example of how to embed multiple objects inside a docx  
 * 
 * @author Jason Harrop
 */
public class Docx_Embed_Multiple_Objects  {

	
	public static void main(String[] args) throws Exception {
		
		WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
		
		String dir = System.getProperty("user.dir")+"/safran/";
		
		OleHelperDocx oleHelperDocx = new OleHelperDocx(wordMLPackage);
		
		embed( oleHelperDocx, EmbeddingType.CSV, new File(dir + "csv1.csv"), new File(dir + "image1.png"));
		embed( oleHelperDocx, EmbeddingType.CSV, new File(dir + "csv3.csv"), new File(dir + "image3.png"));
		embed( oleHelperDocx, EmbeddingType.CSV, new File(dir + "csv4.csv"), new File(dir + "image4.png"));
        
		embed( oleHelperDocx, EmbeddingType.XML, new File(dir + "x5.xml"), new File(dir + "image5.png"));
		embed( oleHelperDocx, EmbeddingType.XML, new File(dir + "x5.xml"), new File(dir + "image6.png"));
        
		wordMLPackage.save(new File(System.getProperty("user.dir")
				+ "/OUT_multiple_embeddings.docx"));
	}
	
	
	public static void embed(OleHelperDocx OleHelperDocx, EmbeddingType embeddingType, 
			File content, File imgFile) throws Exception 
			  {

		////////////////////////////////////////////////////////
		// OLE config
      
        byte[] newContent = FileUtils.readFileToByteArray(content);
        
		// the image on the document surface
		byte[] imageBytes = FileUtils.readFileToByteArray(imgFile);
		
		// if you know your image mime type, you can avoid image introspection (which avoids temp file creation)
		String mime = "image/png"; // .. otherwise, set this to null
		
		// position in docx content list
		int index = -1; // place at end
        
        
		String caption = "embedded";
		
		// Usually the name of the source file, but can be any string
        String filepath = content.getPath();

		String command =filepath; // command should have correct suffix though
        		
		////////////////////////////////////////////////////////
		// Perform OLE
		OleHelperDocx.embed(index, embeddingType, 
				caption, filepath, command, 
				newContent, imageBytes);
		

		
	}
	
	
}
