package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.TraversalUtil;
import org.docx4j.TraversalUtil.CallbackImpl;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.P;
import org.docx4j.wml.STPageOrientation;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.SectPr.PgSz;

import com.plutext.merge.BlockRange;
import com.plutext.merge.BlockRange.HfBehaviour;
import com.plutext.merge.BlockRange.SectionBreakBefore;
import com.plutext.merge.DocumentBuilder;


public class NormalizePageSizes {
	
	public final static String DIR_IN = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/";
	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	public static void main(String[] args) throws Exception {
				
		String[] files = {"IntegersOnly.docx", "UN-Declaration.docx" , "SolarSystem.docx"};
		
		List<BlockRange> blockRanges = new ArrayList<BlockRange>();
		for (int i=0 ; i< files.length; i++) {
			BlockRange block = new BlockRange(WordprocessingMLPackage.load(
					new File(DIR_IN + files[i])));
			blockRanges.add( block );
			
			// No pages breaks
			block.setSectionBreakBefore(SectionBreakBefore.CONTINUOUS);
			
			// if you want no headers on the pages from docx2:
			block.setHeaderBehaviour(HfBehaviour.NONE);
		}
		
		// Perform the actual merge
		DocumentBuilder documentBuilder = new DocumentBuilder();
		WordprocessingMLPackage output = documentBuilder.buildOpenDocument(blockRanges);
		
		if (output.getMainDocumentPart().getJaxbElement().getBody().getSectPr()!=null)
		{
			PgSz pgSz = output.getMainDocumentPart().getJaxbElement().getBody().getSectPr().getPgSz();		
			normalizeSectPrs(output, pgSz);
		}
		
		
		// Save the result
		Docx4J.save(output, 
				new File(DIR_OUT+"OUT_NormalizePageSizes.docx"), 
				Docx4J.FLAG_NONE);		
		
	}
	
    /**
	 * Normalize all sectPrs in document
	 */
	public static void normalizeSectPrs(WordprocessingMLPackage wordMLPackage, PgSz pgSz) throws InvalidFormatException {
		
		MainDocumentPart mdp = wordMLPackage.getMainDocumentPart();
		
		// Find all sectPr
    	SectPrFinder sf = new SectPrFinder();
		new TraversalUtil(mdp.getContent(), sf);

		
		for(SectPr sectPr : sf.sectPrs) {
			
			if (sectPr.getPgSz().getOrient()!=null
					&& sectPr.getPgSz().getOrient().equals(STPageOrientation.LANDSCAPE)) {
				// don't normalise pgSize of a landscape oriented section
			} else {
				// normal case
				sectPr.setPgSz(pgSz); // no need to clone
			}
		}
		
	}
	
	
	  public static class SectPrFinder extends CallbackImpl {
			
			public List<SectPr> sectPrs = new ArrayList<SectPr>(); 
			
			@Override
			public List<Object> apply(Object o) {
				
				if (o instanceof P
						&& ((P)o).getPPr()!=null 
						&& ((P)o).getPPr().getSectPr()!=null) {
					sectPrs.add(
							((P)o).getPPr().getSectPr()
							);
				}
				return null;
			}
	  }
 	
}
