package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.RandomStringUtils;
import org.docx4j.Docx4J;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;

import com.plutext.merge.BlockRange;
import com.plutext.merge.BlockRange.HfBehaviour;
import com.plutext.merge.BlockRange.NumberingHandler;
import com.plutext.merge.BlockRange.SectionBreakBefore;
import com.plutext.merge.BlockRange.StyleHandler;
import com.plutext.merge.DocumentBuilder;


public class MergeWholeDocumentsUsingBlockRange {
	
	public final static String DIR_IN = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/";
	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	public static void main(String[] args) throws Exception {
				
		String[] files = {"IntegersOnly.docx", "UN-Declaration.docx" , "SolarSystem.docx"};		
		
		List<BlockRange> blockRanges = new ArrayList<BlockRange>();
		for (int i=0 ; i< files.length; i++) {
			BlockRange block = new BlockRange(WordprocessingMLPackage.load(
					new File(DIR_IN + files[i])));
			blockRanges.add( block );
			
			// Uncomment this to write diagnostic info into the output docx
			// block.setDiagnostics(true);
			
			block.setNumberingHandler(NumberingHandler.USE_EARLIER);
			
			// No pages breaks
			//block.setSectionBreakBefore(SectionBreakBefore.CONTINUOUS);
			
			// if you want no headers on the pages from docx2:
			block.setHeaderBehaviour(HfBehaviour.NONE);
			
			if (i>0) {
				block.setStyleHandler(StyleHandler.RENAME_RETAIN);
			}
		}
		
		// Perform the actual merge
		DocumentBuilder documentBuilder = new DocumentBuilder();
		// .. optional string to use in generated style names
		//documentBuilder.setMergeJobStyleCrumb(RandomStringUtils.random(5, "23456789bcdfghjkmnpqrstvwxyzBCDFGHJKMNPQRSTVWXYZ") );
		WordprocessingMLPackage output = documentBuilder.buildOpenDocument(blockRanges);
		
		// Save the result
		Docx4J.save(output, 
				new File(DIR_OUT+"OUT_MergeWholeDocumentsUsingBlockRange.docx"), 
				Docx4J.FLAG_NONE);		
		
		
	}	
}
