package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;

import com.plutext.merge.BlockRange;
import com.plutext.merge.BlockRange.HfBehaviour;
import com.plutext.merge.BlockRange.SectionBreakBefore;
import com.plutext.merge.DocumentBuilder;


/**
 * If the last P in docx1 contains "The cat " and
 * the firstP in docx2 contains "sat on the mat",
 * the merged docx will contain a merged p "The cat sat on the mat"
 * 
 * @author jharrop
 *
 */
public class MergeParagraphs {
	
	public final static String DIR_IN = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/";
	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	public static void main(String[] args) throws Exception {
				
		String[] files = {"Cat.docx", "Mat.docx" };
		
		List<BlockRange> blockRanges = new ArrayList<BlockRange>();
		for (int i=0 ; i< files.length; i++) {
			BlockRange block = new BlockRange(WordprocessingMLPackage.load(
					new File(DIR_IN + files[i])));
			blockRanges.add( block );
			
			// No pages breaks
			block.setSectionBreakBefore(SectionBreakBefore.NONE_MERGE_PARAGRAPH);
			
			// if you want no headers on the pages from docx2:
			block.setHeaderBehaviour(HfBehaviour.NONE);
		}
		
		// Perform the actual merge
		DocumentBuilder documentBuilder = new DocumentBuilder();
		WordprocessingMLPackage output = documentBuilder.buildOpenDocument(blockRanges);
		
		// Save the result
		Docx4J.save(output, 
				new File(DIR_OUT+"OUT_MergeParagraphs.docx"), 
				Docx4J.FLAG_NONE);		
		
	}	
}
