package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;

import com.plutext.merge.BlockRange;
import com.plutext.merge.BlockRange.HfBehaviour;
import com.plutext.merge.BlockRange.SectionBreakBefore;
import com.plutext.merge.DocumentBuilder;


/**
 * 
 * For further examples, see source code DocumentBuilderBlockRangeIDRefTest
 * 
 * @author jharrop
 *
 */
public class MergeIntoTableCell {
	
	static boolean save = true;
	
	public final static String DIR_IN = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/";
	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	public static void main(String[] args) throws Exception {
				
		// The document containing the table
		String file1 = DIR_IN + "BlockRange_IDREF.docx";
		
		// The document to be inserted (tableContent)
		String file2 = DIR_IN + "simple.docx";
		
		BlockRange source1 = new BlockRange(WordprocessingMLPackage.load(new File(file1)));
		
		BlockRange tableContent = new BlockRange(WordprocessingMLPackage.load(new File(file2)));
		tableContent.setID("myTableContent");  // sets SectionBreakBefore.NONE as a side effect, since it is assumed you want this
		
		List<BlockRange> sources = new ArrayList<BlockRange>();
		sources.add(tableContent);  
		sources.add(source1);
		
		DocumentBuilder documentBuilder = new DocumentBuilder();
		WordprocessingMLPackage output = documentBuilder.buildOpenDocument(sources);

		System.out.println(output.getMainDocumentPart().getXML());
				
		// Save the result
		if (save) {		
			Docx4J.save(output, 
					new File(DIR_OUT+"OUT_MergeIntoTableCell.docx"), 
					Docx4J.FLAG_NONE);		
		}
		
	}	
}
