package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.plutext.merge.BlockRange;
import com.plutext.merge.BlockRange.HfBehaviour;
import com.plutext.merge.BlockRange.SectionBreakBefore;
import com.plutext.merge.BlockRange.StyleHandler;

import com.plutext.merge.DocumentBuilder;
import com.plutext.merge.DocumentBuilderIncremental;


/**
 * "Many documents": a memory efficient approach
 * for merging many documents.
 * 
 * @author jharrop
 *
 */
public class MergeIncremental {
	
	public final static String DIR_IN = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/";
	public final static String DIR_OUT = System.getProperty("user.dir");

	protected static Logger log = LoggerFactory.getLogger(MergeIncremental.class);
	
	public static void main(String[] args) throws Exception {
				
		String[] files = {"IntegersOnly.docx", "UN-Declaration.docx" , "SolarSystem.docx"};		
		
        DocumentBuilderIncremental dbi = new DocumentBuilderIncremental();

        for (int i = 0; i < files.length; i++) {

        	log.info("\n\rMerging " + files[i]);

            BlockRange block = new BlockRange(Docx4J.load(new File(DIR_IN + files[i])));

            block.setSectionBreakBefore(BlockRange.SectionBreakBefore.NEXT_PAGE);
            if (i==0) {
            	block.setHeaderBehaviour(BlockRange.HfBehaviour.DEFAULT);
            	block.setFooterBehaviour(BlockRange.HfBehaviour.DEFAULT);
            } else {
            	// Avoid creating unnecessary additional header/footer parts
            	block.setHeaderBehaviour(BlockRange.HfBehaviour.INHERIT);
            	block.setFooterBehaviour(BlockRange.HfBehaviour.INHERIT);	
            }
            	
			block.setStyleHandler(StyleHandler.RENAME_RETAIN);
            	
            
//            System.out.println("\n\r\n\r" + i + "\n\r\n\r");
            dbi.addBlockRange(block, i==(files.length-1) );  // 2nd param is whether this is your last docx
            
            // example of manipulating the output as it is generated 
            // dbi.getPkgInProgress().getMainDocumentPart().addParagraphOfText("");
        }
        
        WordprocessingMLPackage output = dbi.finish();// Get the output docx
		
		// Save the result
        String resultFile = "OUT_MergeDocx.docx";
		Docx4J.save(output, 
				new File(DIR_OUT+resultFile), 
				Docx4J.FLAG_NONE);		
		
		log.info("\n\rDone. Output " + resultFile);
		
	}	
}
