package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;

import com.plutext.merge.BlockRange;
import com.plutext.merge.DocumentBuilder;
import com.plutext.merge.BlockRange.NumberingHandler;
import com.plutext.merge.BlockRange.StyleHandler;
import com.plutext.merge.DocumentBuilderIncremental;


/**
 * Merge the contents of a directory.  Note it is generally more efficient to use 
 * DocumentBuilderIncremental.  See MergeDirectoryContents sample for that approach.
 * 
 * @author jharrop
 *
 */
public class MergeDirectoryContentsIteratively {
	
	public final static String DIR_IN = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/";
	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	
	public static void main(String[] args) throws Exception {
		
		WordprocessingMLPackage doc = null;
				
        File root = new File( DIR_IN );
        File[] files = root.listFiles();
		
        long startProcess = System.currentTimeMillis();
        DocumentBuilderIncremental dbi = new DocumentBuilderIncremental();

        StringBuilder merges = new StringBuilder(); 
        StringBuilder skips = new StringBuilder(); 
        
        for (int i = 0; i < files.length; i++) {
        	
        	File f = files[i];

        	if (!f.getName().toLowerCase().endsWith("docx")) {
        		skips.append(f.getName() + ", ");
        		continue;
        	}


            if (i==0) {
           	
            	doc = Docx4J.load(f);
            	
            } else {
                System.out.println("\n\r\n\r" + i + "\n\r\n\r");
                long start = System.currentTimeMillis();

                BlockRange block = new BlockRange(Docx4J.load(f));

	            block.setSectionBreakBefore(BlockRange.SectionBreakBefore.NEXT_PAGE);

	            // Set to .INHERIT to avoid creating unnecessary additional header/footer parts
            	block.setHeaderBehaviour(BlockRange.HfBehaviour.DEFAULT);
            	block.setFooterBehaviour(BlockRange.HfBehaviour.DEFAULT);
            	
				block.setNumberingHandler(NumberingHandler.ADD_NEW_LIST);
				block.setRestartPageNumbering(Boolean.FALSE);

//				block.setStyleHandler(StyleHandler.RENAME_RETAIN);
				block.setStyleHandler(StyleHandler.USE_EARLIER);
				
				DocumentBuilder documentBuilder = new DocumentBuilder();
				List<BlockRange> blockRanges = new ArrayList<BlockRange>();
				blockRanges.add( new BlockRange(doc) );
				blockRanges.add( block );

				doc = documentBuilder.buildOpenDocument(blockRanges);

	            long end = System.currentTimeMillis();
	            long duration = end - start;
	            
	    		merges.append(duration + "\t" + f.getName() + "\n ");
				
            }
        }
        
        long endProcess = System.currentTimeMillis();
        long durationProcess = endProcess - startProcess;
		
		// Save the result
		Docx4J.save(doc, 
				new File(DIR_OUT+"OUT_MergeWholeDocumentsIterative.docx"), 
				Docx4J.FLAG_NONE);		
		
		System.out.println("Merged:\n " + merges.toString());
		System.out.println("SKIPPED: " + skips.toString());
		
		System.out.println("time taken: " + durationProcess/1000 + " seconds.");
	}	
}
