package com.plutext.samples.mergedocx;
import java.io.File;

import org.docx4j.Docx4J;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;

import com.plutext.merge.BlockRange;
import com.plutext.merge.BlockRange.StyleHandler;
import com.plutext.merge.DocumentBuilderIncremental;


public class MergeDirectoryContents {
	
	public final static String DIR_IN = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/";
	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	
	public static void main(String[] args) throws Exception {
				
        File root = new File( DIR_IN );
        File[] files = root.listFiles();
		
        DocumentBuilderIncremental dbi = new DocumentBuilderIncremental();

        StringBuilder merges = new StringBuilder(); 
        StringBuilder skips = new StringBuilder(); 
        
        for (int i = 0; i < files.length; i++) {
        	
        	File f = files[i];

        	if (!f.getName().toLowerCase().endsWith("docx")) {
        		skips.append(f.getName() + ", ");
        		continue;
        	}

            BlockRange block = new BlockRange(Docx4J.load(f));

            block.setSectionBreakBefore(BlockRange.SectionBreakBefore.NEXT_PAGE);
            if (i==0) {
            	block.setHeaderBehaviour(BlockRange.HfBehaviour.DEFAULT);
            	block.setFooterBehaviour(BlockRange.HfBehaviour.DEFAULT);
            } else {
            	// Set to .INHERIT to avoid creating unnecessary additional header/footer parts
            	block.setHeaderBehaviour(BlockRange.HfBehaviour.DEFAULT);
            	block.setFooterBehaviour(BlockRange.HfBehaviour.DEFAULT);
            }
            	
			block.setStyleHandler(StyleHandler.RENAME_RETAIN);
            	
            
            System.out.println("\n\r\n\r" + i + "\n\r\n\r");
            dbi.addBlockRange(block, i==(files.length-1) );  // 2nd param is whether this is your last docx

    		merges.append(f.getName() + ", ");
            
            // example of manipulating the output as it is generated 
            // dbi.getPkgInProgress().getMainDocumentPart().addParagraphOfText("");
        }
        
        WordprocessingMLPackage output = dbi.finish();// Get the output docx
		
		// Save the result
		Docx4J.save(output, 
				new File(DIR_OUT+"OUT_MergeWholeDocumentsIncremental.docx"), 
				Docx4J.FLAG_NONE);		
		
		System.out.println("Merged: " + merges.toString());
		System.out.println("SKIPPED: " + skips.toString());
		
	}	
}
