package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;

import com.plutext.merge.BlockRange;
import com.plutext.merge.BlockRange.HfBehaviour;
import com.plutext.merge.BlockRange.SectionBreakBefore;
import com.plutext.merge.BlockRange.StyleHandler;
import com.plutext.merge.DocumentBuilder;
import com.plutext.merge.DocumentBuilderIncremental;


/**
 * Output total N copies of the input docx. 
 * 
 * @author jharrop
 *
 */
public class MergeCopyNTimes {
	
	public final static String DIR_IN = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/";
	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	public static void main(String[] args) throws Exception {
				
		String file = "UN-Declaration.docx";
		int N = 3; // how many copies to appear in total (ie including the original)
		
		
        DocumentBuilderIncremental dbi = new DocumentBuilderIncremental();

        WordprocessingMLPackage pkgIn = Docx4J.load(new File(DIR_IN + file));
        BlockRange block = null;
        
        for (int i = 0; i < N; i++) {

            block = new BlockRange(pkgIn);

            block.setSectionBreakBefore(BlockRange.SectionBreakBefore.ODD_PAGE);
            if (i==0) {
            	block.setHeaderBehaviour(BlockRange.HfBehaviour.DEFAULT);
            	block.setFooterBehaviour(BlockRange.HfBehaviour.DEFAULT);
            } else {
            	// Avoid creating unnecessary additional header/footer parts
            	block.setHeaderBehaviour(BlockRange.HfBehaviour.INHERIT);
            	block.setFooterBehaviour(BlockRange.HfBehaviour.INHERIT);	
            }
            	
			block.setStyleHandler(StyleHandler.RENAME_RETAIN);
            	
            
            System.out.println("\n\r\n\r" + i + "\n\r\n\r");
            dbi.addBlockRange(block, i==(N-1) );  // 2nd param is whether this is your last docx
            
            // example of manipulating the output as it is generated 
            // dbi.getPkgInProgress().getMainDocumentPart().addParagraphOfText("");
        }
        
        WordprocessingMLPackage output = dbi.finish();// Get the output docx
		
		// Save the result
		Docx4J.save(output, 
				new File(DIR_OUT+"MergeCopyNTimes" + N +".docx"), 
				Docx4J.FLAG_NONE);		
		
		
	}	
}
