package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.SdtBlock;

import com.plutext.merge.BlockRange;
import com.plutext.merge.DocumentBuilder;


public class MergeBlockRangeViaXPathContentControl {

	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	public static void main(String[] args) throws Exception {
		
		String file1 = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/UN-ContentControls.docx";
		String file2 = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/IntegersOnly.docx";
		WordprocessingMLPackage wmlPkg1 = WordprocessingMLPackage.load(new File(file1));
				
		List<BlockRange> blockRanges = new ArrayList<BlockRange>();

		/*
	    <w:sdt>
	      <w:sdtPr>
	        <w:rPr>
	          <w:i/>
	          <w:iCs/>
	        </w:rPr>
	        <w:alias w:val="Article 1"/>
		*/
		
		
		blockRanges.add(new BlockRange(wmlPkg1, "//w:sdt[ w:sdtPr/w:alias/@w:val='Article 1' ]", false)); 
		
		blockRanges.add(new BlockRange(WordprocessingMLPackage.load(new File(file2)))); 
		
		DocumentBuilder documentBuilder = new DocumentBuilder();
		WordprocessingMLPackage output = documentBuilder.buildOpenDocument(blockRanges);
		
		Docx4J.save(output, 
				new File(DIR_OUT+"OUT_MergeBlockRangeViaXPathContentControl.docx"), 
				Docx4J.FLAG_NONE);		
		
	}	

	
}
