package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.P;

import com.plutext.merge.BlockRange;
import com.plutext.merge.DocumentBuilder;


public class MergeBlockRangeNViaXPathString {

	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	public static void main(String[] args) throws Exception {
		
		String file1 = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/UN-Declaration.docx";
		String file2 = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/IntegersOnly.docx";
		WordprocessingMLPackage wmlPkg1 = WordprocessingMLPackage.load(new File(file1));
				
		List<BlockRange> blockRanges = new ArrayList<BlockRange>();
		
		P p = getParagraph(wmlPkg1.getMainDocumentPart(), 
				"//w:p[ contains(w:r/w:t, 'Article 1')]");
		
		if (p==null) {
			System.out.println("XPath no results");
			return;
		}
		
		int n = getIndexOfParagraph(wmlPkg1.getMainDocumentPart(), p);
		if (n==-1) {
			System.out.println("Couldn't find index");
			return;
		}
		
		blockRanges.add(new BlockRange(wmlPkg1, 0, n+1)); 
		
		blockRanges.add(new BlockRange(WordprocessingMLPackage.load(new File(file2)))); 
		
		DocumentBuilder documentBuilder = new DocumentBuilder();
		WordprocessingMLPackage output = documentBuilder.buildOpenDocument(blockRanges);
		
		Docx4J.save(output, 
				new File(DIR_OUT+"OUT_MergeBlockRangeNViaXPathString.docx"), 
				Docx4J.FLAG_NONE);		
		
	}	

	public static P getParagraph(MainDocumentPart documentPart, String xpath) {

		try {
			List<Object> list = documentPart.getJAXBNodesViaXPath(xpath, false);
			
			if (list.isEmpty() ) {
				return null;
			} else if (list.get(0) instanceof P) { 
				return (P)list.get(0);
			} else {
				return null;
			}
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}		
	}

	public static int getIndexOfParagraph(MainDocumentPart documentPart, P p) {
		
		int index = 0;
		for (Object o : documentPart.getJaxbElement().getBody().getEGBlockLevelElts() ) {
			
			if (o.equals(p)) return index;
			index++;
		}
		return -1;
	}
	
}
