package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.SdtBlock;

import com.plutext.merge.BlockRange;
import com.plutext.merge.DocumentBuilder;


public class MergeBlockRangeNViaXPathContentControl {

	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	public static void main(String[] args) throws Exception {
		
		String file1 = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/UN-ContentControls.docx";
		String file2 = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/IntegersOnly.docx";
		WordprocessingMLPackage wmlPkg1 = WordprocessingMLPackage.load(new File(file1));
				
		List<BlockRange> blockRanges = new ArrayList<BlockRange>();

		/*
	    <w:sdt>
	      <w:sdtPr>
	        <w:rPr>
	          <w:i/>
	          <w:iCs/>
	        </w:rPr>
	        <w:alias w:val="Article 1"/>
		*/
		
		SdtBlock sdtBlock = getSdt(wmlPkg1.getMainDocumentPart(), 
				"//w:sdt[ w:sdtPr/w:alias/@w:val='Article 1' ]");
		
		if (sdtBlock==null) {
			System.out.println("XPath no results");
			return;
		}
		
		int n = getIndexOfSdt(wmlPkg1.getMainDocumentPart(), sdtBlock);
		if (n==-1) {
			System.out.println("Couldn't find index");
			return;
		}
		
		blockRanges.add(new BlockRange(wmlPkg1, n, 1)); 
		
		blockRanges.add(new BlockRange(WordprocessingMLPackage.load(new File(file2)))); 
		
		DocumentBuilder documentBuilder = new DocumentBuilder();
		WordprocessingMLPackage output = documentBuilder.buildOpenDocument(blockRanges);
		
		Docx4J.save(output, 
				new File(DIR_OUT+"OUT_MergeBlockRangeNViaXPathContentControl.docx"), 
				Docx4J.FLAG_NONE);		
		
	}	

	public static SdtBlock getSdt(MainDocumentPart documentPart, String xpath) {

		try {
			List<Object> list = documentPart.getJAXBNodesViaXPath(xpath, false);
			
			if (list.isEmpty() ) {
				return null;
			} else if (list.get(0) instanceof SdtBlock) { 
				return (SdtBlock)list.get(0);
			} else {
				return null;
			}
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}		
	}

	public static int getIndexOfSdt(MainDocumentPart documentPart, SdtBlock sdt) {
		
		int index = 0;
		for (Object o : documentPart.getJaxbElement().getBody().getContent() ) {
			
			if (o.equals(sdt)) return index;
			index++;
		}
		return -1;
	}
	
}
