package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.TraversalUtil;
import org.docx4j.TraversalUtil.CallbackImpl;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.P;
import org.docx4j.wml.Text;

import com.plutext.merge.BlockRange;
import com.plutext.merge.DocumentBuilder;


public class MergeBlockRangeNViaTraversalUtilsString {

	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	public static void main(String[] args) throws Exception {
		
		String file1 = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/UN-Declaration.docx";
		String file2 = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/IntegersOnly.docx";
		WordprocessingMLPackage wmlPkg1 = WordprocessingMLPackage.load(new File(file1));
				
		List<BlockRange> blockRanges = new ArrayList<BlockRange>();

		StringFinder stringFinder = new StringFinder("Article 1");
		new TraversalUtil(wmlPkg1.getMainDocumentPart().getJaxbElement().getBody(), 
				stringFinder);
		
		if (!stringFinder.found) {
			System.out.println("Couldn't find paragraph");
			return;			
		}
		int n = getIndexOfP(wmlPkg1.getMainDocumentPart(), stringFinder.result );
		if (n==-1) {
			System.out.println("Couldn't find index");
			return;
		}
		
		blockRanges.add(new BlockRange(wmlPkg1, 0, n)); 
		
		blockRanges.add(new BlockRange(WordprocessingMLPackage.load(new File(file2)))); 
		
		DocumentBuilder documentBuilder = new DocumentBuilder();
		WordprocessingMLPackage output = documentBuilder.buildOpenDocument(blockRanges);
		
		Docx4J.save(output, 
				new File(DIR_OUT+"OUT_MergeBlockRangeNViaTraversalUtilsString.docx"), 
				Docx4J.FLAG_NONE);		
		
	}	


	public static int getIndexOfP(MainDocumentPart documentPart, P p) {
		
		int index = 0;
		for (Object o : documentPart.getJaxbElement().getBody().getContent() ) {
			
			if (o.equals(p)) return index;
			index++;
		}
		return -1;
	}
	
	static class StringFinder extends CallbackImpl {
		
		P result;
		P recent;
		boolean found = false;
		
		private String match;
		
		StringFinder(String match) {
			this.match = match;
		}
		
		@Override
		public List<Object> apply(Object o) {
			
			/* This example requires the string to be contiguous,
			 * in a single wml.Text element.
			 * 
			 * You could search for strings broken across runs
			 * by using 
			 * 
					if (o instanceof P ) {
						StringWriter out = new StringWriter();
						try {
							TextUtils.extractText(o, out);
							out.close();
						} catch (Exception e) {
							e.printStackTrace();
						}
			
						if (out.toString().contains(match)) {
							result = (P)o;
							found = true;
						}
					}			
			 *
			 *  similar to the MergeBlockRangeNViaManualString example.
			 */
			
			if (o instanceof P ) {
				recent = (P)o;
			} else if (o instanceof Text ) {
				if ( ((Text)o).getValue().contains(match) ) {
					result = recent;
					found = true;
				}
			}
			return null;
			
		}
		
		@Override
		public boolean shouldTraverse(Object o) {
			return !found;
		}
		
	}
	
}
