package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.TraversalUtil;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.P;

import com.plutext.merge.BlockRange;
import com.plutext.merge.DocumentBuilder;
import com.plutext.merge.SectPrFindFirst;


public class MergeBlockRangeNViaTraversalUtilsSectPr {

	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	public static void main(String[] args) throws Exception {
		
		String file1 = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/UN-Declaration.docx";
		String file2 = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/IntegersOnly.docx";
		WordprocessingMLPackage wmlPkg1 = WordprocessingMLPackage.load(new File(file1));
				
		List<BlockRange> blockRanges = new ArrayList<BlockRange>();

		SectPrFindFirst sf = new SectPrFindFirst(); // SectPrFinder is part of MergeDocx codebase 
		new TraversalUtil(wmlPkg1.getMainDocumentPart().getJaxbElement().getBody().getContent(), sf);
		
    	if (sf.firstSectPr==null) {
			System.out.println("Couldn't find sdt");
			return;			
		}
		int n = getIndexOfP(wmlPkg1.getMainDocumentPart(), sf.enclosingP );
		if (n==-1) {
			System.out.println("Couldn't find index");
			return;
		}
		
		blockRanges.add(new BlockRange(wmlPkg1, 0, n)); 
		
		blockRanges.add(new BlockRange(WordprocessingMLPackage.load(new File(file2)))); 
		
		DocumentBuilder documentBuilder = new DocumentBuilder();
		WordprocessingMLPackage output = documentBuilder.buildOpenDocument(blockRanges);
		
		Docx4J.save(output, 
				new File(DIR_OUT+"OUT_MergeBlockRangeNViaTraversalUtilsSectPr.docx"), 
				Docx4J.FLAG_NONE);		
		
	}	


	public static int getIndexOfP(MainDocumentPart documentPart, P p) {
		
		int index = 0;
		for (Object o : documentPart.getJaxbElement().getBody().getContent() ) {
			
			if (o.equals(p)) return index;
			index++;
		}
		return -1;
	}
	
}
