package com.plutext.samples.mergedocx;
import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.TextUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;

import com.plutext.merge.BlockRange;
import com.plutext.merge.DocumentBuilder;


public class MergeBlockRangeNViaManualString {

	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	public static void main(String[] args) throws Exception {
		
		String file1 = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/UN-Declaration.docx";
		String file2 = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/IntegersOnly.docx";
		WordprocessingMLPackage wmlPkg1 = WordprocessingMLPackage.load(new File(file1));
				
		List<BlockRange> blockRanges = new ArrayList<BlockRange>();

		int n = getIndexOfSectPr(wmlPkg1.getMainDocumentPart(), "Article 1");
		if (n==-1) {
			System.out.println("Couldn't find index");
			// Add whole document, since there ought to be a doc level sectPr
			blockRanges.add(new BlockRange(wmlPkg1)); 
		} else {		
			blockRanges.add(new BlockRange(wmlPkg1, 0, n));
		}
		
		blockRanges.add(new BlockRange(WordprocessingMLPackage.load(new File(file2)))); 
		
		DocumentBuilder documentBuilder = new DocumentBuilder();
		WordprocessingMLPackage output = documentBuilder.buildOpenDocument(blockRanges);
		
		Docx4J.save(output, 
				new File(DIR_OUT+"OUT-MergeBlockRangeNViaManualString.docx"), 
				Docx4J.FLAG_NONE);		
		
	}	

	public static int getIndexOfSectPr(MainDocumentPart documentPart, String match) {

		int index = 0;
		for (Object o : documentPart.getJaxbElement().getBody().getContent() ) {
			
			StringWriter out = new StringWriter();
			try {
				TextUtils.extractText(o, out);
				out.close();
			} catch (Exception e) {
				e.printStackTrace();
			}

			if (out.toString().contains(match)) return index;
			
			index++;
		}
		return -1;
	}
	
}
