package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SdtPr;

import com.plutext.merge.BlockRange;
import com.plutext.merge.DocumentBuilder;


public class MergeBlockRangeNViaManualContentControl {

	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	public static void main(String[] args) throws Exception {
		
		String file1 = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/UN-ContentControls.docx";
		String file2 = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/IntegersOnly.docx";
		WordprocessingMLPackage wmlPkg1 = WordprocessingMLPackage.load(new File(file1));
				
		List<BlockRange> blockRanges = new ArrayList<BlockRange>();

		/*
	    <w:sdt>
	      <w:sdtPr>
	        <w:rPr>
	          <w:i/>
	          <w:iCs/>
	        </w:rPr>
	        <w:alias w:val="Article 1"/>
		*/
		
				
		int n = getIndexOfSdt(wmlPkg1.getMainDocumentPart(), "Article 1");
		if (n==-1) {
			System.out.println("Couldn't find index");
			return;
		}
		
		blockRanges.add(new BlockRange(wmlPkg1, 0, n)); 
		
		blockRanges.add(new BlockRange(WordprocessingMLPackage.load(new File(file2)))); 
		
		DocumentBuilder documentBuilder = new DocumentBuilder();
		WordprocessingMLPackage output = documentBuilder.buildOpenDocument(blockRanges);
		
		Docx4J.save(output, 
				new File(DIR_OUT+"OUT_MergeBlockRangeNViaManualContentControl.docx"), 
				Docx4J.FLAG_NONE);		
		
	}	

	public static int getIndexOfSdt(MainDocumentPart documentPart, String alias) {

		int index = 0;
		for (Object o : documentPart.getJaxbElement().getBody().getContent() ) {
			
			if (o instanceof SdtBlock) {
				SdtPr sdtPr= ((SdtBlock)o).getSdtPr();
				if (sdtPr!=null) {
					for (Object pr : sdtPr.getRPrOrAliasOrLock() ) {
						// Annoyingly, it may be wrapped in javax.xml.bind.JAXBElement
						pr = XmlUtils.unwrap(pr);
						if (pr instanceof SdtPr.Alias && ((SdtPr.Alias)pr).getVal().equals(alias)) {
								return index;
						}
					}
				}
			}
			
			index++;
		}
		return -1;
	}
	
}
