package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;

import com.plutext.merge.BlockRange;
import com.plutext.merge.BlockRange.SectionBreakBefore;
import com.plutext.merge.DocumentBuilder;


public class MergeBlockRangeFixedN {

	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	public static void main(String[] args) throws Exception {
		
		String file1 = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/IntegersOnly.docx";
		WordprocessingMLPackage wmlPkgIn = WordprocessingMLPackage.load(new File(file1));
				
		List<BlockRange> blockRanges = new ArrayList<BlockRange>();
		blockRanges.add(new BlockRange(wmlPkgIn));       // add all
		blockRanges.add(new BlockRange(wmlPkgIn, 0, 6)); // paras 0-5
		
		// Avoid the page break
		BlockRange blockRange3 = new BlockRange(wmlPkgIn, 6);
		blockRange3.setSectionBreakBefore(SectionBreakBefore.CONTINUOUS);		
		blockRanges.add(blockRange3);
		
		DocumentBuilder documentBuilder = new DocumentBuilder();
		WordprocessingMLPackage output = documentBuilder.buildOpenDocument(blockRanges);
		
		Docx4J.save(output, 
				new File(DIR_OUT+"OUT-MergeBlockRangeFixedN.docx"), 
				Docx4J.FLAG_NONE);		
	}	

}
