package com.plutext.samples.mergedocx;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

import org.docx4j.Docx4J;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.AltChunkType;

import com.plutext.merge.BlockRange.StyleHandler;
import com.plutext.merge.altchunk.ProcessAltChunk;


/**
 * Convert altChunks of type docx 
 * (actually, "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml",
 *  or, for Flat OPC XML, "application/xml")
 * to native content. 

 * @author jharrop
 *
 */
public class MergeAltChunks {
	
	static String outputfilepath = System.getProperty("user.dir") + "/OUT_AltChunksMerged";

	/**
	 * @param args
	 * @throws Docx4JException 
	 * @throws FileNotFoundException 
	 */
	public static void main(String[] args) throws Docx4JException, FileNotFoundException {
		
		// resulting docx
//		String INPUT_DOCX = System.getProperty("user.dir") + "/src/main/resources/sample-docx/Cat.docx";
		
		String chunkPath = System.getProperty("user.dir") + "/src/main/resources/sample-docx/Mat.docx";
		
		
		// Load input_template.docx
//		WordprocessingMLPackage wordMLPackage = Docx4J.load(new File(INPUT_DOCX));
		WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.createPackage();
		
//		wordMLPackage.getMainDocumentPart().addParagraphOfText("before");
		
		
		if (chunkPath!=null) {
			wordMLPackage.getMainDocumentPart().addAltChunk(AltChunkType.WordprocessingML, new FileInputStream(chunkPath) );
//			wordMLPackage.getMainDocumentPart().addParagraphOfText("after");
			
			System.out.println("Document with altChunks: " + wordMLPackage.getMainDocumentPart().getXML());
		}
		
		
		ProcessAltChunk processor = new ProcessAltChunk(wordMLPackage);
		
		processor.setStyleHandler(StyleHandler.USE_EARLIER);
		// if all your chunks use the same style definitions, use StyleHandler.USE_EARLIER;
		// if the style definitions are different, use StyleHandler.RENAME_RETAIN

		processor.setUseContinuousSections(true);

		wordMLPackage = processor.process();
		
		System.out.println(wordMLPackage.getMainDocumentPart().getXML());
		
		
		//Save the document
		Docx4J.save(wordMLPackage, new File(outputfilepath + ".docx"), Docx4J.FLAG_NONE);	
		 
	        
	}

}
