package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;

import com.plutext.merge.BlockRange;
import com.plutext.merge.BlockRange.HfBehaviour;
import com.plutext.merge.BlockRange.SectionBreakBefore;
import com.plutext.merge.DocumentBuilder;


public class MacroExample {
	
	public final static String DIR_IN = System.getProperty("user.dir")+ "/src/main/resources/sample-docx/";
	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	public static void main(String[] args) throws Exception {
				
		String[] files = {"IntegersOnly.docx", "signed_macro.docm", "UN-Declaration.docx" };
		
		
		List<BlockRange> blockRanges = new ArrayList<BlockRange>();
		for (int i=0 ; i< files.length; i++) {
			BlockRange block = new BlockRange(WordprocessingMLPackage.load(
					new File(DIR_IN + files[i])));
			blockRanges.add( block );
			
			// No pages breaks
			block.setSectionBreakBefore(SectionBreakBefore.CONTINUOUS);
			
			// if you want no headers on the pages from docx2:
			block.setHeaderBehaviour(HfBehaviour.NONE);
		}
		
		DocumentBuilder documentBuilder = new DocumentBuilder();
		
		// Use macros from the first block range
		documentBuilder.setRetainMacros(blockRanges.get(1));
		
		
		// Perform the actual merge
		WordprocessingMLPackage output = documentBuilder.buildOpenDocument(blockRanges);
		
		// Save the result
		Docx4J.save(output, 
				new File(DIR_OUT+"OUT_MergeWholeDocumentsUsingBlockRange.docm"), 
				Docx4J.FLAG_NONE);	
		
		// If you open the output document in Word, then click on macros from the developer tab,
		// you should see a macro named "embolden"
		
		// Alternatively, unzip the docm, and notice the parts:
		// - vbaProject.bin
		// - vbaProjectSignature.bin
		// - vbaData.xml
		
		
	}	
}
