package com.plutext.samples.mergedocx;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

import org.docx4j.Docx4J;
import org.docx4j.XmlUtils;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;

import com.plutext.merge.BlockRange;
import com.plutext.merge.BlockRange.HfBehaviour;
import com.plutext.merge.BlockRange.SectionBreakBefore;
import com.plutext.merge.DocumentBuilder;


/**
 * 
 * Insert a block range at the location specified by a content control.
 * 
 * In this example, use "setIDAndInsertAsSection" to bring in the sectPr as well, 
 * so this block range could have headers/footers, page orientation etc 
 * 
 * For further examples, see source code DocumentBuilderBlockRangeIDRefTest
 * 
 * @author jharrop
 *
 */
public class InsertAsSection {
	
	static boolean save = true;
	
	public final static String DIR_OUT = System.getProperty("user.dir")+ "/";
	
	public static void main(String[] args) throws Exception {
				
		// The document containing the table
		String file1 = System.getProperty("user.dir")+ "/src/test/resources/BlockRange_IDREF_myContent.docx";
		
		// The document to be inserted (tableContent)
		String file2 = System.getProperty("user.dir")+ "/src/test/resources/header-image.docx";
		
		BlockRange source1 = new BlockRange(WordprocessingMLPackage.load(new File(file1)));
		
		BlockRange insertion = new BlockRange(WordprocessingMLPackage.load(new File(file2)));
		insertion.setIDAndInsertAsSection("myContent");  /* keep this BlockRange's sectPr */
		
		List<BlockRange> sources = new ArrayList<BlockRange>();
		sources.add(insertion);  
		sources.add(source1);
		
		DocumentBuilder documentBuilder = new DocumentBuilder();
		WordprocessingMLPackage output = documentBuilder.buildOpenDocument(sources);

		System.out.println(output.getMainDocumentPart().getXML());
				
		// Save the result
		if (save) {		
			Docx4J.save(output, 
					new File(DIR_OUT+"OUT_MergeUsingID.docx"), 
					Docx4J.FLAG_NONE);		
		}
		
	}	
}
