package signaturesamples;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;

import org.docx4j.openpackaging.parts.digitalsignature.XmlSignaturePart;

import com.plutext.dsig.SignatureHelper;

public class ValidateSignature {
	
	public static void main(String[] args) throws Exception {

	    String inputfilepath = System.getProperty("user.dir") + "/Word 2016 signed.docx";
//	    String inputfilepath = System.getProperty("user.dir") + "/visible9.docx";
		
		InputStream is = new FileInputStream(new java.io.File(inputfilepath));
		
        
        List<XmlSignaturePart> parts = SignatureHelper.getSignaturesStatusTrusted(is);
        // to check the validity of the certificates, you would need to pass your implementation of CertificateTrustChecker;
        
        for (XmlSignaturePart sp : parts) {        
        	System.out.println(sp.getPartName().getName() + " ---> " + sp.getSignatureStatus(null));
        }


	}

}
