/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.UnsupportedEncodingException;
import org.jpedal.PdfDecoder;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.TextTokens;
import org.jpedal.utils.LogWriter;

public class StringUtils {
    private static final int aInt = 97;
    private static final int zeroInt = 48;
    private static final int nineInt = 57;
    private static final int openSquareBracketInt = 91;
    private static final int closeSquareBracketInt = 93;
    private static final int openCurlyBracket = 40;
    private static final int closeCurlyBracket = 41;
    private static final int backSlashInt = 92;
    private static final int forwardSlashInt = 47;
    private static final int hashInt = 35;
    private static final int divideInt = 247;
    private static final int fullStopInt = 46;
    private static final int spaceInt = 32;
    private static final int percentInt = 37;
    private static final int minusInt = 45;
    private static final int underScoreInt = 95;
    private static final int backSlachInt = 92;
    private static final int nInt = 110;
    private static final int newLineInt = 10;
    private static final int plusInt = 43;
    private static final int pInt = 112;
    private static final int colonInt = 58;
    private static final int equalsInt = 61;
    private static final int cInt = 99;
    private static final int qInt = 113;
    private static String enc = System.getProperty("file.encoding");

    public static String toLowerCase(String string) {
        int n = string.length();
        char[] cArray = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c <= '@' || c >= '[') continue;
            cArray[i] = c = (char)(c + 32);
            bl = true;
        }
        if (bl) {
            return String.copyValueOf(cArray, 0, n);
        }
        return string;
    }

    public static String toUpperCase(String string) {
        int n = string.length();
        char[] cArray = string.toCharArray();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if (c <= '`' || c >= '{') continue;
            cArray[i] = c = (char)(c - 32);
            bl = true;
        }
        if (bl) {
            return String.copyValueOf(cArray, 0, n);
        }
        return string;
    }

    public static final String handleEscapeChars(String string) {
        int n = string.indexOf(92);
        while (n != -1) {
            char c = string.charAt(n + 1);
            if (c == 'n') {
                c = '\n';
            }
            string = string.substring(0, n) + c + string.substring(n + 2, string.length());
            n = string.indexOf(92);
        }
        return string;
    }

    public static final String convertHexChars(String string) {
        if (string == null) {
            return string;
        }
        int n = string.indexOf(35);
        if (n == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '#') {
                int n3;
                if ((n3 = ++i + 2) > n2) {
                    n3 = n2;
                }
                String string2 = string.substring(i, n3);
                c = (char)Integer.parseInt(string2, 16);
                ++i;
                if (c == ' ') continue;
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static boolean isNumber(String string) {
        byte[] byArray = StringUtils.toBytes(string);
        int n = byArray.length;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] >= 48 && byArray[i] <= 57 || byArray[i] == 46 || i == 0 && byArray[i] == 45) continue;
            bl = false;
            i = n;
        }
        return bl;
    }

    public static String[] remove(String[] stringArray, int n) {
        if (n < 0 || n > stringArray.length) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (i == n) continue;
            stringArray2[n2++] = stringArray[i];
        }
        return stringArray2;
    }

    public static String makeHTMLNameSafe(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        if (string.indexOf(37) != -1 || string.indexOf(32) != -1 || string.indexOf(46) != -1 || string.indexOf(43) != -1 || string.indexOf(58) != -1 || string.indexOf(61) != -1 || string.indexOf(47) != -1 || string.indexOf(92) != -1) {
            block10: for (int i = 0; i < cArray.length; ++i) {
                switch (cArray[i]) {
                    case ' ': {
                        cArray[i] = 95;
                        continue block10;
                    }
                    case '.': {
                        cArray[i] = 45;
                        continue block10;
                    }
                    case '%': {
                        cArray[i] = 95;
                        continue block10;
                    }
                    case '+': {
                        cArray[i] = 112;
                        continue block10;
                    }
                    case ':': {
                        cArray[i] = 99;
                        continue block10;
                    }
                    case '=': {
                        cArray[i] = 113;
                        continue block10;
                    }
                    case '/': {
                        cArray[i] = 95;
                        continue block10;
                    }
                    case '\\': {
                        cArray[i] = 95;
                    }
                }
            }
        }
        char[] cArray2 = new char[]{'[', ']', '#', '\u00f7', '(', ')'};
        int n = 0;
        for (char n2 : cArray) {
            for (char c : cArray2) {
                if (n2 != c) continue;
                ++n;
            }
        }
        if (n > 0) {
            int n4 = 0;
            char[] cArray3 = new char[cArray.length - n];
            block13: for (char c : cArray) {
                for (char c2 : cArray2) {
                    if (c == c2) continue block13;
                }
                cArray3[n4++] = c;
            }
            cArray = cArray3;
        }
        if (cArray[0] >= '0' && cArray[0] <= '9') {
            char[] cArray4 = new char[cArray.length + 1];
            System.arraycopy(cArray, 0, cArray4, 1, cArray.length);
            cArray4[0] = 97;
            cArray = cArray4;
        }
        string = new String(cArray);
        return string;
    }

    public static String getTextString(byte[] byArray, boolean bl) {
        String string = "";
        StandardFonts.checkLoaded(6);
        char[] cArray = null;
        if (byArray != null) {
            cArray = new char[byArray.length * 2];
        }
        int n = 0;
        TextTokens textTokens = new TextTokens(byArray);
        if (textTokens.isUnicode()) {
            while (textTokens.hasMoreTokens()) {
                char c = textTokens.nextUnicodeToken();
                if (c == '\t') {
                    cArray[n] = 32;
                    ++n;
                    continue;
                }
                if (c <= '\u001f' && (!bl || c != '\n' && c != '\r')) continue;
                cArray[n] = c;
                ++n;
            }
        } else {
            while (textTokens.hasMoreTokens()) {
                char c = textTokens.nextToken();
                String string2 = null;
                if (c == '\t') {
                    string2 = " ";
                } else if (bl && (c == '\n' || c == '\r')) {
                    string2 = String.valueOf(c);
                } else if (c > '\u001f' && c < '\u00fd') {
                    string2 = StandardFonts.getEncodedChar(6, c);
                }
                if (string2 == null) continue;
                int n2 = string2.length();
                if (n + n2 >= cArray.length) {
                    char[] cArray2 = new char[n2 + n + 10];
                    System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
                    cArray = cArray2;
                }
                for (int i = 0; i < n2; ++i) {
                    cArray[n] = string2.charAt(i);
                    ++n;
                }
            }
        }
        if (cArray != null) {
            string = String.copyValueOf(cArray, 0, n);
            string = StringUtils.decodeUTF16String(string);
        }
        return string;
    }

    public static String decodeUTF16String(String string) {
        String string2 = string.toUpperCase();
        if (string2.length() >= 4 && string2.length() % 2 == 0 && string2.startsWith("FEFF") && string2.matches("[0-9A-F]+")) {
            string2 = string2.substring(4);
            byte[] byArray = new byte[string2.length() / 2];
            for (int i = 0; i < string2.length(); i += 2) {
                byArray[i / 2] = (byte)Integer.parseInt(string2.substring(i, i + 2), 16);
            }
            StringBuilder stringBuilder = new StringBuilder(byArray.length / 2);
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == 0) continue;
                stringBuilder.append((char)byArray[i]);
            }
            return stringBuilder.toString();
        }
        return string;
    }

    public static String replaceAllManual(String string, int n, String string2) {
        int n2 = string.indexOf(n);
        while (n2 != -1) {
            string = string.substring(0, n2) + string2 + string.substring(n2 + 1);
            n2 = string.indexOf(n);
        }
        return string;
    }

    public static String correctSpecialChars(String string) {
        block32: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\u00e1': {
                    string = StringUtils.replaceAllManual(string, 225, "&aacute;");
                    continue block32;
                }
                case '\u00e0': {
                    string = StringUtils.replaceAllManual(string, 224, "&agrave;");
                    continue block32;
                }
                case '\u00e2': {
                    string = StringUtils.replaceAllManual(string, 226, "&acirc;");
                    continue block32;
                }
                case '\u00e5': {
                    string = StringUtils.replaceAllManual(string, 229, "&aring;");
                    continue block32;
                }
                case '\u00e3': {
                    string = StringUtils.replaceAllManual(string, 227, "&atilde;");
                    continue block32;
                }
                case '\u00e4': {
                    string = StringUtils.replaceAllManual(string, 228, "&auml;");
                    continue block32;
                }
                case '\u00e6': {
                    string = StringUtils.replaceAllManual(string, 230, "&aelig;");
                    continue block32;
                }
                case '\u00e7': {
                    string = StringUtils.replaceAllManual(string, 231, "&ccedil;");
                    continue block32;
                }
                case '\u00e9': {
                    string = StringUtils.replaceAllManual(string, 233, "&eacute;");
                    continue block32;
                }
                case '\u00e8': {
                    string = StringUtils.replaceAllManual(string, 232, "&egrave;");
                    continue block32;
                }
                case '\u00ea': {
                    string = StringUtils.replaceAllManual(string, 234, "&ecirc;");
                    continue block32;
                }
                case '\u00eb': {
                    string = StringUtils.replaceAllManual(string, 235, "&euml;");
                    continue block32;
                }
                case '\u00ed': {
                    string = StringUtils.replaceAllManual(string, 237, "&iacute;");
                    continue block32;
                }
                case '\u00ec': {
                    string = StringUtils.replaceAllManual(string, 236, "&igrave;");
                    continue block32;
                }
                case '\u00ee': {
                    string = StringUtils.replaceAllManual(string, 238, "&icirc;");
                    continue block32;
                }
                case '\u00ef': {
                    string = StringUtils.replaceAllManual(string, 239, "&iuml;");
                    continue block32;
                }
                case '\u00f1': {
                    string = StringUtils.replaceAllManual(string, 241, "&ntilde;");
                    continue block32;
                }
                case '\u00f3': {
                    string = StringUtils.replaceAllManual(string, 243, "&oacute;");
                    continue block32;
                }
                case '\u00f2': {
                    string = StringUtils.replaceAllManual(string, 242, "&ograve;");
                    continue block32;
                }
                case '\u00f4': {
                    string = StringUtils.replaceAllManual(string, 244, "&ocirc;");
                    continue block32;
                }
                case '\u00f8': {
                    string = StringUtils.replaceAllManual(string, 248, "&oslash;");
                    continue block32;
                }
                case '\u00f5': {
                    string = StringUtils.replaceAllManual(string, 245, "&otilde;");
                    continue block32;
                }
                case '\u00f6': {
                    string = StringUtils.replaceAllManual(string, 246, "&ouml;");
                    continue block32;
                }
                case '\u00df': {
                    string = StringUtils.replaceAllManual(string, 223, "&szlig;");
                    continue block32;
                }
                case '\u00fa': {
                    string = StringUtils.replaceAllManual(string, 250, "&uacute;");
                    continue block32;
                }
                case '\u00f9': {
                    string = StringUtils.replaceAllManual(string, 249, "&ugrave;");
                    continue block32;
                }
                case '\u00fb': {
                    string = StringUtils.replaceAllManual(string, 251, "&ucirc;");
                    continue block32;
                }
                case '\u00fc': {
                    string = StringUtils.replaceAllManual(string, 252, "&uuml;");
                    continue block32;
                }
                case '\u00ff': {
                    string = StringUtils.replaceAllManual(string, 255, "&yuml;");
                    continue block32;
                }
                case '\u2019': {
                    string = StringUtils.replaceAllManual(string, 8217, "&#39;");
                }
            }
        }
        return string;
    }

    public static byte[] toBytes(String string) {
        byte[] byArray;
        block2: {
            byArray = null;
            try {
                byArray = string.getBytes(enc);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + unsupportedEncodingException.getMessage());
            }
        }
        return byArray;
    }

    public static String makeMethodSafe(String string) {
        String string2 = StringUtils.makeHTMLNameSafe(string);
        string2 = string2.replace("-", "_");
        return string2;
    }

    public static String stripIllegalCharacters(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < ' ' && c >= '\u0000' || c > '~' && c < '\u00a0') continue;
            string2 = string2 + c;
        }
        return string2;
    }

    static {
        if (!(enc.equals("UTF-8") || enc.equals("MacRoman") || enc.equals("Cp1252"))) {
            enc = PdfDecoder.isRunningOnMac ? "MacRoman" : (PdfDecoder.isRunningOnWindows ? "Cp1252" : "UTF-8");
        }
    }
}

