/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render.output;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.HTMLFontUtils;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.TextState;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.render.BaseDisplay;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.output.FontMapper;
import org.jpedal.render.output.OutputHelper;
import org.jpedal.render.output.OutputImageController;
import org.jpedal.render.output.TextBlock;
import org.jpedal.render.output.TextPosition;
import org.jpedal.render.output.io.CustomIO;
import org.jpedal.render.output.io.DefaultIO;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.StringUtils;
import org.jpedal.utils.repositories.Vector_Rectangle;
import sun.misc.BASE64Encoder;

public class OutputDisplay
extends BaseDisplay {
    protected String firstPageName;
    public static boolean convertT1Fonts = true;
    protected String packageName = "";
    protected String javaFxFileName = "";
    protected HashMap<String, Object[]> fontsToConvert = new HashMap();
    protected HashMap<String, HashMap<String, Integer>> widths = new HashMap();
    protected static boolean enableOTFConversion = false;
    protected boolean hasEmbeddedFonts = false;
    protected Map embeddedFonts = new HashMap();
    protected Map baseFontNames = new HashMap();
    protected boolean hasEmbededFonts = false;
    private Map imagesAlreadyWritten = new HashMap();
    protected AcroRenderer acroRenderer;
    protected int startPage;
    protected int endPage;
    protected int pageGap = 50;
    String lastGlyf = "";
    boolean keepOriginalImage = false;
    protected String isOnlineConverter;
    protected boolean requiresTransform = false;
    protected boolean requiresTransformGlobal = false;
    protected boolean requiresTextGlobal = false;
    public static final int TEXT_AS_TEXT = -1;
    public static final int TEXT_AS_SHAPE = 1;
    public static final int TEXT_INVISIBLE_ON_IMAGE = 2;
    public static final int TEXT_VISIBLE_ON_IMAGE = 3;
    public static final int HTML_VIEW_MULTIFILE = 1;
    public static final int SVG_VIEW_MULTIFILE = 2;
    public static final int HTML_VIEW_MULTIFILE_SPLITSPREADS = 3;
    public static final int SVG_VIEW_MULTIFILE_SPLITSPREADS = 4;
    public static final int HTML_VIEW_SINGLEFILE = 5;
    public static final int SVG_VIEW_SINGLEFILE = 6;
    public static final int HTML_VIEW_SINGLEFILE_SPLITSPREADS = 7;
    public static final int SVG_VIEW_SINGLEFILE_SPLITSPREADS = 8;
    public static final int HTML_VIEW_SINGLEFILE_HORIZONTAL = 9;
    public static final int SVG_VIEW_SINGLEFILE_HORIZONTAL = 10;
    protected String clip = null;
    protected static OutputHelper Helper = null;
    FontMapper fontMapper = null;
    String lastFontUsed = "";
    private Map usedFontIDs = new HashMap();
    protected boolean includeClip = false;
    protected int textMode = -1;
    protected Map embeddedFontsByFontID = new HashMap();
    private Map glyfsRasterized = new HashMap();
    public static final int MaxNumberOfDecimalPlaces = 0;
    public static final int FontMode = 1;
    public static final int PercentageScaling = 2;
    public static final int IncludeJSFontResizingCode = 4;
    public static final int ExcludeMetadata = 6;
    public static final int EmbedImageAsBase64Stream = 7;
    public static final int AddNavBar = 8;
    public static final int UseCharSpacing = 10;
    public static final int UseWordSpacing = 11;
    public static final int UseFontResizing = 12;
    public static final int HasJavascript = 13;
    public static final int ConvertSpacesTonbsp = 14;
    public static final int EncloseContentInDiv = 15;
    public static final int IncludeClip = 16;
    public static final int UseImagesOnNavBar = 17;
    public static final int TextMode = 18;
    public static final int DisplayMode = 19;
    public static final int CustomIO = 21;
    public static final int StartOfDecode = 22;
    public static final int EndOfDecode = 23;
    public static final int EmulateEvenOdd = 24;
    public static final int HTMLImageMode = 26;
    public static final int UseThumbnailNavbar = 27;
    public static final int AcroRenderer = 28;
    public static final int AddTwitterButton = 30;
    public static final int AddFacebookButton = 31;
    public static final int AddGooglePlusButton = 32;
    public static final int AddRedditButton = 33;
    public static final int AddLinkedInButton = 34;
    public static final int AddDiggButton = 35;
    public static final int AddStumbleUponButton = 36;
    public static final int AddTumblrButton = 37;
    public static final int ConvertPDFExternalFileToOutputType = 38;
    public static final int GetIsSinglePage = 39;
    public static final int AddBorder = 40;
    protected int defaultMode = 3;
    protected int fontMode = 3;
    protected boolean isSingleFileOutput = false;
    protected boolean htmlImageMode = false;
    protected boolean embedImageAsBase64 = false;
    private boolean groupGlyphsInTJ = true;
    protected boolean writeEveryGlyf = false;
    public boolean inlineCSS = false;
    public static final boolean debugForms = false;
    private static final boolean DISABLE_IMAGES = false;
    private static final boolean DISABLE_SHAPE = false;
    private static final boolean DISABLE_TEXT = false;
    protected static final boolean DEBUG_TEXT_AREA = false;
    protected static final boolean DEBUG_DRAW_PAGE_BORDER = false;
    public static final int TOFILE = 0;
    public static final int TOP_SECTION = 1;
    public static final int SCRIPT = 2;
    public static final int FORM = 3;
    public static final int CSS = 4;
    public static final int TEXT = 6;
    public static final int KEEP_GLYFS_SEPARATE = 7;
    public static final int SET_ENCODING_USED = 8;
    public static final int JSIMAGESPECIAL = 9;
    public static final int SAVE_EMBEDDED_FONT = 10;
    public static final int PAGEDATA = 11;
    public static final int IMAGE_CONTROLLER = 12;
    public static final int FXMLPDFSTAGE = 13;
    public static final int FONT_AS_SHAPE = 14;
    public static final int FXMLTEXT = 15;
    public static final int FORMJS = 16;
    public static final int FORMJS_ONLOAD = 17;
    public static final int NAVBAR = 18;
    public static final int EXTERNAL_JS = 19;
    public static final int TEXTJS = 20;
    protected OutputImageController imageController = null;
    protected StringBuilder script = new StringBuilder(10000);
    protected ArrayList<String> fxScript = new ArrayList();
    protected ArrayList<String> fxmlText = new ArrayList();
    protected HashMap<Integer, String> base64Images = new HashMap();
    protected HashMap<Integer, String> base64Shades = new HashMap();
    protected StringBuilder fonts_as_shapes = new StringBuilder(10000);
    protected StringBuilder formJS = new StringBuilder(10000);
    protected StringBuilder formJSOnLoad = new StringBuilder(10000);
    protected StringBuilder form = new StringBuilder(10000);
    protected StringBuilder testDivs = new StringBuilder(10000);
    protected StringBuilder css = new StringBuilder(10000);
    protected StringBuilder topSection = new StringBuilder(10000);
    protected StringBuilder fxmlPDFStage = new StringBuilder(10000);
    protected StringBuilder navbarSection = new StringBuilder(10000);
    protected StringBuilder externalJSFile = new StringBuilder(10000);
    protected StringBuilder textJS = new StringBuilder(3000);
    protected boolean userControlledImageScaling = false;
    protected boolean emulateEvenOdd = false;
    protected int textID = 1;
    protected int shadeId = 0;
    protected int imageId = 0;
    protected int dpCount = 0;
    public String rootDir = null;
    public String fileName = null;
    protected int dx;
    protected int dy;
    protected int dr;
    protected boolean excludeMetadata = false;
    private boolean convertSpacesTonbsp = false;
    protected boolean addNavBar = false;
    protected boolean useImagesOnNavBar = false;
    protected boolean useThumbnailNavbar = false;
    protected TextBlock currentTextBlock;
    protected TextBlock previousTextBlock;
    protected TextPosition currentTextPosition;
    protected Rectangle2D cropBox;
    protected Point2D midPoint;
    protected int currentColor = 0;
    protected String[] encodingType = new String[]{"UTF-8", "utf-8"};
    protected static final int JAVA_TYPE = 0;
    protected static final int OUTPUT_TYPE = 1;
    public static final int FORM_TAG = 0;
    protected float scaling = 1.0f;
    protected int fontChangeNeeded = -1;
    protected boolean addBorder = true;
    float w;
    protected float h;
    protected String[] tag = new String[]{"<form>"};
    protected boolean jsImagesAdded = false;
    protected String pageNumberAsString = null;
    protected PdfPageData pageData;
    private int currentTokenNumber = -1;
    private int lastTokenNumber = 496;
    protected boolean includeJSFontResizingCode = true;
    protected String imageName;
    protected float iw;
    protected float ih;
    protected double[] coords;
    protected float[][] lastTrm;
    protected CustomIO customIO = new DefaultIO();
    protected String imageArray = null;
    protected int[] currentImage;
    protected int[] currentPatternedShape;
    protected String currentPatternedShapeName;
    protected Color stageColor = new Color(55, 55, 65);
    protected String[] jsCalculationOrder;
    protected boolean addTwitter = false;
    protected String viaTwitter = "";
    protected boolean addFacebook = false;
    protected boolean addGooglePlus = false;
    protected boolean addReddit = false;
    protected boolean addLinkedIn = false;
    protected boolean addDigg = false;
    protected boolean addStumbleUpon = false;
    protected boolean addTumblr = false;
    protected boolean enableMagazineSplitSpreads = false;
    protected boolean enableSinglePageHorizontal = false;
    private boolean convertPDFExternalFileToOutputType = true;
    protected boolean useExternalJS = true;
    protected boolean enableTouchEvents = false;
    protected boolean usingCachedImage = false;
    protected int cachedImageId = 0;
    static final int[] indices = new int[]{1, 10, 100, 1000};

    public OutputDisplay(int n, Point2D point2D, Rectangle2D rectangle2D, boolean bl, int n2, ObjectStore objectStore, Map map) {
        this.setParameters(map);
        this.fontMode = this.defaultMode;
        this.type = 4;
        this.pageNumber = n;
        this.objectStoreRef = objectStore;
        this.addBackground = bl;
        this.cropBox = rectangle2D;
        this.midPoint = point2D;
        this.areas = new Vector_Rectangle(n2);
    }

    private void setParameters(Map map) {
        if (map == null) {
            String string = System.getProperty("org.jpedal.pdf2html.fontMode");
            if (string != null) {
                if ((string = string.toLowerCase()).equals("embed_all")) {
                    this.defaultMode = 6;
                } else if (string.equals("embed_all_except_base_families")) {
                    this.defaultMode = 7;
                } else {
                    throw new RuntimeException("Mode " + string + " not recognised");
                }
            }
            if (System.getProperty("org.jpedal.pdf2html.keepOriginalImage") != null && System.getProperty("org.jpedal.pdf2html.keepOriginalImage").toLowerCase().equals("true")) {
                this.keepOriginalImage = true;
            }
            if (System.getProperty("org.jpedal.pdf2html.convertOTFFonts") != null && System.getProperty("org.jpedal.pdf2html.convertOTFFonts").toLowerCase().equals("true")) {
                enableOTFConversion = true;
            }
            this.isOnlineConverter = System.getProperty("IsOnlineConverter");
            this.firstPageName = System.getProperty("org.jpedal.pdf2html.firstPageName");
            if (System.getProperty("org.jpedal.pdf2html.stageColor") != null) {
                this.stageColor = Color.decode(System.getProperty("org.jpedal.pdf2html.stageColor"));
            }
        } else {
            String string = (String)map.get("org.jpedal.pdf2html.fontMode");
            if (string != null) {
                if (string.equals("embed_all")) {
                    this.defaultMode = 6;
                } else if (string.equals("embed_all_except_base_families")) {
                    this.defaultMode = 7;
                } else {
                    throw new RuntimeException("Mode " + string + " not recognised");
                }
            }
            if ((String)map.get("org.jpedal.pdf2html.keepOriginalImage") != null && ((String)map.get("org.jpedal.pdf2html.keepOriginalImage")).equals("true")) {
                this.keepOriginalImage = true;
            }
            if ((String)map.get("org.jpedal.pdf2html.convertOTFFonts") != null && ((String)map.get("org.jpedal.pdf2html.convertOTFFonts")).equals("true")) {
                enableOTFConversion = true;
            }
            this.isOnlineConverter = (String)map.get("IsOnlineConverter");
            this.firstPageName = (String)map.get("org.jpedal.pdf2html.firstPageName");
            if ((String)map.get("org.jpedal.pdf2html.stageColor") != null) {
                this.stageColor = Color.decode((String)map.get("org.jpedal.pdf2html.stageColor"));
            }
        }
    }

    public void setValue(int n, int n2) {
        switch (n) {
            case 19: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        this.isSingleFileOutput = false;
                        this.enableMagazineSplitSpreads = false;
                        this.enableSinglePageHorizontal = false;
                        break;
                    }
                    case 3: 
                    case 4: {
                        this.isSingleFileOutput = false;
                        this.enableMagazineSplitSpreads = true;
                        this.enableSinglePageHorizontal = false;
                        break;
                    }
                    case 5: 
                    case 6: {
                        this.isSingleFileOutput = true;
                        this.enableMagazineSplitSpreads = false;
                        this.enableSinglePageHorizontal = false;
                        break;
                    }
                    case 7: 
                    case 8: {
                        this.isSingleFileOutput = true;
                        this.enableMagazineSplitSpreads = true;
                        this.enableSinglePageHorizontal = false;
                        break;
                    }
                    case 9: 
                    case 10: {
                        this.isSingleFileOutput = true;
                        this.enableMagazineSplitSpreads = false;
                        this.enableSinglePageHorizontal = true;
                    }
                }
                break;
            }
            case 23: {
                this.endPage = n2;
                break;
            }
            case 1: {
                this.fontMode = n2;
                break;
            }
            case 0: {
                this.dpCount = n2;
                break;
            }
            case 2: {
                this.scaling = (float)n2 / 100.0f;
                break;
            }
            case 22: {
                this.startPage = n2;
                break;
            }
            case 18: {
                this.textMode = n2;
                break;
            }
            case 12: {
                this.fontChangeNeeded = n2;
            }
        }
    }

    public boolean getBooleanValue(int n) {
        switch (n) {
            case 38: {
                return this.convertPDFExternalFileToOutputType;
            }
            case 39: {
                return this.isSingleFileOutput;
            }
        }
        return super.getBooleanValue(n);
    }

    public void setBooleanValue(int n, boolean bl) {
        switch (n) {
            case 8: {
                this.addNavBar = bl;
                break;
            }
            case 38: {
                this.convertPDFExternalFileToOutputType = bl;
                break;
            }
            case 14: {
                this.convertSpacesTonbsp = bl;
                break;
            }
            case 6: {
                this.excludeMetadata = bl;
                break;
            }
            case 16: {
                this.includeClip = bl;
                break;
            }
            case 17: {
                this.useImagesOnNavBar = bl;
                break;
            }
            case 27: {
                this.useThumbnailNavbar = bl;
                break;
            }
            case 26: {
                this.htmlImageMode = bl;
                break;
            }
            case 30: {
                this.addTwitter = bl;
                break;
            }
            case 31: {
                this.addFacebook = bl;
                break;
            }
            case 32: {
                this.addGooglePlus = bl;
                break;
            }
            case 33: {
                this.addReddit = bl;
                break;
            }
            case 34: {
                this.addLinkedIn = bl;
                break;
            }
            case 35: {
                this.addDigg = bl;
                break;
            }
            case 36: {
                this.addStumbleUpon = bl;
                break;
            }
            case 37: {
                this.addTumblr = bl;
                break;
            }
            case 40: {
                this.addBorder = bl;
            }
        }
    }

    public int getValue(int n) {
        int n2 = -1;
        switch (n) {
            case 1: {
                n2 = this.fontMode;
                break;
            }
            case 2: {
                n2 = (int)(this.scaling * 100.0f);
                break;
            }
            case 18: {
                n2 = this.textMode;
            }
        }
        return n2;
    }

    public void setTag(int n, String string) {
        throw new RuntimeException("Unknown tag value " + n);
    }

    public void init(int n, int n2, int n3, Color color) {
        if (n3 == 90 || n3 == 270) {
            this.h = (float)n * this.scaling;
            this.w = (float)n2 * this.scaling;
        } else {
            this.w = (float)n * this.scaling;
            this.h = (float)n2 * this.scaling;
        }
        this.pageRotation = n3;
        this.backgroundColor = color;
        this.shadeId = 0;
        this.currentTextBlock = new TextBlock();
        this.previousTextBlock = new TextBlock();
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void writeCustom(int var1_1, Object var2_2) {
        switch (var1_1) {
            case 11: {
                this.pageData = (PdfPageData)var2_2;
                this.dx = this.pageData.getCropBoxX(this.pageNumber);
                this.dy = this.pageData.getCropBoxY(this.pageNumber);
                this.dr = this.pageData.getRotation(this.pageNumber);
                break;
            }
            case 12: {
                this.imageController = (OutputImageController)var2_2;
                this.userControlledImageScaling = this.imageController != null;
                break;
            }
            case 28: {
                this.acroRenderer = (AcroRenderer)var2_2;
                break;
            }
            case 21: {
                this.customIO = (CustomIO)var2_2;
                break;
            }
            case 10: {
                var3_3 = (Object[])var2_2;
                var4_4 = (PdfFont)var3_3[0];
                var5_5 = var4_4.getFontName();
                var6_6 = (String)var3_3[2];
                var7_7 = (String)var3_3[3];
                var8_8 = this.rootDir + this.fileName + "/fonts/";
                var9_9 = new File(var8_8);
                if (!var9_9.exists()) {
                    var9_9.mkdirs();
                }
                var10_10 = (byte[])var3_3[1];
                var5_5 = var5_5.replaceAll("[.,*#]", "-");
                if (!var6_6.equals("ttf") || var5_5.contains(",")) ** GOTO lbl53
                if (this.embeddedFonts.containsKey(var5_5) && !this.baseFontNames.containsKey(var4_4.getBaseFontName())) {
                    this.baseFontNames.put(var4_4.getBaseFontName(), "x");
                    var5_5 = var5_5 + '_' + var7_7 + '_' + var10_10.length;
                    var4_4.resetNameForHTML(var5_5);
                }
                try {
                    var10_10 = HTMLFontUtils.convertTTForHTML(var4_4, var5_5, var10_10);
                    if (OutputDisplay.enableOTFConversion) {
                        var10_10 = HTMLFontUtils.convertPSForHTMLOTF(var4_4, var5_5, var10_10, var6_6, this.widths.get(var5_5));
                        var6_6 = "otf";
                    } else {
                        var10_10 = HTMLFontUtils.convertPSForHTMLWOFF(var4_4, var5_5, var10_10, var6_6, this.widths.get(var5_5));
                        var6_6 = "woff";
                    }
                    if (var10_10 != null) {
                        this.customIO.writeFont(var8_8 + var5_5 + '.' + var6_6, var10_10);
                    }
                    ** GOTO lbl62
                }
                catch (Exception var11_11) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + var11_11.getMessage());
                    }
                }
                ** GOTO lbl62
lbl53:
                // 1 sources

                if (var6_6.equals("t1") && OutputDisplay.convertT1Fonts || var6_6.equals("cff") || var6_6.equals("ttf") && !var5_5.contains(",")) {
                    var5_5 = var6_6.equals("ttf") != false ? var4_4.getBaseFontName().substring(7) : var4_4.getBaseFontName().replace('+', '-');
                    if (this.embeddedFonts.containsKey(var5_5)) {
                        var5_5 = var5_5 + '_' + var7_7 + '_' + var10_10.length;
                        var4_4.resetNameForHTML(var5_5);
                    }
                    this.hasEmbeddedFonts = true;
                    this.fontsToConvert.put(var5_5, var3_3);
                    var6_6 = OutputDisplay.enableOTFConversion != false ? "otf" : "woff";
                }
lbl62:
                // 6 sources

                if (var10_10 == null) break;
                var11_12 = new StringBuilder();
                var12_13 = var5_5.replaceAll("[.,*#]", "-");
                if (this.type == 6) {
                    var11_12.append("Font.loadFont(");
                    var11_12.append(this.javaFxFileName + ".class.getResource(\"").append(this.fileName).append("/fonts/").append(var12_13).append('.').append(var6_6).append("\").toExternalForm(),10);\n");
                } else {
                    var11_12.append("@font-face {\n");
                    var11_12.append("\tfont-family: ").append(var12_13).append(";\n");
                    var11_12.append("\tsrc: url(\"").append(this.fileName).append("/fonts/").append(var12_13).append('.').append(var6_6).append("\");\n");
                    var11_12.append("}\n");
                }
                this.embeddedFonts.put(var5_5, var11_12);
                this.hasEmbededFonts = true;
                var13_14 = (String)this.embeddedFontsByFontID.get(var5_5);
                if (var13_14 == null) {
                    this.embeddedFontsByFontID.put(var5_5, var7_7);
                    break;
                }
                this.embeddedFontsByFontID.put(var5_5, var13_14 + ',' + var7_7);
                break;
            }
            default: {
                throw new RuntimeException("Option " + var1_1 + " not recognised");
            }
        }
    }

    public synchronized void flagDecodingFinished() {
        Object[] objectArray;
        if (this.customIO != null && this.customIO.isOutputOpen()) {
            this.completeOutput();
        }
        for (Object object : objectArray = this.fontsToConvert.keySet().toArray()) {
            String string;
            byte[] byArray;
            String string2;
            String string3;
            String string4;
            block9: {
                Object[] objectArray2 = this.fontsToConvert.get(object);
                PdfFont pdfFont = (PdfFont)objectArray2[0];
                string4 = (String)objectArray2[2];
                string3 = (String)objectArray2[3];
                string2 = this.rootDir + this.fileName + "/fonts/";
                File file = new File(string2);
                if (!file.exists()) {
                    file.mkdirs();
                }
                byArray = (byte[])objectArray2[1];
                string = string4.equals("ttf") ? pdfFont.getBaseFontName().replace('+', '-').substring(7) : pdfFont.getBaseFontName().replace('+', '-');
                this.hasEmbeddedFonts = true;
                boolean bl = false;
                if (bl) {
                    this.customIO.writeFont(string2 + string + ".cff", byArray);
                }
                try {
                    if (enableOTFConversion) {
                        byArray = HTMLFontUtils.convertPSForHTMLOTF(pdfFont, string, byArray, string4, this.widths.get(string));
                        string4 = "otf";
                    } else {
                        byArray = HTMLFontUtils.convertPSForHTMLWOFF(pdfFont, string, byArray, string4, this.widths.get(string));
                        string4 = "woff";
                    }
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block9;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
            string = string.replaceAll("[.,*#]", "-");
            if (byArray == null) continue;
            this.customIO.writeFont(string2 + string + '.' + string4, byArray);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("@font-face {\n");
            stringBuilder.append("\tfont-family: ").append(string).append(";\n");
            stringBuilder.append("\tsrc: url(\"").append(this.fileName).append("/fonts/").append(string).append('.').append(string4).append("\");\n");
            stringBuilder.append("}\n");
            this.embeddedFonts.put(string, stringBuilder);
            this.embeddedFonts.put(string3, string);
            this.hasEmbededFonts = true;
            String string5 = (String)this.embeddedFontsByFontID.get(string);
            if (string5 == null) {
                this.embeddedFontsByFontID.put(string, string3);
                continue;
            }
            this.embeddedFontsByFontID.put(string, string5 + ',' + string3);
        }
    }

    protected String roundUp(double d) {
        return "" + (int)(d + 0.99);
    }

    public int drawImage(int n, BufferedImage bufferedImage, GraphicsState graphicsState, boolean bl, String string, int n2, int n3) {
        Rectangle2D rectangle2D;
        boolean bl2;
        String string2 = n + 45 + string;
        this.usingCachedImage = false;
        boolean bl3 = bl2 = graphicsState.getClippingShape() == null && this.imagesAlreadyWritten.get(string2) != null;
        if (!bl2) {
            this.imagesAlreadyWritten.put(string2, this.imageId + 1);
        } else if (!this.embedImageAsBase64) {
            this.usingCachedImage = true;
            this.cachedImageId = (Integer)this.imagesAlreadyWritten.get(string2);
            bufferedImage = null;
        }
        this.flushText();
        boolean bl4 = false;
        float f = graphicsState.CTM[2][0] * this.scaling;
        float f2 = graphicsState.CTM[2][1] * this.scaling;
        this.iw = (graphicsState.CTM[0][0] + Math.abs(graphicsState.CTM[1][0])) * this.scaling;
        this.ih = (graphicsState.CTM[1][1] + Math.abs(graphicsState.CTM[0][1])) * this.scaling;
        if (this.iw == 0.0f) {
            this.iw = graphicsState.CTM[1][0] * this.scaling;
            if (this.iw < 0.0f) {
                this.iw = -this.iw;
            }
        }
        if (this.ih == 0.0f) {
            this.ih = graphicsState.CTM[0][1] * this.scaling;
        }
        if (this.iw < 0.0f) {
            this.iw *= -1.0f;
        }
        if (this.iw < 1.0f) {
            this.iw = 1.0f;
        }
        if (this.ih == 0.0f) {
            this.ih = 1.0f;
        }
        if (this.ih < 1.0f) {
            f2 += this.ih;
            this.ih = Math.abs(this.ih);
        }
        if (graphicsState.CTM[0][0] < 0.0f) {
            f -= this.iw;
        }
        if (graphicsState.CTM[0][0] > 0.0f && graphicsState.CTM[1][1] < 0.0f && graphicsState.CTM[0][1] == 0.0f && graphicsState.CTM[1][0] == 0.0f) {
            bl4 = true;
        }
        if (graphicsState.CTM[0][0] == 0.0f && graphicsState.CTM[1][1] == 0.0f && graphicsState.CTM[0][1] > 0.0f && graphicsState.CTM[1][0] > 0.0f) {
            f -= this.pageData.getCropBoxX2D(n) / 2.0f;
            f2 -= this.pageData.getCropBoxY2D(n);
        }
        Graphics2D graphics2D = null;
        BufferedImage bufferedImage2 = bufferedImage;
        boolean bl5 = false;
        boolean bl6 = false;
        if (graphicsState.getClippingShape() != null) {
            rectangle2D = graphicsState.getClippingShape().getBounds2D();
            float f3 = (float)(rectangle2D.getWidth() * (double)this.scaling);
            float f4 = (float)(rectangle2D.getHeight() * (double)this.scaling);
            if (f3 < this.iw) {
                this.iw = f3;
                f = (float)(rectangle2D.getMinX() * (double)this.scaling);
                bl5 = true;
            }
            if (f4 < this.ih) {
                this.ih = f4;
                f2 = (float)(rectangle2D.getMinY() * (double)this.scaling);
                bl6 = true;
            }
        }
        if (!bl5) {
            if (graphicsState.CTM[1][0] < 0.0f && graphicsState.CTM[0][0] != 0.0f) {
                f += graphicsState.CTM[1][0] * this.scaling;
            }
            if (graphicsState.CTM[1][0] < 0.0f && graphicsState.CTM[0][0] == 0.0f) {
                f -= this.iw;
            }
        }
        if (!bl6) {
            if (graphicsState.CTM[0][1] < 0.0f && graphicsState.CTM[1][1] != 0.0f) {
                f2 += graphicsState.CTM[0][1] * this.scaling;
            }
            if (graphicsState.CTM[0][1] < 0.0f && graphicsState.CTM[1][1] == 0.0f) {
                f2 -= this.ih;
            }
        }
        if (this.htmlImageMode) {
            this.coords = this.pageRotation == 90 || this.pageRotation == 270 ? new double[]{f2, f} : new double[]{f, f2};
        } else {
            switch (this.pageRotation) {
                case 180: {
                    this.coords = new double[]{this.cropBox.getWidth() - (double)((this.iw + f) / this.scaling), this.cropBox.getHeight() - (double)((this.ih + f2) / this.scaling)};
                    break;
                }
                case 270: {
                    if (graphicsState.CTM[0][0] > 0.0f && graphicsState.CTM[1][1] > 0.0f && graphicsState.CTM[1][0] == 0.0f && graphicsState.CTM[0][1] == 0.0f) {
                        this.coords = new double[]{this.cropBox.getWidth() - (double)((f + this.iw) / this.scaling), f2 / this.scaling};
                        break;
                    }
                    this.coords = new double[]{f / this.scaling, f2 / this.scaling};
                    break;
                }
                default: {
                    this.coords = new double[]{f / this.scaling, f2 / this.scaling};
                }
            }
        }
        this.correctCoords(this.coords);
        this.coords[0] = this.coords[0] * (double)this.scaling;
        this.coords[1] = this.coords[1] * (double)this.scaling;
        this.coords[1] = this.coords[1] - (double)this.ih;
        rectangle2D = new Rectangle2D.Double(this.coords[0], this.coords[1], this.iw, this.ih);
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.cropBox.getX() * (double)this.scaling, this.cropBox.getY() * (double)this.scaling, this.cropBox.getWidth() * (double)this.scaling, this.cropBox.getHeight() * (double)this.scaling);
        if (double_.intersects(rectangle2D)) {
            Object object;
            Object object2;
            if (!this.usingCachedImage) {
                ++this.imageId;
            }
            if (!this.userControlledImageScaling && !this.htmlImageMode && bufferedImage != null) {
                if (this.pageRotation != 0) {
                    bufferedImage = this.rotateImage(bufferedImage, this.pageRotation);
                }
                if (bufferedImage.getHeight() == 1 || !bl4 && this.iw == (float)bufferedImage.getWidth() && this.ih == (float)bufferedImage.getHeight()) {
                    bufferedImage2 = bufferedImage;
                } else {
                    if (graphics2D == null) {
                        bufferedImage2 = new BufferedImage((int)this.iw == 0 ? 1 : (int)this.iw, (int)this.ih == 0 ? 1 : (int)this.ih, bufferedImage.getType());
                        graphics2D = (Graphics2D)bufferedImage2.getGraphics();
                        AffineTransform affineTransform = new AffineTransform();
                        if (bl4) {
                            affineTransform.scale(1.0, -1.0);
                            affineTransform.translate(0.0, -this.ih);
                        }
                        graphics2D.setTransform(affineTransform);
                    }
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    graphics2D.drawImage(bufferedImage, 0, 0, (int)this.iw, (int)this.ih, null);
                }
            }
            if (this.embedImageAsBase64) {
                try {
                    object2 = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage2, "PNG", (OutputStream)object2);
                    ((ByteArrayOutputStream)object2).close();
                    object = new BASE64Encoder();
                    this.imageArray = new BASE64Encoder().encode(((ByteArrayOutputStream)object2).toByteArray());
                    this.imageArray = this.imageArray.replace("\r\n", "\\\r\n");
                }
                catch (IOException iOException) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + iOException.getMessage());
                    }
                }
            } else {
                object2 = this.fileName + "/img/";
                if (!bl2) {
                    object = new File(this.rootDir + (String)object2);
                    if (!((File)object).exists()) {
                        ((File)object).mkdirs();
                    }
                    this.customIO.writeImage(this.rootDir, (String)object2 + this.imageId, bufferedImage2);
                    this.imageName = (String)object2 + this.imageId + this.customIO.getImageTypeUsed();
                } else {
                    this.imageName = (String)object2 + this.cachedImageId + this.customIO.getImageTypeUsed();
                }
            }
            if (this.htmlImageMode) {
                this.currentImage = new int[]{0, 0, (int)this.iw, (int)this.ih};
            } else {
                int n4;
                int n5;
                int n6;
                int n7;
                switch (this.pageRotation) {
                    case 90: {
                        double d = (double)(this.pageData.getCropBoxHeight2D(n) * this.scaling) - this.coords[1] - (double)this.iw;
                        double d2 = this.coords[0];
                        n7 = (int)(d - (double)((int)d) + (double)this.iw + 0.99);
                        n6 = (int)(d2 - (double)((int)d2) + (double)this.ih + 0.99);
                        n5 = (int)d;
                        n4 = (int)d2;
                        break;
                    }
                    case 270: {
                        n7 = (int)(this.coords[1] - (double)((int)this.coords[1]) + (double)this.iw + 0.99);
                        n6 = (int)(this.coords[0] - (double)((int)this.coords[0]) + (double)this.ih + 0.99);
                        n5 = (int)this.coords[1];
                        n4 = (int)this.coords[0];
                        break;
                    }
                    default: {
                        n7 = (int)(this.coords[0] - (double)((int)this.coords[0]) + (double)this.iw + 0.99);
                        n6 = (int)(this.coords[1] - (double)((int)this.coords[1]) + (double)this.ih + 0.99);
                        n5 = (int)this.coords[0];
                        n4 = (int)this.coords[1];
                    }
                }
                this.currentImage = new int[]{n5, n4, n7, n6};
            }
            return -2;
        }
        return -1;
    }

    protected BufferedImage rotateImage(BufferedImage bufferedImage, int n) {
        BufferedImage bufferedImage2;
        if (n == 180) {
            AffineTransform affineTransform = AffineTransform.getScaleInstance(-1.0, -1.0);
            affineTransform.translate(-bufferedImage.getWidth(null), -bufferedImage.getHeight(null));
            AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
            bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        } else {
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            bufferedImage2 = new BufferedImage(n3, n2, bufferedImage.getType());
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            graphics2D.rotate(Math.toRadians(this.pageRotation), n2 / 2, n3 / 2);
            int n4 = (n2 - n3) / 2;
            if (n == 90) {
                graphics2D.drawImage((Image)bufferedImage, n4, n4, null);
            } else if (n == 270) {
                graphics2D.drawImage((Image)bufferedImage, -n4, -n4, null);
            }
            float f = this.iw;
            this.iw = this.ih;
            this.ih = f;
        }
        return bufferedImage2;
    }

    protected String setPrecision(double d) {
        String string = String.valueOf(d);
        int n = string.indexOf(46);
        int n2 = string.length();
        int n3 = n2 - n - 1;
        if (n > 0 && n3 > this.dpCount) {
            string = this.dpCount == 0 ? string.substring(0, n + this.dpCount) : string.substring(0, n + this.dpCount + 1);
        }
        return OutputDisplay.removeEmptyDecimals(string);
    }

    protected static String setPrecision(double d, int n) {
        if (n > 3) {
            throw new RuntimeException("dp count must be less than 4");
        }
        double d2 = (double)((int)(d * (double)indices[n])) / (double)indices[n];
        if (d2 > 0.98 && d2 < 1.01) {
            return "1";
        }
        if (d2 == 0.0) {
            return "0";
        }
        if (d2 == 0.0) {
            return "0";
        }
        if (d2 < -0.98 && d2 > -1.01) {
            return "-1";
        }
        return String.valueOf((double)((int)(d * (double)indices[n])) / (double)indices[n]);
    }

    public void drawClip(GraphicsState graphicsState, Shape shape, boolean bl) {
    }

    public void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, Object object, int n2, GraphicsState graphicsState, AffineTransform affineTransform, String string, PdfFont pdfFont, float f) {
        float f2;
        float f3;
        int n3;
        int n4;
        float f4;
        float f5;
        Area area;
        float[][] fArray2 = new float[3][3];
        fArray2[0][0] = fArray[0][0];
        fArray2[0][1] = fArray[0][1];
        fArray2[0][2] = fArray[0][2];
        fArray2[1][0] = fArray[1][0];
        fArray2[1][1] = fArray[1][1];
        fArray2[1][2] = fArray[1][2];
        fArray2[2][0] = fArray[2][0];
        fArray2[2][1] = fArray[2][1];
        fArray2[2][2] = fArray[2][2];
        if (this.currentTokenNumber == this.lastTokenNumber && string.equals(" ") && this.lastGlyf.equals(" ")) {
            this.flushText();
            return;
        }
        if (Helper != null && string.length() > 3 && !StandardFonts.isValidGlyphName(string)) {
            string = Helper.mapNonstandardGlyfName(string, pdfFont);
        }
        if ((area = graphicsState.getClippingShape()) != null && !area.getBounds().contains(new Point((int)fArray[2][0] + 1, (int)fArray[2][1] + 1)) && !area.getBounds().contains(new Point((int)fArray[2][0] + n / 2, (int)fArray[2][1] + n / 2))) {
            return;
        }
        double[] dArray = new double[]{fArray[2][0], fArray[2][1]};
        this.correctCoords(dArray);
        if (this.textMode == 1 || this.textMode == 2 && this.getType() == 5) {
            this.currentTextPosition = new TextPosition(dArray, new float[]{fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1], fArray2[2][0], fArray2[2][1]});
            this.rasterizeTextAsShape(pdfGlyph, graphicsState, pdfFont, string);
            return;
        }
        switch (this.pageRotation) {
            case 90: {
                float f6 = fArray[2][0];
                float f7 = fArray[2][1];
                fArray = Matrix.multiply(fArray, new float[][]{{0.0f, -1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}});
                if (fArray[0][0] == 0.0f && fArray[1][1] == 0.0f && fArray[0][1] * fArray[1][0] < 0.0f && graphicsState.CTM[0][0] > 0.0f && graphicsState.CTM[1][1] > 0.0f) {
                    fArray[2][0] = f7;
                    fArray[2][1] = (float)(this.cropBox.getHeight() - (double)f6);
                    break;
                }
                fArray[2][0] = f6;
                fArray[2][1] = f7;
                break;
            }
            case 270: {
                float f6 = fArray[2][0];
                float f7 = fArray[2][1];
                if (fArray[0][0] > 0.0f && fArray[1][1] > 0.0f && fArray[0][1] == 0.0f && fArray[1][0] == 0.0f) break;
                fArray = Matrix.multiply(fArray, new float[][]{{0.0f, 1.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}});
                break;
            }
        }
        if (f == -100.0f) {
            f = pdfFont.getWidth(-1);
        }
        int n5 = -1;
        int n6 = -1;
        TextState textState = graphicsState.getTextState();
        if (textState != null) {
            f5 = fArray[0][0];
            float f8 = textState.getCharacterSpacing();
            float f9 = textState.getWordSpacing();
            f4 = f5 - (float)((int)f5);
            if (f5 > 1.0f) {
                if (n == 9 && f4 == 0.5f && (double)f8 > -0.2 && f9 == 0.0f && n != (int)f5) {
                    n5 = (int)f5;
                    n6 = 1;
                } else if (n == 8 && f5 > 8.0f && f8 > 0.0f && f4 < 0.3f && f9 == 0.0f) {
                    n5 = n + 1;
                    n6 = 2;
                }
            }
        }
        if (fArray[0][0] != fArray[1][1] && fArray[1][0] == 0.0f && fArray[0][1] == 0.0f) {
            n = (int)fArray[0][0];
        }
        if (string.length() == 0 || TextBlock.ignoreGlyf(string)) {
            return;
        }
        if (n < 0) {
            n = -n;
        }
        f5 = (float)n * f;
        if (!pdfFont.getBaseFontName().equals(this.lastFontUsed)) {
            this.fontMapper = this.getFontMapper(pdfFont);
            this.lastFontUsed = pdfFont.getBaseFontName();
            String string2 = (String)this.embeddedFontsByFontID.get(this.lastFontUsed);
            if (string2 == null) {
                this.embeddedFontsByFontID.put(this.lastFontUsed, "browser");
            } else if (!string2.contains("browser")) {
                this.embeddedFontsByFontID.put(this.lastFontUsed, string2 + ',' + "browser");
            }
        }
        int n7 = n4 = (n3 = graphicsState.getTextRenderType()) == 1 ? graphicsState.getStrokeColor().getRGB() : graphicsState.getNonstrokeColor().getRGB();
        if (this.lastTrm != null && fArray[0][0] == this.lastTrm[0][0] && fArray[0][1] == this.lastTrm[0][1] && fArray[1][0] == this.lastTrm[1][0] && fArray[1][1] == this.lastTrm[1][1] && string.equals(this.lastGlyf)) {
            f4 = Math.abs(fArray[2][0] - this.lastTrm[2][0]);
            f3 = Math.abs(fArray[2][1] - this.lastTrm[2][1]);
            f2 = 1.0f;
            if (f4 < f2 && f3 < f2) {
                return;
            }
        }
        f4 = (float)dArray[0];
        f3 = (float)dArray[1];
        f2 = f4;
        float f10 = f3;
        if (this.pageRotation == 90) {
            f2 = fArray[2][1];
            f10 = fArray[2][0];
        }
        if (this.writeEveryGlyf || !this.currentTextBlock.isSameFont(n, this.fontMapper, fArray, n4) || !this.currentTextBlock.appendText(string, f5, f2, f10, this.groupGlyphsInTJ, !this.groupGlyphsInTJ || this.currentTokenNumber != this.lastTokenNumber, f4, f3)) {
            this.flushText();
            this.currentTextPosition = new TextPosition(dArray, new float[]{fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1], fArray2[2][0], fArray2[2][1]});
            if (!string.equals(" ")) {
                float f11 = (float)n * pdfFont.getCurrentFontSpaceWidth();
                this.currentTextBlock = new TextBlock(string, n, this.fontMapper, fArray, f4, f3, f5, n4, f11, this.cropBox.getBounds(), fArray, n5, n6, f2, f10, this.pageRotation);
                if (this.convertSpacesTonbsp) {
                    this.currentTextBlock.convertSpacesTonbsp(true);
                }
                if (this.currentTextBlock.getRotationAngle() == 0.0f) {
                    this.currentTextBlock.adjustY(-n);
                }
            } else {
                this.currentTextBlock = new TextBlock();
            }
        }
        this.lastTokenNumber = this.currentTokenNumber;
        this.lastGlyf = string;
        this.lastTrm = fArray;
    }

    private void rasterizeTextAsShape(PdfGlyph pdfGlyph, GraphicsState graphicsState, PdfFont pdfFont, String string) {
        if (pdfGlyph != null && pdfGlyph.getShape() != null && !string.equals(" ")) {
            GraphicsState graphicsState2 = graphicsState;
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                if (!Character.isLetterOrDigit(string.charAt(i))) {
                    bl = true;
                }
                if (bl) break;
            }
            String string2 = (String)pdfFont.getFontID();
            if (this.usedFontIDs.containsKey(string2 = StringUtils.makeMethodSafe(string2)) && this.usedFontIDs.get(string2) != pdfFont.getBaseFontName()) {
                string2 = string2 + StringUtils.makeMethodSafe(pdfFont.getBaseFontName());
            } else {
                this.usedFontIDs.put(string2, pdfFont.getBaseFontName());
            }
            String string3 = bl ? string2 + Integer.toHexString(string.charAt(0)) : (string.length() == 0 ? string2 + '_' + pdfGlyph.getID() : string2 + string);
            if (!Character.isLetter(string3.charAt(0))) {
                string3 = 's' + string3;
            }
            String string4 = pdfFont.getBaseFontName() + '.' + string3;
            boolean bl2 = this.glyfsRasterized.containsKey(string4);
            Area area = (Area)pdfGlyph.getShape().clone();
            graphicsState2.setClippingShape(null);
            graphicsState2.setFillType(graphicsState.getTextRenderType());
            float f = (float)(1.0 / pdfFont.FontMatrix[0]);
            if (area.getBounds().height > 2000) {
                f *= 100.0f;
            }
            this.writeCustom(2, "pdf.save();");
            this.writePosition(string3, true, f);
            this.completeTextShape(graphicsState, string3);
            if (!bl2) {
                this.drawNonPatternedShape(area, graphicsState2, 21610, string3, null, null);
                this.glyfsRasterized.put(string4, "x");
            }
            this.completeRasterizedText();
        }
    }

    protected void completeTextShape(GraphicsState graphicsState, String string) {
        throw new RuntimeException("method root completeTextShape(GraphicsState gs, String JSRoutineName) should not be called");
    }

    protected FontMapper getFontMapper(PdfFont pdfFont) {
        return null;
    }

    public void drawShape(Shape shape, GraphicsState graphicsState, int n) {
        if (graphicsState.getFillType() == 2) {
            double d = shape.getBounds2D().getX();
            double d2 = shape.getBounds2D().getY();
            double d3 = shape.getBounds2D().getWidth();
            double d4 = shape.getBounds2D().getHeight();
            float f = graphicsState.getCTMAdjustedLineWidth();
            if (d4 <= 1.0 && f <= 1.0f) {
                graphicsState.setFillType(1);
                graphicsState.setStrokeColor(graphicsState.getNonstrokeColor());
                graphicsState.setCTMAdjustedLineWidth(0.1f);
                shape = new Line2D.Double(d, d2, d + d3, d2);
            }
            if (d3 <= 1.0 && f <= 1.0f) {
                graphicsState.setFillType(1);
                graphicsState.setStrokeColor(graphicsState.getNonstrokeColor());
                graphicsState.setCTMAdjustedLineWidth(0.1f);
                shape = new Line2D.Double(d, d2, d, d2 + d4);
            }
        }
        if (!this.isObjectVisible(shape.getBounds(), graphicsState.getClippingShape())) {
            return;
        }
        this.flushText();
        if (this.emulateEvenOdd || graphicsState.getNonstrokeColor().isPattern() || graphicsState.nonstrokeColorSpace.getID() == 1146450818) {
            this.drawPatternedShape(shape, graphicsState);
        } else {
            this.drawNonPatternedShape(shape, graphicsState, n, null, this.cropBox, this.midPoint);
        }
    }

    protected void drawNonPatternedShape(Shape shape, GraphicsState graphicsState, int n, String string, Rectangle2D rectangle2D, Point2D point2D) {
    }

    protected void drawPatternedShape(Shape shape, GraphicsState graphicsState) {
        Shape shape2;
        double d = shape.getBounds2D().getWidth();
        double d2 = shape.getBounds2D().getHeight();
        double d3 = shape.getBounds2D().getX();
        double d4 = shape.getBounds2D().getY();
        this.coords = new double[]{d3, d4};
        this.correctCoords(this.coords);
        int n = (int)(this.coords[0] * (double)this.scaling);
        int n2 = (int)((this.coords[0] + d - (double)((int)this.coords[0])) * (double)this.scaling + 1.0);
        int n3 = (int)((this.coords[1] - d2) * (double)this.scaling);
        int n4 = (int)((this.coords[1] + d2 - (double)((int)this.coords[1])) * (double)this.scaling + 1.0);
        if (n2 < 1 || n4 < 1) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n4, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        AffineTransform affineTransform = new AffineTransform();
        PdfPaint pdfPaint = this.emulateEvenOdd ? graphicsState.nonstrokeColorSpace.getColor() : graphicsState.getNonstrokeColor();
        affineTransform.scale(this.scaling, this.scaling);
        affineTransform.scale(1.0, -1.0);
        affineTransform.translate(0.0, -d2);
        affineTransform.translate(-d3, -d4);
        int n5 = this.pageData.getCropBoxHeight(this.pageNumber);
        boolean bl = false;
        pdfPaint.setScaling(0.0, n5, this.scaling, 0.0f, (float)bl);
        pdfPaint.setRenderingType(4);
        graphics2D.setTransform(affineTransform);
        graphics2D.setPaint(pdfPaint);
        if (this.emulateEvenOdd) {
            shape2 = graphicsState.getClippingShape();
            if (shape2 != null) {
                graphics2D.clip(shape2);
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics2D.fill(shape);
        if (!this.emulateEvenOdd) {
            graphics2D.draw(shape);
        }
        shape2 = new Rectangle(n, n3, n2, n4);
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.cropBox.getX() * (double)this.scaling, this.cropBox.getY() * (double)this.scaling, this.cropBox.getWidth() * (double)this.scaling, this.cropBox.getHeight() * (double)this.scaling);
        if (double_.intersects((Rectangle2D)shape2)) {
            ++this.shadeId;
            if (this.pageRotation == 90 || this.pageRotation == 270) {
                n3 = (int)(((RectangularShape)double_).getHeight() - (double)n3 - (double)n4);
                int n6 = n2;
                n2 = n4;
                n4 = n6;
                n6 = n;
                n = n3;
                n3 = n6;
                bufferedImage = this.rotateImage(bufferedImage, this.pageRotation);
            }
            if (this.embedImageAsBase64) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
                    byteArrayOutputStream.close();
                    this.imageArray = new BASE64Encoder().encode(byteArrayOutputStream.toByteArray());
                    this.imageArray = this.imageArray.replace("\r\n", "\\\r\n");
                }
                catch (IOException iOException) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + iOException.getMessage());
                    }
                }
            } else {
                String string = this.fileName + "/shade/";
                File file = new File(this.rootDir + string);
                if (!file.exists()) {
                    file.mkdirs();
                }
                this.currentPatternedShapeName = this.customIO.writeImage(this.rootDir, string + this.shadeId, bufferedImage);
            }
            this.currentPatternedShape = new int[]{n, n3, n2, n4};
        } else {
            this.currentPatternedShape = new int[]{-1, -1, -1, -1};
        }
    }

    private boolean isObjectVisible(Rectangle rectangle, Area area) {
        if (!this.emulateEvenOdd && this.dx == 0 && this.dy == 0 && this.dr == 0) {
            Rectangle rectangle2 = area != null ? area.getBounds() : null;
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = rectangle.width + n;
            int n4 = rectangle.height + n2;
            if (this.cropBox != null) {
                double d = this.cropBox.getBounds2D().getX();
                double d2 = this.cropBox.getBounds2D().getY();
                double d3 = this.cropBox.getBounds2D().getWidth() + d;
                double d4 = this.cropBox.getBounds2D().getHeight() + d2;
                if ((double)n3 < d || (double)n > d3 || (double)n4 < d2 || (double)n2 > d4) {
                    return false;
                }
            }
            if (rectangle2 != null) {
                int n5 = rectangle2.x;
                int n6 = rectangle2.y;
                int n7 = rectangle2.width + n5;
                int n8 = rectangle2.height + n6;
                if (n3 < n5 || n > n7 || n4 < n6 || n2 > n8) {
                    return false;
                }
            }
        }
        return true;
    }

    public final void drawXForm(DynamicVectorRenderer dynamicVectorRenderer, GraphicsState graphicsState) {
        this.flushText();
        this.renderXForm(dynamicVectorRenderer, graphicsState.getAlpha(1));
    }

    protected void completeOutput() {
    }

    public void setOutputDir(String string, String string2, String string3) {
        this.rootDir = string;
        this.fileName = string2;
        this.pageNumberAsString = string3;
    }

    protected String coordsToStringParam(double[] dArray, int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                string = string + ",";
            }
            string = string + this.setPrecision(dArray[i]);
        }
        return string;
    }

    protected void correctCoords(double[] dArray) {
        dArray[0] = dArray[0] - this.midPoint.getX();
        dArray[0] = dArray[0] + this.cropBox.getWidth() / 2.0;
        dArray[1] = dArray[1] - this.midPoint.getY();
        dArray[1] = 0.0 - dArray[1];
        dArray[1] = dArray[1] + this.cropBox.getHeight() / 2.0;
    }

    protected static String rgbToColor(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        return "rgb(" + n2 + ',' + n3 + ',' + n4 + ')';
    }

    public static String hexColor(int n) {
        String string = Integer.toHexString(n);
        string = string.substring(2, 8);
        string = '#' + string;
        return string;
    }

    public static String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd - MMMMM - yyyy");
        Date date = new Date();
        return simpleDateFormat.format(date);
    }

    protected void drawTextArea() {
    }

    protected void drawPageBorder() {
    }

    public void flagCommand(int n, int n2) {
        switch (n) {
            case 16980: {
                break;
            }
            case 21610: {
                this.currentTokenNumber = n2;
            }
        }
    }

    protected String replaceTokenValues(String string) {
        String string2 = this.rootDir.substring(0, this.rootDir.length() - 1);
        int n = string2.lastIndexOf(92);
        int n2 = string2.lastIndexOf(47);
        if (n2 > n) {
            n = n2;
        }
        string2 = string2.substring(n + 1);
        if (string != null && string.contains("$")) {
            String string3 = string2;
            String string4 = String.valueOf(this.pageData.getPageCount());
            string = string.replace("$filename$", string3);
            string = string.replace("$pagecount$", string4);
        }
        return string;
    }

    public boolean isScalingControlledByUser() {
        return this.userControlledImageScaling;
    }

    protected static String setJavaFxWeight(String string) {
        String string2 = "";
        if (string.equals("normal")) {
            string2 = "NORMAL";
        } else if (string.equals("bold")) {
            string2 = "BOLD";
        } else if (string.equals("bolder")) {
            string2 = "BLACK";
        } else if (string.equals("lighter")) {
            string2 = "EXTRA_LIGHT";
        } else if (string.equals("100")) {
            string2 = "THIN";
        } else if (string.equals("900")) {
            string2 = "BLACK";
        }
        return string2;
    }

    protected void flushText() {
        if (this.currentTextBlock == null || this.currentTextBlock.isEmpty()) {
            return;
        }
        this.writeoutTextAsDiv(this.getFontScaling());
        if (!this.currentTextBlock.isEmpty()) {
            this.previousTextBlock = this.currentTextBlock;
        }
        this.currentTextBlock = new TextBlock();
    }

    private float getFontScaling() {
        float f = 0.0f;
        float[] fArray = this.currentTextPosition.getRawAffine();
        f = fArray[2] == 0.0f ? fArray[3] : (fArray[3] == 0.0f ? fArray[2] : (float)Math.sqrt(fArray[2] * fArray[2] + fArray[3] * fArray[3]));
        f = Math.abs(f);
        return f;
    }

    private float getFontScalingMarksNewVersion() {
        float f = 0.0f;
        float[] fArray = this.currentTextPosition.getRawAffine();
        if (fArray[0] == 0.0f) {
            System.out.println("1");
            f = fArray[1];
        } else if (fArray[1] == 0.0f) {
            System.out.println("2");
            f = fArray[0];
        } else {
            System.out.println("3");
            f = (float)Math.sqrt(fArray[2] * fArray[2] + fArray[3] * fArray[3]);
        }
        f = Math.abs(f);
        return f;
    }

    protected void writeoutTextAsDiv(float f) {
    }

    protected void writePosition(String string, boolean bl, float f) {
        double d;
        double d2;
        float[] fArray = new float[4];
        double[] dArray = this.currentTextPosition.getCoords();
        float[][] fArray2 = new float[3][3];
        switch (this.pageRotation) {
            default: {
                fArray2 = this.currentTextPosition.getTrm();
                d2 = dArray[0] * (double)this.scaling;
                d = dArray[1] * (double)this.scaling;
                fArray[0] = fArray2[0][0];
                fArray[1] = fArray2[0][1];
                fArray[2] = fArray2[1][0];
                fArray[3] = fArray2[1][1];
                if (bl) {
                    if (fArray[3] != 0.0f) {
                        fArray[3] = -fArray[3];
                    }
                } else {
                    if (this.type != 5 && this.type != 6) {
                        d2 -= (double)(fArray[1] * this.scaling);
                        d -= (double)(fArray[3] * this.scaling);
                    }
                    if (fArray[2] != 0.0f) {
                        fArray[2] = -fArray[2];
                    }
                }
                if (fArray[1] == 1.0f) break;
                fArray[1] = -fArray[1];
                break;
            }
            case 90: {
                d = dArray[0] * (double)this.scaling;
                d2 = (this.cropBox.getHeight() - dArray[1]) * (double)this.scaling;
                float[][] fArray3 = bl ? Matrix.multiply(this.currentTextPosition.getTrm(), new float[][]{{-1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}}) : Matrix.multiply(new float[][]{{0.0f, 1.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}}, this.currentTextPosition.getTrm());
                fArray[0] = fArray3[0][0];
                fArray[1] = fArray3[0][1];
                fArray[2] = fArray3[1][0];
                fArray[3] = fArray3[1][1];
                if (bl) break;
                if (fArray[0] < 0.0f && fArray[3] < 0.0f) {
                    fArray[0] = -fArray[0];
                    fArray[3] = -fArray[3];
                }
                d2 += (double)(fArray[1] * this.scaling);
                d -= (double)(fArray[3] * this.scaling);
                break;
            }
            case 180: {
                d2 = (this.cropBox.getWidth() - dArray[0]) * (double)this.scaling;
                d = (this.cropBox.getHeight() - dArray[1]) * (double)this.scaling;
                fArray2 = Matrix.multiply(this.currentTextPosition.getTrm(), new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, -1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}});
                fArray[0] = fArray2[0][0];
                fArray[1] = fArray2[0][1];
                fArray[2] = fArray2[1][0];
                fArray[3] = fArray2[1][1];
                if (bl) break;
                fArray[0] = -fArray[0];
                d -= (double)(fArray[3] * this.scaling);
                break;
            }
            case 270: {
                d = (this.cropBox.getWidth() - dArray[0]) * (double)this.scaling;
                d2 = dArray[1] * (double)this.scaling;
                float[][] fArray3 = bl ? Matrix.multiply(this.currentTextPosition.getTrm(), new float[][]{{-1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}}) : Matrix.multiply(this.currentTextPosition.getTrm(), new float[][]{{0.0f, -1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}});
                fArray[0] = fArray3[0][0];
                fArray[1] = fArray3[0][1];
                fArray[2] = fArray3[1][0];
                fArray[3] = fArray3[1][1];
                if (bl) break;
                if (fArray[0] < 0.0f && fArray[3] < 0.0f) {
                    fArray[0] = -fArray[0];
                    fArray[3] = -fArray[3];
                }
                d2 += (double)(fArray[1] * this.scaling);
            }
        }
        for (int i = 0; i < 4; ++i) {
            if ((double)fArray[i] != -0.0) continue;
            fArray[i] = 0.0f;
        }
        if (bl) {
            this.writeRasterizedTextPosition(string, fArray, (int)d2, (int)d, f);
        } else {
            this.writeTextPosition(fArray, (int)d2, (int)d, f);
        }
    }

    protected void writeTextPosition(float[] fArray, int n, int n2, float f) {
        throw new RuntimeException("writeTextPosition(float[] aff, int tx, int ty, int scaling)");
    }

    protected void writeRasterizedTextPosition(String string, float[] fArray, int n, int n2, float f) {
        throw new RuntimeException("method root writeRasterizedTextPosition(String JSRoutineName, float[] aff, int tx, int ty) should not be called");
    }

    protected void completeRasterizedText() {
        throw new RuntimeException("completeRasterizedText");
    }

    protected static String tidy(float f) {
        return OutputDisplay.removeEmptyDecimals(String.valueOf(f));
    }

    private static String removeEmptyDecimals(String string) {
        int n = string.indexOf(46);
        if (n > -1) {
            boolean bl = true;
            int n2 = string.length();
            for (int i = n + 1; i < n2; ++i) {
                if (string.charAt(i) == '0') continue;
                bl = false;
                i = n2;
            }
            if (bl) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    public void saveAdvanceWidth(String string, String string2, int n) {
        HashMap<String, Integer> hashMap = this.widths.get(string = string.replace('+', '-'));
        if (hashMap == null) {
            hashMap = new HashMap();
            this.widths.put(string, hashMap);
        }
        hashMap.put(string2, n);
    }

    public String getPageAsHTMLRef(int n) {
        if (n < 1) {
            n = 1;
        }
        if (n > this.endPage) {
            n = this.endPage;
        }
        String string = String.valueOf(n);
        if (this.firstPageName != null && n == 1) {
            string = this.firstPageName;
        } else {
            String string2 = String.valueOf(this.endPage);
            int n2 = string2.length() - string.length();
            for (int i = 0; i < n2; ++i) {
                string = '0' + string;
            }
        }
        return string;
    }

    protected String getMagazinePageAsHTMLRef(int n) {
        if (n == 1) {
            return this.getPageAsHTMLRef(n);
        }
        if (n % 2 == 0) {
            if (n == this.endPage) {
                return this.getPageAsHTMLRef(n);
            }
            return this.getPageAsHTMLRef(n) + "-" + this.getPageAsHTMLRef(n + 1);
        }
        return this.getPageAsHTMLRef(n - 1) + "-" + this.getPageAsHTMLRef(n);
    }

    public boolean avoidDownSamplingImage() {
        return this.keepOriginalImage;
    }
}

