/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import org.jpedal.parser.Cmd;

public class CommandParser {
    private byte[] characterStream;
    private int commandID = -1;
    private static final int[] prefixes = new int[]{60, 40};
    private static final int[] suffixes = new int[]{62, 41};
    private static final int[][] intValues = new int[][]{{0, 100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000}, {0, 10000, 20000, 30000, 40000, 50000, 60000, 70000, 80000, 90000}, {0, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000}, {0, 100, 200, 300, 400, 500, 600, 700, 800, 900}, {0, 10, 20, 30, 40, 50, 60, 70, 80, 90}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9}};
    private static final int MAXOPS = 50;
    private int[] opStart = new int[50];
    private int[] opEnd = new int[50];
    private int operandCount;
    private int currentOp = 0;

    public CommandParser(byte[] byArray) {
        this.characterStream = byArray;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    int getCommandValues(int n, int n2, int n3) {
        int n4;
        block34: {
            int n5;
            int n6;
            int n7;
            block35: {
                int n8;
                int n9;
                boolean bl;
                int n10;
                int n11;
                int n12;
                block38: {
                    int n13;
                    block39: {
                        int n14;
                        int n15;
                        block37: {
                            block36: {
                                n12 = prefixes.length;
                                n4 = this.characterStream[n];
                                n7 = 0;
                                this.commandID = -1;
                                n11 = this.characterStream.length;
                                n10 = n4;
                                if (n4 == 13 || n4 == 10 || n4 == 32 || n4 == 9) {
                                    ++n;
                                    while (n != n2 && ((n10 = this.characterStream[n]) == 13 || n10 == 10 || n10 == 32 || n10 == 9)) {
                                        ++n;
                                    }
                                }
                                while (n10 == 37) {
                                    ++n;
                                    while (n != n2) {
                                        n10 = this.characterStream[n];
                                        if (n10 == 13 || n10 == 10) {
                                            while (n + 1 < n2 && this.characterStream[n + 1] == 10) {
                                                n10 = this.characterStream[++n];
                                            }
                                            break;
                                        }
                                        ++n;
                                    }
                                    if (++n >= n2) break;
                                    n10 = this.characterStream[n];
                                }
                                if (n == n2) {
                                    return n;
                                }
                                bl = false;
                                n13 = this.getType(n10, n);
                                if (n13 != 3) break block36;
                                n15 = n;
                                break block37;
                            }
                            if (n13 == 4) break block34;
                            n6 = n;
                            if (n13 != 1 && n13 != 2) break block38;
                            break block39;
                        }
                        while (++n < n11 && (n10 = this.characterStream[n]) != 13 && n10 != 10 && n10 != 32 && n10 != 40 && n10 != 47 && n10 != 91 && n10 != 9 && n10 != 60) {
                        }
                        n7 = n - 1;
                        if (n7 >= n11) {
                            return n7;
                        }
                        byte by = this.characterStream[n7];
                        if (by == 47 || by == 91 || by == 60) {
                            --n7;
                        }
                        this.commandID = -1;
                        if (n7 - n15 < 3) {
                            int n16 = 0;
                            int n17 = 0;
                            for (n14 = n7; n14 > n15 - 1; n16 += this.characterStream[n14] << n17, n17 += 8, --n14) {
                            }
                            this.commandID = Cmd.getCommandID(n16);
                        }
                        if (this.commandID == -1) {
                            this.opStart[this.currentOp] = n15;
                            this.opEnd[this.currentOp] = n7;
                            ++this.currentOp;
                            if (this.currentOp == 50) {
                                this.currentOp = 0;
                            }
                            ++this.operandCount;
                            break block34;
                        } else {
                            if (this.operandCount > 0) {
                                int n18;
                                int[] nArray = new int[50];
                                int[] nArray2 = new int[50];
                                n14 = 0;
                                for (n18 = this.currentOp - 1; n18 > -1; ++n14, --n18) {
                                    nArray[n14] = this.opStart[n18];
                                    nArray2[n14] = this.opEnd[n18];
                                    if (n14 != this.operandCount) continue;
                                    n18 = -1;
                                }
                                if (n14 == this.operandCount) {
                                    --this.currentOp;
                                    for (n18 = 49; n18 > this.currentOp; ++n14, --n18) {
                                        nArray[n14] = this.opStart[n18];
                                        nArray2[n14] = this.opEnd[n18];
                                        if (n14 != this.operandCount) continue;
                                        n18 = this.currentOp;
                                    }
                                    ++this.currentOp;
                                }
                                this.opStart = nArray;
                                this.opEnd = nArray2;
                            }
                            return -n;
                        }
                    }
                    n5 = 0;
                    bl = true;
                    n9 = 32;
                    do {
                        n9 = n9 == 92 && n10 == 92 ? 120 : n10;
                        if (++n == n11) break;
                        n10 = this.characterStream[n];
                        if (n10 == 13 || n10 == 10 || n10 == 9) {
                            n10 = 32;
                        }
                        n8 = 0;
                        if (n10 == 62 && n9 == 62 && n13 == 1) {
                            n8 = 1;
                        }
                        if (n13 != 2) continue;
                        if (n10 == 40 && n9 != 92) {
                            n5 = 1;
                        } else if (n10 == 41 && n9 != 92) {
                            n5 = 0;
                        }
                        if (n5 != 0 || n10 != 93 || n9 == 92) continue;
                        n8 = 1;
                    } while (n8 == 0);
                    n7 = n;
                }
                boolean bl2 = true;
                while (true) {
                    block43: {
                        block44: {
                            block41: {
                                block42: {
                                    block40: {
                                        if (!bl2 || (bl2 = false)) break block40;
                                        if (bl) break block41;
                                        n5 = 32;
                                        n9 = 0;
                                    }
                                    if (n9 >= n12) break block42;
                                    if (n10 != prefixes[n9]) break block43;
                                    break block44;
                                }
                                n7 = n;
                            }
                            if (!bl) {
                                n6 = n;
                                n5 = this.characterStream[n6];
                                break;
                            }
                            break block35;
                        }
                        bl = true;
                        n6 = n;
                        n8 = 0;
                        while (true) {
                            n5 = n5 == 92 && n10 == 92 ? 120 : n10;
                            if (++n == n11) break;
                            n10 = this.characterStream[n];
                            if (n10 == 13 || n10 == 10 || n10 == 9) {
                                n10 = 32;
                            }
                            if (n10 == prefixes[n9] && n5 != 92) {
                                ++n8;
                            }
                            if (n10 != suffixes[n9] || n5 == 92) continue;
                            if (n8 == 0) break;
                            --n8;
                        }
                        n9 = n12;
                    }
                    ++n9;
                }
                while (++n != n11 && (n10 = this.characterStream[n]) != 13 && n10 != 10 && n10 != 32 && n10 != 40 && n10 != 47 && n10 != 91 && n10 != 9 && (n5 != 47 || n10 != 60)) {
                }
                n7 = n;
            }
            if (n7 >= this.characterStream.length || (n5 = this.characterStream[n7]) == 47 || n5 == 91) {
                // empty if block
            }
            this.opStart[this.currentOp] = n6;
            this.opEnd[this.currentOp] = --n7;
            ++this.currentOp;
            if (this.currentOp == 50) {
                this.currentOp = 0;
            }
            ++this.operandCount;
        }
        if (n < n2 && (n4 = this.characterStream[n]) != 47 && n4 != 40 && n4 != 91 && n4 != 60) {
            ++n;
        }
        return n;
    }

    public int getCommandID() {
        return this.commandID;
    }

    private int getType(int n, int n2) {
        int n3 = 0;
        if (n == 60 && this.characterStream[n2 + 1] == 60) {
            n3 = 1;
        } else if (n == 32) {
            n3 = 4;
        } else if (n == 91) {
            n3 = 2;
        } else if (n >= 97 && n <= 122) {
            n3 = 3;
        } else if (n >= 65 && n <= 90) {
            n3 = 3;
        } else if (n == 39 || n == 34) {
            n3 = 3;
        }
        return n3;
    }

    String generateOpAsString(int n, boolean bl) {
        byte[] byArray = this.characterStream;
        int n2 = this.opStart[n];
        if (bl && byArray[n2] == 47) {
            ++n2;
        }
        int n3 = this.opEnd[n];
        while (byArray[n3] == 32 || byArray[n3] == 13 || byArray[n3] == 10) {
            --n3;
        }
        int n4 = n3 - n2 + 1;
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            if (i <= 0 || byArray[n2 + i] != 32 && byArray[n2 + i] != 13 && byArray[n2 + i] != 10 || byArray[n2 + i - 1] != 32 && byArray[n2 + i - 1] != 13 && byArray[n2 + i - 1] != 10) continue;
            ++n5;
        }
        char[] cArray = new char[n4 - n5];
        int n6 = 0;
        for (int i = 0; i < n4; ++i) {
            if (i > 0 && (byArray[n2 + i] == 32 || byArray[n2 + i] == 13 || byArray[n2 + i] == 10) && (byArray[n2 + i - 1] == 32 || byArray[n2 + i - 1] == 13 || byArray[n2 + i - 1] == 10)) continue;
            cArray[n6] = byArray[n2 + i] == 10 || byArray[n2 + i] == 13 ? 32 : (char)byArray[n2 + i];
            ++n6;
        }
        String string = String.copyValueOf(cArray);
        return string;
    }

    final float parseFloat(int n) {
        float f;
        int n2;
        int n3;
        byte[] byArray = this.characterStream;
        int n4 = this.opStart[n];
        int n5 = n3 = this.opEnd[n] - n4;
        int n6 = 0;
        boolean bl = false;
        for (n2 = n3 - 1; n2 > -1; --n2) {
            if (byArray[n4 + n2] != 46) continue;
            n5 = n2;
            break;
        }
        n2 = n5;
        if (byArray[n4] == 43) {
            --n2;
            ++n6;
        } else if (byArray[n4] == 45) {
            ++n6;
            bl = true;
        }
        int n7 = n2 - n6;
        int n8 = n3 - n5;
        if (n7 > 3 || n8 > 11) {
            bl = false;
            f = Float.parseFloat(this.generateOpAsString(n, false));
        } else {
            int n9;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float f8 = 0.0f;
            float f9 = 0.0f;
            if (n7 > 2) {
                n9 = byArray[n4 + n6] - 48;
                switch (n9) {
                    case 1: {
                        f4 = 100.0f;
                        break;
                    }
                    case 2: {
                        f4 = 200.0f;
                        break;
                    }
                    case 3: {
                        f4 = 300.0f;
                        break;
                    }
                    case 4: {
                        f4 = 400.0f;
                        break;
                    }
                    case 5: {
                        f4 = 500.0f;
                        break;
                    }
                    case 6: {
                        f4 = 600.0f;
                        break;
                    }
                    case 7: {
                        f4 = 700.0f;
                        break;
                    }
                    case 8: {
                        f4 = 800.0f;
                        break;
                    }
                    case 9: {
                        f4 = 900.0f;
                    }
                }
                ++n6;
            }
            if (n7 > 1) {
                n9 = byArray[n4 + n6] - 48;
                switch (n9) {
                    case 1: {
                        f3 = 10.0f;
                        break;
                    }
                    case 2: {
                        f3 = 20.0f;
                        break;
                    }
                    case 3: {
                        f3 = 30.0f;
                        break;
                    }
                    case 4: {
                        f3 = 40.0f;
                        break;
                    }
                    case 5: {
                        f3 = 50.0f;
                        break;
                    }
                    case 6: {
                        f3 = 60.0f;
                        break;
                    }
                    case 7: {
                        f3 = 70.0f;
                        break;
                    }
                    case 8: {
                        f3 = 80.0f;
                        break;
                    }
                    case 9: {
                        f3 = 90.0f;
                    }
                }
                ++n6;
            }
            if (n7 > 0) {
                n9 = byArray[n4 + n6] - 48;
                switch (n9) {
                    case 1: {
                        f2 = 1.0f;
                        break;
                    }
                    case 2: {
                        f2 = 2.0f;
                        break;
                    }
                    case 3: {
                        f2 = 3.0f;
                        break;
                    }
                    case 4: {
                        f2 = 4.0f;
                        break;
                    }
                    case 5: {
                        f2 = 5.0f;
                        break;
                    }
                    case 6: {
                        f2 = 6.0f;
                        break;
                    }
                    case 7: {
                        f2 = 7.0f;
                        break;
                    }
                    case 8: {
                        f2 = 8.0f;
                        break;
                    }
                    case 9: {
                        f2 = 9.0f;
                    }
                }
            }
            if (n8 > 1) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f5 = 0.1f;
                        break;
                    }
                    case 2: {
                        f5 = 0.2f;
                        break;
                    }
                    case 3: {
                        f5 = 0.3f;
                        break;
                    }
                    case 4: {
                        f5 = 0.4f;
                        break;
                    }
                    case 5: {
                        f5 = 0.5f;
                        break;
                    }
                    case 6: {
                        f5 = 0.6f;
                        break;
                    }
                    case 7: {
                        f5 = 0.7f;
                        break;
                    }
                    case 8: {
                        f5 = 0.8f;
                        break;
                    }
                    case 9: {
                        f5 = 0.9f;
                    }
                }
            }
            if (n8 > 2) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f6 = 0.01f;
                        break;
                    }
                    case 2: {
                        f6 = 0.02f;
                        break;
                    }
                    case 3: {
                        f6 = 0.03f;
                        break;
                    }
                    case 4: {
                        f6 = 0.04f;
                        break;
                    }
                    case 5: {
                        f6 = 0.05f;
                        break;
                    }
                    case 6: {
                        f6 = 0.06f;
                        break;
                    }
                    case 7: {
                        f6 = 0.07f;
                        break;
                    }
                    case 8: {
                        f6 = 0.08f;
                        break;
                    }
                    case 9: {
                        f6 = 0.09f;
                    }
                }
            }
            if (n8 > 3) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f7 = 0.001f;
                        break;
                    }
                    case 2: {
                        f7 = 0.002f;
                        break;
                    }
                    case 3: {
                        f7 = 0.003f;
                        break;
                    }
                    case 4: {
                        f7 = 0.004f;
                        break;
                    }
                    case 5: {
                        f7 = 0.005f;
                        break;
                    }
                    case 6: {
                        f7 = 0.006f;
                        break;
                    }
                    case 7: {
                        f7 = 0.007f;
                        break;
                    }
                    case 8: {
                        f7 = 0.008f;
                        break;
                    }
                    case 9: {
                        f7 = 0.009f;
                    }
                }
            }
            if (n8 > 4) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f8 = 1.0E-4f;
                        break;
                    }
                    case 2: {
                        f8 = 2.0E-4f;
                        break;
                    }
                    case 3: {
                        f8 = 3.0E-4f;
                        break;
                    }
                    case 4: {
                        f8 = 4.0E-4f;
                        break;
                    }
                    case 5: {
                        f8 = 5.0E-4f;
                        break;
                    }
                    case 6: {
                        f8 = 6.0E-4f;
                        break;
                    }
                    case 7: {
                        f8 = 7.0E-4f;
                        break;
                    }
                    case 8: {
                        f8 = 8.0E-4f;
                        break;
                    }
                    case 9: {
                        f8 = 9.0E-4f;
                    }
                }
            }
            if (n8 > 5) {
                n9 = byArray[n4 + ++n5] - 48;
                switch (n9) {
                    case 1: {
                        f9 = 1.0E-5f;
                        break;
                    }
                    case 2: {
                        f9 = 2.0E-5f;
                        break;
                    }
                    case 3: {
                        f9 = 3.0E-5f;
                        break;
                    }
                    case 4: {
                        f9 = 4.0E-5f;
                        break;
                    }
                    case 5: {
                        f9 = 5.0E-5f;
                        break;
                    }
                    case 6: {
                        f9 = 6.0E-5f;
                        break;
                    }
                    case 7: {
                        f9 = 7.0E-5f;
                        break;
                    }
                    case 8: {
                        f9 = 8.0E-5f;
                        break;
                    }
                    case 9: {
                        f9 = 9.0E-5f;
                    }
                }
            }
            float f10 = f5 + f6 + f7 + f8 + f9;
            float f11 = f4 + f3 + f2;
            f = f11 + f10;
        }
        if (bl) {
            return -f;
        }
        return f;
    }

    float[] getValuesAsFloat() {
        float[] fArray = new float[this.operandCount];
        for (int i = 0; i < this.operandCount; ++i) {
            fArray[i] = this.parseFloat(i);
        }
        return fArray;
    }

    String[] getValuesAsString() {
        String[] stringArray = new String[this.operandCount];
        for (int i = 0; i < this.operandCount; ++i) {
            stringArray[i] = this.generateOpAsString(i, true);
        }
        return stringArray;
    }

    final int parseInt(int n) {
        int n2 = this.opStart[n];
        int n3 = this.opEnd[n];
        byte[] byArray = this.characterStream;
        int n4 = 0;
        int n5 = 0;
        int n6 = n3 - n2;
        int n7 = 0;
        boolean bl = false;
        int n8 = n6;
        if (byArray[n2] == 43) {
            --n8;
            ++n7;
        } else if (byArray[n2] == 45) {
            ++n7;
            bl = true;
        }
        int n9 = n8 - n7;
        if (n9 > 6) {
            bl = false;
            n4 = Integer.parseInt(this.generateOpAsString(n5, false));
        } else {
            for (int i = 5; i > -1; --i) {
                if (n9 <= i) continue;
                int n10 = byArray[n2 + n7] - 48;
                n4 += intValues[5 - i][n10];
                ++n7;
            }
        }
        if (bl) {
            return -n4;
        }
        return n4;
    }

    public void reset() {
        this.currentOp = 0;
        this.operandCount = 0;
    }

    public int getOperandCount() {
        return this.operandCount;
    }

    public byte[] getStream() {
        return this.characterStream;
    }

    public int getcurrentOp() {
        return this.currentOp;
    }
}

