/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.raw;

import org.jpedal.objects.raw.CIDEncodings;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class FontObject
extends PdfObject {
    String unknownValue = null;
    private static final int MMType1 = 1230852645;
    private static final int Type1C = 1077224796;
    private static final int ZaDb = 707859506;
    private static final int ZapfDingbats = 1889256112;
    private static final int Symbol = 1026712197;
    private PdfObject CharProcs = null;
    private PdfObject CIDSet = null;
    private PdfObject CIDSystemInfo = null;
    private PdfObject CIDToGIDMap = null;
    private PdfObject DescendantFonts = null;
    private PdfObject FontDescriptor = null;
    private PdfObject FontFile;
    private PdfObject FontFile2;
    private PdfObject FontFile3;
    private PdfObject ToUnicode;
    int BaseEncoding = -1;
    int CIDToGIDMapAsConstant = -1;
    int FirstChar = 1;
    int LastChar = 255;
    int Flags = 0;
    int MissingWidth = 0;
    int DW = -1;
    int StemV = 0;
    int Supplement = 0;
    float Ascent = 0.0f;
    float Descent = 0.0f;
    float[] Widths = null;
    float[] FontBBox = null;
    double[] FontMatrix = null;
    byte[][] Differences = null;
    private byte[] rawBaseFont = null;
    private byte[] rawCharSet = null;
    private byte[] rawCMapName = null;
    private byte[] rawFontName = null;
    private byte[] rawFontStretch = null;
    private byte[] rawOrdering = null;
    private byte[] rawRegistry = null;
    private byte[] rawW = null;
    private byte[] rawW2 = null;
    private String BaseFont = null;
    private String CharSet = null;
    private String CMapName = null;
    private String FontName = null;
    private String FontStretch = null;
    private String Ordering = null;
    private String Registry = null;
    private String W = null;
    private String W2 = null;

    public FontObject(String string) {
        super(string);
    }

    public FontObject(int n, int n2) {
        super(n, n2);
    }

    public FontObject(int n) {
        super(n);
    }

    public PdfObject getDictionary(int n) {
        switch (n) {
            case 2054190454: {
                return this.CharProcs;
            }
            case 337856605: {
                return this.CIDSet;
            }
            case 1972801240: {
                return this.CIDSystemInfo;
            }
            case 946823533: {
                return this.CIDToGIDMap;
            }
            case -1547306032: {
                return this.DescendantFonts;
            }
            case 1232564598: {
                return this.Encoding;
            }
            case -1044665361: {
                return this.FontDescriptor;
            }
            case 746093177: {
                return this.FontFile;
            }
            case 2021292334: {
                return this.FontFile2;
            }
            case 2021292335: {
                return this.FontFile3;
            }
            case 1919185554: {
                return this.ToUnicode;
            }
        }
        return super.getDictionary(n);
    }

    public void setIntNumber(int n, int n2) {
        switch (n) {
            case 859131783: {
                this.Ascent = n2;
                break;
            }
            case 860451719: {
                this.Descent = n2;
                break;
            }
            case 5159: {
                this.DW = n2;
                break;
            }
            case 1283093660: {
                this.FirstChar = n2;
                break;
            }
            case 1009858393: {
                this.Flags = n2;
                break;
            }
            case 795440262: {
                this.LastChar = n2;
                break;
            }
            case -1884569950: {
                this.MissingWidth = n2;
                break;
            }
            case 1144339785: {
                this.StemV = n2;
                break;
            }
            case 2104860094: {
                this.Supplement = n2;
                break;
            }
            default: {
                super.setIntNumber(n, n2);
            }
        }
    }

    public int getInt(int n) {
        switch (n) {
            case 5159: {
                return this.DW;
            }
            case 1283093660: {
                return this.FirstChar;
            }
            case 1009858393: {
                return this.Flags;
            }
            case 795440262: {
                return this.LastChar;
            }
            case -1884569950: {
                return this.MissingWidth;
            }
            case 1144339785: {
                return this.StemV;
            }
            case 2104860094: {
                return this.Supplement;
            }
        }
        return super.getInt(n);
    }

    public void setFloatNumber(int n, float f) {
        switch (n) {
            case 859131783: {
                this.Ascent = f;
                break;
            }
            case 860451719: {
                this.Descent = f;
                break;
            }
            default: {
                super.setFloatNumber(n, f);
            }
        }
    }

    public float getFloatNumber(int n) {
        switch (n) {
            case 859131783: {
                return this.Ascent;
            }
            case 860451719: {
                return this.Descent;
            }
        }
        return super.getFloatNumber(n);
    }

    public void setDictionary(int n, PdfObject pdfObject) {
        pdfObject.setID(n);
        if (n == 746093177 || n == 2021292334 || n == 2021292335) {
            this.hasStream = true;
        }
        switch (n) {
            case 2054190454: {
                this.CharProcs = pdfObject;
                break;
            }
            case 337856605: {
                this.CIDSet = pdfObject;
                break;
            }
            case 1972801240: {
                this.CIDSystemInfo = pdfObject;
                break;
            }
            case 946823533: {
                this.CIDToGIDMap = pdfObject;
                break;
            }
            case -1547306032: {
                this.DescendantFonts = pdfObject;
                break;
            }
            case 1232564598: {
                this.Encoding = pdfObject;
                break;
            }
            case -1044665361: {
                this.FontDescriptor = pdfObject;
                break;
            }
            case 746093177: {
                this.FontFile = pdfObject;
                break;
            }
            case 2021292334: {
                this.FontFile2 = pdfObject;
                break;
            }
            case 2021292335: {
                this.FontFile3 = pdfObject;
                break;
            }
            case 1919185554: {
                this.ToUnicode = pdfObject;
                break;
            }
            default: {
                super.setDictionary(n, pdfObject);
            }
        }
    }

    public int setConstant(int n, int n2, int n3, byte[] byArray) {
        int n4;
        block34: {
            n4 = -1;
            int n5 = 0;
            int n6 = 0;
            try {
                for (int i = n3 - 1; i > -1; --i) {
                    int n7 = byArray[n2 + i];
                    n5 += (n7 -= 48) << n6;
                    n6 += 8;
                }
                switch (n5) {
                    case -1684566726: {
                        n4 = -1684566726;
                        break;
                    }
                    case -1752352082: {
                        n4 = -1752352082;
                        break;
                    }
                    case -1684566724: {
                        n4 = -1684566724;
                        break;
                    }
                    case 320680256: {
                        n4 = 320680256;
                        break;
                    }
                    case 1232564598: {
                        n4 = 1232564598;
                        break;
                    }
                    case 2038913669: {
                        n4 = 2038913669;
                        break;
                    }
                    case 2038913683: {
                        n4 = 2038913683;
                        break;
                    }
                    case -1159739105: {
                        n4 = 3;
                        break;
                    }
                    case -1511664170: {
                        n4 = 0;
                        break;
                    }
                    case 1602998461: {
                        n4 = 6;
                        break;
                    }
                    case 1230852645: {
                        n4 = 1228944677;
                        break;
                    }
                    case -1595087640: {
                        n4 = 1;
                        break;
                    }
                    case 1228944676: {
                        n4 = 1228944676;
                        break;
                    }
                    case 1228944677: {
                        n4 = 1228944677;
                        break;
                    }
                    case 1077224796: {
                        n4 = 1228944677;
                        break;
                    }
                    case 1228944679: {
                        n4 = 1228944679;
                        break;
                    }
                    case 1217103210: {
                        n4 = 1217103210;
                        break;
                    }
                    case 1524428269: {
                        n4 = 2;
                        break;
                    }
                    default: {
                        if (n == 1232564598) {
                            n4 = CIDEncodings.getConstant(n5);
                            if (n4 == -1) {
                                byte[] byArray2 = new byte[n3];
                                System.arraycopy(byArray, n2, byArray2, 0, n3);
                                this.unknownValue = new String(byArray2);
                            }
                            if (debug && n4 == -1) {
                                System.out.println("Value not in PdfCIDEncodings");
                                byte[] byArray3 = new byte[n3];
                                System.arraycopy(byArray, n2, byArray3, 0, n3);
                                System.out.println("Add to CIDEncodings and as String");
                                System.out.println("key=" + new String(byArray3) + ' ' + n5 + " not implemented in setConstant in PdfFont Object");
                                System.out.println("final public static int CMAP_" + new String(byArray3) + '=' + n5 + ';');
                            }
                        } else {
                            n4 = super.setConstant(n, n5);
                        }
                        if (n4 == -1 && debug) {
                            byte[] byArray4 = new byte[n3];
                            System.arraycopy(byArray, n2, byArray4, 0, n3);
                            System.out.println("key=" + new String(byArray4) + ' ' + n5 + " not implemented in setConstant in PdfFont Object");
                            System.out.println("final public static int " + new String(byArray4) + '=' + n5 + ';');
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block34;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        switch (n) {
            case 1537782955: {
                this.BaseEncoding = n4;
                break;
            }
            case 946823533: {
                this.CIDToGIDMapAsConstant = n4;
                break;
            }
            case 1232564598: {
                this.generalType = n4;
                break;
            }
            case 1919185554: {
                this.generalType = n4;
                break;
            }
            default: {
                super.setConstant(n, n4);
            }
        }
        return n4;
    }

    public int getParameterConstant(int n) {
        switch (n) {
            case 1537782955: {
                if (n == 1537782955 && this.Encoding != null && this.Encoding.isZapfDingbats) {
                    return 5;
                }
                if (n == 1537782955 && this.Encoding != null && this.Encoding.isSymbol) {
                    return 4;
                }
                return this.BaseEncoding;
            }
            case 946823533: {
                return this.CIDToGIDMapAsConstant;
            }
        }
        int n2 = super.getParameterConstant(n);
        return n2;
    }

    public void setStream() {
        this.hasStream = true;
    }

    public PdfArrayIterator getMixedArray(int n) {
        switch (n) {
            case 1954328750: {
                return new PdfArrayIterator(this.Differences);
            }
        }
        return super.getMixedArray(n);
    }

    public byte[][] getByteArray(int n) {
        switch (n) {
            case 1954328750: {
                return this.Differences;
            }
        }
        return super.getByteArray(n);
    }

    public double[] getDoubleArray(int n) {
        switch (n) {
            case -2105119560: {
                return FontObject.deepCopy(this.FontMatrix);
            }
        }
        return super.getDoubleArray(n);
    }

    public void setDoubleArray(int n, double[] dArray) {
        switch (n) {
            case -2105119560: {
                this.FontMatrix = dArray;
                break;
            }
            default: {
                super.setDoubleArray(n, dArray);
            }
        }
    }

    public void setMixedArray(int n, byte[][] byArray) {
        switch (n) {
            case 1954328750: {
                this.Differences = byArray;
                break;
            }
            default: {
                super.setMixedArray(n, byArray);
            }
        }
    }

    public float[] getFloatArray(int n) {
        switch (n) {
            case 676429196: {
                return FontObject.deepCopy(this.FontBBox);
            }
            case 876896124: {
                return FontObject.deepCopy(this.Widths);
            }
        }
        return super.getFloatArray(n);
    }

    public void setFloatArray(int n, float[] fArray) {
        switch (n) {
            case 676429196: {
                this.FontBBox = fArray;
                break;
            }
            case 876896124: {
                this.Widths = fArray;
                break;
            }
            default: {
                super.setFloatArray(n, fArray);
            }
        }
    }

    public void setName(int n, byte[] byArray) {
        switch (n) {
            case 678461817: {
                this.rawBaseFont = byArray;
                int n2 = PdfDictionary.generateChecksum(0, byArray.length, byArray);
                this.isZapfDingbats = n2 == 1889256112 || n2 == 707859506;
                boolean bl = this.isSymbol = n2 == 1026712197;
                if (this.Encoding == null) break;
                this.Encoding.isZapfDingbats = this.isZapfDingbats;
                this.Encoding.isSymbol = this.isSymbol;
                break;
            }
            case 827223669: {
                this.rawCMapName = byArray;
                break;
            }
            case 879786873: {
                this.rawFontName = byArray;
                break;
            }
            case 2038281912: {
                this.rawFontStretch = byArray;
                break;
            }
            default: {
                super.setName(n, byArray);
            }
        }
    }

    public void setTextStreamValue(int n, byte[] byArray) {
        switch (n) {
            case 1110863221: {
                this.rawCharSet = byArray;
                break;
            }
            case 1635480172: {
                this.rawOrdering = byArray;
                break;
            }
            case 1702459778: {
                this.rawRegistry = byArray;
                break;
            }
            case 39: {
                this.rawW = byArray;
                break;
            }
            case 9986: {
                this.rawW2 = byArray;
                break;
            }
            default: {
                super.setTextStreamValue(n, byArray);
            }
        }
    }

    public String getName(int n) {
        switch (n) {
            case 678461817: {
                if (this.BaseFont == null && this.rawBaseFont != null) {
                    this.BaseFont = new String(this.rawBaseFont);
                }
                return this.BaseFont;
            }
            case 827223669: {
                if (this.CMapName == null && this.rawCMapName != null) {
                    this.CMapName = new String(this.rawCMapName);
                }
                return this.CMapName;
            }
            case 879786873: {
                if (this.FontName == null && this.rawFontName != null) {
                    this.FontName = new String(this.rawFontName);
                }
                return this.FontName;
            }
            case 2038281912: {
                if (this.FontStretch == null && this.rawFontStretch != null) {
                    this.FontStretch = new String(this.rawFontStretch);
                }
                return this.FontStretch;
            }
            case 39: {
                if (this.W == null && this.rawW != null) {
                    this.W = new String(this.rawW);
                }
                return this.W;
            }
            case 9986: {
                if (this.W2 == null && this.rawW2 != null) {
                    this.W2 = new String(this.rawW2);
                }
                return this.W2;
            }
        }
        return super.getName(n);
    }

    public String getTextStreamValue(int n) {
        switch (n) {
            case 1110863221: {
                if (this.CharSet == null && this.rawCharSet != null) {
                    this.CharSet = new String(this.rawCharSet);
                }
                return this.CharSet;
            }
            case 1635480172: {
                if (this.Ordering == null && this.rawOrdering != null) {
                    this.Ordering = new String(this.rawOrdering);
                }
                return this.Ordering;
            }
            case 1702459778: {
                if (this.Registry == null && this.rawRegistry != null) {
                    this.Registry = new String(this.rawRegistry);
                }
                return this.Registry;
            }
            case 39: {
                if (this.W == null && this.rawW != null) {
                    this.W = new String(this.rawW);
                }
                return this.W;
            }
            case 9986: {
                if (this.W2 == null && this.rawW2 != null) {
                    this.W2 = new String(this.rawW2);
                }
                return this.W2;
            }
        }
        return super.getTextStreamValue(n);
    }

    public String getStringValue(int n, int n2) {
        byte[] byArray = null;
        switch (n) {
            case 678461817: {
                byArray = this.rawBaseFont;
                break;
            }
            case 827223669: {
                byArray = this.rawCMapName;
                break;
            }
            case 879786873: {
                byArray = this.rawFontName;
                break;
            }
            case 2038281912: {
                byArray = this.rawFontStretch;
            }
        }
        switch (n2) {
            case 0: {
                if (byArray != null) {
                    return new String(byArray);
                }
                return null;
            }
            case 1: {
                if (byArray != null) {
                    return new String(byArray);
                }
                return null;
            }
            case 2: {
                if (byArray != null) {
                    int n3 = byArray.length;
                    if (n3 > 6 && byArray[6] == 43) {
                        int n4 = n3 - 7;
                        byte[] byArray2 = new byte[n4];
                        System.arraycopy(byArray, 7, byArray2, 0, n4);
                        return new String(byArray2);
                    }
                    if (n3 > 7 && byArray[n3 - 7] == 43) {
                        int n5 = n3 - 7;
                        byte[] byArray3 = new byte[n5];
                        System.arraycopy(byArray, 0, byArray3, 0, n5);
                        return new String(byArray3);
                    }
                    return new String(byArray);
                }
                return null;
            }
        }
        throw new RuntimeException("Value not defined in getName(int,mode)");
    }

    public int getObjectType() {
        return 373243460;
    }

    public boolean decompressStreamWhenRead() {
        return true;
    }
}

