/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.formData;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.PdfDecoder;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.creation.FormFactory;
import org.jpedal.objects.acroforms.formData.GUIData;
import org.jpedal.objects.acroforms.utils.FormUtils;
import org.jpedal.objects.layers.PdfLayerList;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_String;

public abstract class ComponentData
implements GUIData {
    protected boolean rasterizeForms = false;
    protected int offset = 0;
    public static final int TEXT_TYPE = 0;
    public static final int BUTTON_TYPE = 1;
    public static final int LIST_TYPE = 2;
    public static final int UNKNOWN_TYPE = -1;
    protected boolean forceRedraw = false;
    protected Map hideObjectsMap = new HashMap();
    protected int userX;
    protected int userY;
    protected int widestPageNR;
    protected int widestPageR;
    protected int displayView;
    PdfObjectReader currentPdfFile = null;
    int formFactoryType = 1;
    protected Map rawFormData = new HashMap();
    protected Map convertFormIDtoRef = new HashMap();
    protected Map nameToRef = new HashMap();
    protected Map duplicateNames = new HashMap();
    protected Map caseInsensitiveNameToFieldName = new HashMap();
    protected Map nameToCompIndex;
    protected Map refToCompIndex;
    private Map fullyQualToRef = new HashMap();
    private List namesMap = new ArrayList();
    protected Map LastValueByName = new HashMap();
    protected Map LastValueChanged = new HashMap();
    private Map xfaRefToForm;
    protected Map componentsToIgnore = new HashMap();
    protected int insetW;
    protected int insetH;
    protected PdfPageData pageData;
    protected Javascript javascript;
    protected int pageHeight;
    protected int indent;
    protected int[] cropOtherY;
    protected float displayScaling;
    protected int rotation;
    protected float lastScaling = -1.0f;
    protected float oldRotation = 0.0f;
    protected float oldIndent = 0.0f;
    protected int startPage;
    protected int endPage;
    protected int currentPage;
    protected String lastNameAdded = "";
    protected Map duplicates = new HashMap();
    protected Map lastValidValue = new HashMap();
    protected Map lastUnformattedValue = new HashMap();
    protected Map typeValues;
    protected int nextFreeField = 0;
    protected float[][] popupBounds = new float[0][4];
    protected int[] xReached;
    protected int[] yReached;
    protected int[] trackPagesRendered;
    protected List[] formsUnordered;
    private int formCount;
    protected PdfLayerList layers;
    protected PdfDecoder pdfDecoder;

    public void setRasterizeForms(boolean bl) {
        this.rasterizeForms = bl;
    }

    public Object getLastValidValue(String string) {
        if (!string.contains(" 0 R") && !string.contains(" 0 X")) {
            string = (String)this.nameToRef.get(string);
        }
        return this.lastValidValue.get(string);
    }

    public void setLayerData(PdfLayerList pdfLayerList) {
        this.layers = pdfLayerList;
    }

    public List getComponentNameList(int n) {
        if (this.trackPagesRendered == null) {
            return null;
        }
        if (n != -1 && this.trackPagesRendered[n] == -1) {
            return null;
        }
        int n2 = n == -1 ? 0 : this.trackPagesRendered[n];
        ArrayList<String> arrayList = new ArrayList<String>();
        FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n2));
        while (n == -1 || formObject != null && formObject.getPageNumber() == n) {
            String string = null;
            if (formObject != null && (string = formObject.getNameUsed()).length() == 0) {
                string = null;
            }
            if (string != null) {
                if (formObject.testedForDuplicates()) {
                    formObject.testedForDuplicates(true);
                    String string2 = (String)this.duplicates.get(string);
                    if (string2 != null) {
                        this.duplicates.put(string, string2 + ',' + n2);
                    } else {
                        this.duplicates.put(string, String.valueOf(n2));
                    }
                }
                arrayList.add(string);
            }
            if (++n2 == this.nextFreeField + 1) break;
            formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n2));
        }
        return arrayList;
    }

    public Object getLastUnformattedValue(String string) {
        if (!string.contains(" 0 R") && !string.contains(" 0 X")) {
            string = (String)this.nameToRef.get(string);
        }
        return this.lastUnformattedValue.get(string);
    }

    public void reset(String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                String string2 = (String)this.nameToRef.get(stringArray[0]);
                this.lastValidValue.remove(string2);
                this.lastUnformattedValue.remove(string2);
            }
        } else {
            this.lastValidValue.clear();
            this.lastUnformattedValue.clear();
        }
    }

    public int getPageForFormObject(String string) {
        FormObject formObject = null;
        if (string.contains("R")) {
            formObject = (FormObject)this.rawFormData.get(string);
        } else {
            String string2 = (String)this.nameToRef.get(string);
            if (string2 != null) {
                formObject = (FormObject)this.rawFormData.get(string2);
            }
        }
        if (formObject == null) {
            return -1;
        }
        return formObject.getPageNumber();
    }

    public Integer getTypeValueByName(String string) {
        Object v = this.typeValues.get(string);
        if (v == null) {
            return FormFactory.UNKNOWN;
        }
        return (Integer)this.typeValues.get(string);
    }

    private void setStartForPage(int n) {
        this.trackPagesRendered[n] = this.nextFreeField;
    }

    public void setUnsortedListForPage(int n, List list) {
        this.formsUnordered[n] = list;
    }

    public Object getValue(Object object) {
        if (object == null) {
            return "";
        }
        Object v = ((String)object).contains("R") ? this.refToCompIndex.get(object) : this.nameToCompIndex.get(object);
        return this.getFormValue(v);
    }

    protected Object checkGUIObjectResolved(int n) {
        throw new RuntimeException("base method checkGUIObjectResolved(formNum) should not be called");
    }

    public void displayComponent(int n, FormObject formObject, Object object, int n2, int n3) {
        throw new RuntimeException("base method displayComponent( ) should not be called");
    }

    public void setCompVisible(Object object, boolean bl) {
        throw new RuntimeException("base method setCompVisible(formNum) should not be called");
    }

    public void displayComponents(int n, int n2) {
        if (this.rasterizeForms) {
            return;
        }
        this.startPage = n;
        this.endPage = n2;
        block0: for (int i = n; i < n2; ++i) {
            int n3 = this.getStartComponentCountForPage(i);
            if (this.nextFreeField + 1 <= n3) {
                return;
            }
            if (n3 == -1 || n3 == -999 || n <= 0 || n2 <= 0) continue;
            FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n3));
            while (formObject != null && formObject.getPageNumber() >= n && formObject.getPageNumber() < n2) {
                Object object = this.checkGUIObjectResolved(n3);
                if (object != null) {
                    this.syncKidValues(n3);
                    this.displayComponent(n3, formObject, object, n, i);
                }
                if (++n3 == this.nextFreeField + 1) continue block0;
                formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n3));
            }
        }
    }

    public void hideComp(String string, boolean bl) {
        Integer n;
        Object[] objectArray;
        int[] nArray = null;
        if (string == null) {
            nArray = new int[this.nextFreeField + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
        }
        if ((objectArray = this.getComponentsByName(string, n = Integer.valueOf(this.getIndexFromName(string)), true)) != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (nArray != null) {
                    FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(nArray[i]));
                    Rectangle rectangle = formObject.getBoundingRectangle();
                    float f = rectangle.x;
                    float f2 = rectangle.y;
                    float f3 = rectangle.width;
                    float f4 = rectangle.height;
                    Rectangle rectangle2 = new Rectangle((int)f, (int)f2, (int)f3, (int)f4);
                    ArrayList<Integer> arrayList = (ArrayList<Integer>)this.hideObjectsMap.get(rectangle2);
                    if (arrayList == null) {
                        arrayList = new ArrayList<Integer>();
                        for (int j = 0; j < this.nextFreeField + 1; ++j) {
                            FormObject formObject2 = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(j));
                            if (formObject2 == null || !rectangle2.contains(formObject2.getBoundingRectangle())) continue;
                            arrayList.add(j);
                        }
                        this.hideObjectsMap.put(rectangle2, arrayList);
                    }
                    if (arrayList != null) {
                        for (Object e : arrayList) {
                            int n2 = (Integer)e;
                            FormObject formObject3 = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n2));
                            Object object = null;
                            if (formObject3 == null || (object = formObject3.getGUIComponent()) == null) continue;
                            this.setCompVisible(object, !bl);
                        }
                    }
                }
                this.setCompVisible(objectArray[i], bl);
            }
        }
    }

    public Integer convertRefToID(Object object) {
        Integer n = object.toString().contains("R") ? (Integer)this.refToCompIndex.get(object) : (Integer)this.nameToCompIndex.get(object);
        return n;
    }

    public Object getWidget(Object object) {
        if (object == null) {
            return null;
        }
        Integer n = this.convertRefToID(object);
        if (n == null) {
            return null;
        }
        return this.checkGUIObjectResolved(n);
    }

    public void syncKidValues(int n) {
        throw new RuntimeException("base method syncFormsByName(name) should not be called");
    }

    public Object getFormValue(Object object) {
        throw new RuntimeException("base method getFormValue(checkObj) should not be called");
    }

    public int getNextFreeField() {
        return this.nextFreeField;
    }

    public int getMaxFieldSize() {
        return this.formCount;
    }

    public int getStartComponentCountForPage(int n) {
        if (this.trackPagesRendered == null) {
            return -999;
        }
        if (this.trackPagesRendered.length > n && n > -1) {
            return this.trackPagesRendered[n];
        }
        return -1;
    }

    public void initParametersForPage(PdfPageData pdfPageData, int n, PdfDecoder pdfDecoder) {
        int n2;
        int n3;
        if (this.cropOtherY == null || this.cropOtherY.length <= n) {
            this.resetComponents(0, n + 1, false);
        }
        this.cropOtherY[n] = (n3 = pdfPageData.getMediaBoxHeight(n)) != (n2 = pdfPageData.getCropBoxHeight(n) + pdfPageData.getCropBoxY(n)) ? n3 - n2 : 0;
        this.pageHeight = n3;
        this.currentPage = n;
        if (!this.formsRasterizedForDisplay()) {
            this.setStartForPage(n);
        }
        this.pdfDecoder = pdfDecoder;
    }

    public boolean resetComponents(int n, int n2, boolean bl) {
        if (bl && this.formCount > n) {
            return false;
        }
        this.formCount = n;
        if (!bl) {
            this.nextFreeField = 0;
            this.refToCompIndex = new HashMap(n + 1);
            this.nameToCompIndex = new HashMap(n + 1);
            this.typeValues = new HashMap(n + 1);
            this.popupBounds = new float[0][4];
            this.trackPagesRendered = new int[n2 + 1];
            for (int i = 0; i < n2 + 1; ++i) {
                this.trackPagesRendered[i] = -1;
            }
            this.formsUnordered = new List[n2 + 1];
            this.cropOtherY = new int[n2 + 1];
            this.yReached = null;
            this.xReached = null;
        }
        return true;
    }

    public void setPageValues(float f, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.rotation = n;
        this.displayScaling = f;
        this.indent = n2;
        this.userX = n3;
        this.userY = n4;
        this.displayView = n5;
        this.widestPageNR = n6;
        this.widestPageR = n7;
    }

    public void setPageData(PdfPageData pdfPageData, int n, int n2) {
        this.insetW = n;
        this.insetH = n2;
        this.pageData = pdfPageData;
    }

    public void setPageDisplacements(int[] nArray, int[] nArray2) {
        this.xReached = nArray;
        this.yReached = nArray2;
        this.forceRedraw = true;
    }

    public void setForceRedraw(boolean bl) {
        this.forceRedraw = bl;
    }

    public void setJavascript(Javascript javascript) {
        this.javascript = javascript;
    }

    public void resetDuplicates() {
        this.duplicates.clear();
    }

    protected boolean isFormNotPrinted(int n) {
        String string = this.convertIDtoRef(n);
        FormObject formObject = (FormObject)this.getRawForm(string)[0];
        if (formObject != null) {
            return this.componentsToIgnore != null && (this.componentsToIgnore.containsKey(formObject.getParameterConstant(1147962727)) || this.componentsToIgnore.containsKey(formObject.getParameterConstant(608780341)));
        }
        return false;
    }

    public void storeXFARefToForm(Map map) {
        this.xfaRefToForm = map;
    }

    public void storeRawData(FormObject formObject) {
        Object object;
        String string = formObject.getTextStreamValue(36);
        if (string != null) {
            this.namesMap.add(string);
            this.caseInsensitiveNameToFieldName.put(string.toLowerCase(), string);
        }
        String string2 = formObject.getObjectRefAsString();
        this.nameToRef.put(string, string2);
        this.rawFormData.put(string2, formObject);
        String string3 = formObject.getParentRef();
        boolean bl = false;
        String string4 = null;
        while (string3 != null && !string3.equals(string2)) {
            object = new FormObject(string3, false);
            this.pdfDecoder.getIO().readObject((PdfObject)object);
            String string5 = null;
            if (object != null) {
                string5 = ((FormObject)object).getTextStreamValue(36);
            }
            if (string5 == null) break;
            if (string != null && !string.contains(string5)) {
                string4 = string5 + '.' + string.substring(string.lastIndexOf(46) + 1);
                bl = true;
            }
            string3 = ((FormObject)object).getParentRef();
        }
        if (bl) {
            this.fullyQualToRef.put(string4, string2);
        }
        if ((object = (String)this.duplicateNames.get(string)) == null) {
            this.duplicateNames.put(string, string2);
        } else {
            object = (String)object + ',' + string2;
            this.duplicateNames.put(string, object);
        }
    }

    public void flushFormData() {
        this.nameToRef.clear();
        this.fullyQualToRef.clear();
        this.rawFormData.clear();
        this.LastValueByName.clear();
        this.duplicateNames.clear();
        this.convertFormIDtoRef.clear();
        this.namesMap.clear();
        this.lastNameAdded = "";
        this.hideObjectsMap.clear();
        this.oldIndent = -this.oldIndent;
    }

    public String convertIDtoRef(int n) {
        return (String)this.convertFormIDtoRef.get(n);
    }

    public int getFieldType(Object object) {
        int n = ((FormObject)object).getParameterConstant(1147962727);
        switch (n) {
            case 9288: {
                return 0;
            }
            case 4920: {
                return 2;
            }
        }
        return 1;
    }

    public String getnameToRef(String string) {
        return (String)this.nameToRef.get(string);
    }

    public int getIndexFromName(String string) {
        return (Integer)this.nameToCompIndex.get(FormUtils.removeStateToCheck(string, false));
    }

    public Object[] getRawForm(String string) {
        return this.getRawForm(string, true);
    }

    public Object[] getRawForm(String string, boolean bl) {
        String string2;
        if (!bl && (string2 = (String)this.caseInsensitiveNameToFieldName.get(string.toLowerCase())) != null) {
            string = string2;
        }
        if ((string2 = (String)this.duplicateNames.get(string)) == null || string2.indexOf(44) == -1) {
            String[] stringArray;
            if (!this.rawFormData.containsKey(string = this.getPossRef(string)) && (stringArray = this.getChildNames(string)) != null && stringArray.length > 0) {
                Object[] objectArray = new Object[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    string = this.getPossRef(stringArray[i]);
                    objectArray[i] = this.rawFormData.get(string);
                }
                return objectArray;
            }
            return new Object[]{this.rawFormData.get(string)};
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n = stringTokenizer.countTokens();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.rawFormData.get(stringTokenizer.nextToken());
        }
        return objectArray;
    }

    private String getPossRef(String string) {
        String string2 = (String)this.nameToRef.get(string);
        if (string2 != null) {
            string = string2;
        }
        if ((string2 = (String)this.fullyQualToRef.get(string)) != null) {
            string = string2;
        }
        return string;
    }

    public Map getRawFormData() {
        return this.rawFormData;
    }

    public String[] getChildNames(String string) {
        if (string == null) {
            return null;
        }
        if (!this.namesMap.isEmpty() && this.namesMap.toString().contains(string)) {
            Vector_String vector_String = new Vector_String();
            for (Object e : this.namesMap) {
                String string2 = (String)e;
                if (!string2.contains(string)) continue;
                vector_String.addElement(string2);
            }
            vector_String.trim();
            return vector_String.get();
        }
        return null;
    }

    public void completeField(FormObject formObject, int n, Integer n2, Object object, PdfObjectReader pdfObjectReader) {
        boolean bl = true;
        if (n2 < 0) {
            n2 = -n2.intValue();
            bl = false;
        }
        this.currentPdfFile = pdfObjectReader;
        if (object == null && this.formFactoryType != 1) {
            return;
        }
        String string = formObject.getTextStreamValue(36);
        this.refToCompIndex.put(formObject.getObjectRefAsString(), n);
        this.convertFormIDtoRef.put(n, formObject.getObjectRefAsString());
        if (n2.equals(FormFactory.UNKNOWN)) {
            this.typeValues.put(string, FormFactory.ANNOTATION);
        } else {
            this.typeValues.put(string, n2);
        }
        String string2 = string;
        if (string2 != null && bl) {
            String string3;
            String string4 = formObject.getNormalOnState();
            if (string4 != null && string4.length() > 0) {
                string2 = string2 + "-(" + string4 + ')';
            }
            if ((string3 = FormUtils.removeStateToCheck(string2, false)) != null && !this.lastNameAdded.equals(string3)) {
                this.nameToCompIndex.put(string3, n);
                this.lastNameAdded = string3;
            }
            formObject.setNameUsed(string3);
        }
        if (bl) {
            ++this.nextFreeField;
        }
        if (object != null) {
            formObject.setGUIComponent(object);
            this.setGUIComp(formObject, n, object);
        }
    }

    public void setGUIComp(FormObject formObject, int n, Object object) {
        throw new RuntimeException("Should never be called");
    }

    public Object[] getComponentsByName(String string) {
        if (string == null) {
            return null;
        }
        Object v = this.nameToCompIndex.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof Integer) {
            return this.getComponentsByName(string, v, false);
        }
        LogWriter.writeLog("{stream} ERROR DefaultAcroRenderer.getComponentByName() Object NOT Integer and NOT null");
        return null;
    }

    public Object[] getComponentsByName(String string, Object object, boolean bl) {
        int[] nArray = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = (String)this.duplicates.get(string);
        int n = (Integer)object;
        hashMap.put(String.valueOf(n), "x");
        boolean bl2 = true;
        int n2 = n;
        while (bl2) {
            FormObject formObject = (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n + 1));
            if (n + 1 < this.nextFreeField + 1 && formObject != null) {
                String string3 = formObject.getNameUsed();
                if (string3 == null) {
                    bl2 = false;
                    continue;
                }
                if (FormUtils.removeStateToCheck(string3, false).equals(string)) {
                    hashMap.put(String.valueOf(n + 1), "x");
                    ++n;
                    continue;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        int n3 = n + 1 - n2;
        Object[] objectArray = new Object[n3];
        if (bl) {
            nArray = new int[n3];
        }
        int n4 = 0;
        while (n4 < n3) {
            objectArray[n4] = this.checkGUIObjectResolved(n2);
            if (bl) {
                nArray[n4] = n2;
            }
            if (n2 == n) break;
            ++n4;
            ++n2;
        }
        if (string2 != null && string2.indexOf(44) != -1) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n5 = stringTokenizer.countTokens();
            int n6 = 0;
            String[] stringArray = new String[n5];
            for (int i = 0; i < n5; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
                if (!hashMap.containsKey(stringArray[i])) continue;
                ++n6;
                stringArray[i] = null;
            }
            Object[] objectArray2 = objectArray;
            objectArray = new Object[n3 + (n5 -= n6)];
            System.arraycopy(objectArray2, 0, objectArray, 0, n3);
            if (bl) {
                int[] nArray2 = nArray;
                nArray = new int[objectArray.length];
                System.arraycopy(nArray2, 0, nArray, 0, n3);
            }
            for (int i = 0; i < n5; ++i) {
                if (stringArray[i] == null) continue;
                int n7 = Integer.parseInt(stringArray[i]);
                if (bl) {
                    nArray[i + n3] = n7;
                }
                objectArray[i + n3] = this.checkGUIObjectResolved(n7);
            }
        }
        return objectArray;
    }

    protected static Rectangle checkPopupBoundsOnPage(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle.x < rectangle2.x) {
            rectangle.x = rectangle2.x;
        }
        if (rectangle.y < rectangle2.y) {
            rectangle.y = rectangle2.y;
        }
        if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
            rectangle.x = rectangle2.x + rectangle2.width - rectangle.width;
        }
        if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
            rectangle.y = rectangle2.y + rectangle2.height - rectangle.height;
        }
        return rectangle;
    }

    public void setUnformattedValue(String string, Object object) {
        if (!string.contains(" 0 R") && !string.contains(" 0 X")) {
            string = (String)this.nameToRef.get(string);
        }
        this.lastUnformattedValue.put(string, object);
    }

    public void setLastValidValue(String string, Object object) {
        if (!string.contains(" 0 R") && !string.contains(" 0 X")) {
            string = (String)this.nameToRef.get(string);
        }
        this.lastValidValue.put(string, object);
    }

    public Object setValue(String string, Object object, boolean bl, boolean bl2, Object object2) {
        Object v;
        if (bl) {
            this.setLastValidValue(string, object);
        }
        if (bl2) {
            this.setUnformattedValue(string, object2);
        }
        if ((v = string.contains("R") ? this.refToCompIndex.get(string) : this.nameToCompIndex.get(string)) == null) {
            return null;
        }
        String string2 = this.convertIDtoRef((Integer)v);
        FormObject formObject = (FormObject)this.rawFormData.get(string2);
        formObject.setValue((String)object);
        return v;
    }

    public void resetAfterPrinting() {
        this.forceRedraw = true;
    }

    public void invalidateForms() {
        this.lastScaling = -this.lastScaling;
    }

    public String getFieldNameFromRef(String string) {
        return ((FormObject)this.rawFormData.get(string)).getTextStreamValue(36);
    }

    public static int calculateFontSize(int n, int n2, boolean bl, String string) {
        int n3 = string.length();
        double d = (double)n * 0.85;
        if (n3 == 0) {
            return (int)d;
        }
        double d2 = n2 / n3;
        if (d > d2 * 2.0) {
            return (int)d2;
        }
        return (int)d;
    }

    public boolean formsRasterizedForDisplay() {
        return this.rasterizeForms;
    }

    public FormObject getFormObject(int n) {
        return (FormObject)this.rawFormData.get(this.convertFormIDtoRef.get(n));
    }

    public void setOffset(int n) {
        this.offset = n;
    }
}

