/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import org.jpedal.utils.Fonts;

public class PdfData {
    public static final int TEXT = 0;
    public static final int IMAGE = 1;
    public static final int HORIZONTAL_LEFT_TO_RIGHT = 0;
    public static final int HORIZONTAL_RIGHT_TO_LEFT = 1;
    public static final int VERTICAL_TOP_TO_BOTTOM = 2;
    public static final int VERTICAL_BOTTOM_TO_TOP = 3;
    private int pointer = 0;
    private boolean widthIsEmbedded = false;
    public float maxY = 0.0f;
    public float maxX = 0.0f;
    public static final String marker = String.valueOf('\u0000');
    public static final String hiddenMarker = String.valueOf('\ufffe');
    protected int max = 2000;
    public String[] contents = new String[this.max];
    public int[] f_writingMode = new int[this.max];
    public int[] text_length = new int[this.max];
    public int[] move_command = new int[this.max];
    public float[] f_character_spacing = new float[this.max];
    public int[] f_end_font_size = new int[this.max];
    public float[] space_width = new float[this.max];
    public float[] f_x1 = new float[this.max];
    public String[] colorTag = new String[this.max];
    public float[] f_x2 = new float[this.max];
    public float[] f_y1 = new float[this.max];
    public float[] f_y2 = new float[this.max];
    boolean isColorExtracted;

    public final int getRawTextElementCount() {
        return this.pointer;
    }

    public final void flushTextList(boolean bl) {
        if (!bl) {
            this.pointer = 0;
            this.max = 2000;
            this.contents = new String[this.max];
            this.f_writingMode = new int[this.max];
            this.text_length = new int[this.max];
            this.move_command = new int[this.max];
            this.f_character_spacing = new float[this.max];
            this.f_end_font_size = new int[this.max];
            this.space_width = new float[this.max];
            this.f_x1 = new float[this.max];
            this.f_x2 = new float[this.max];
            this.f_y1 = new float[this.max];
            this.f_y2 = new float[this.max];
            this.colorTag = new String[this.max];
        }
    }

    public final void addRawTextElement(float f, int n, String string, float f2, int n2, float f3, float f4, float f5, float f6, int n3, StringBuffer stringBuffer, int n4, String string2, boolean bl) {
        if (stringBuffer.length() > 0) {
            if (bl) {
                stringBuffer.insert(0, string);
                stringBuffer.append(Fonts.fe);
            }
            if (this.isColorExtracted) {
                stringBuffer.insert(0, string2);
                stringBuffer.append("</color>");
            }
            this.f_writingMode[this.pointer] = n;
            this.text_length[this.pointer] = n4;
            this.move_command[this.pointer] = n3;
            this.f_character_spacing[this.pointer] = f;
            this.f_x1[this.pointer] = f3;
            this.colorTag[this.pointer] = string2;
            this.f_x2[this.pointer] = f5;
            this.f_y1[this.pointer] = f4;
            this.f_y2[this.pointer] = f6;
            this.contents[this.pointer] = stringBuffer.toString();
            this.f_end_font_size[this.pointer] = n2;
            this.space_width[this.pointer] = f2 * 1000.0f;
            ++this.pointer;
            if (this.pointer == this.max) {
                this.resizeArrays(0);
            }
        }
    }

    private void resizeArrays(int n) {
        if (n < 0) {
            this.pointer = this.max = -n;
        } else if (n == 0) {
            this.max = this.max < 5000 ? (this.max *= 5) : (this.max < 10000 ? (this.max *= 2) : (this.max += 1000));
        } else {
            this.max = this.contents.length + n - 1;
            this.pointer = this.contents.length;
        }
        String[] stringArray = this.contents;
        this.contents = new String[this.max];
        System.arraycopy(stringArray, 0, this.contents, 0, this.pointer);
        int[] nArray = this.f_writingMode;
        this.f_writingMode = new int[this.max];
        this.f_writingMode = new int[this.max];
        System.arraycopy(nArray, 0, this.f_writingMode, 0, this.pointer);
        stringArray = this.colorTag;
        this.colorTag = new String[this.max];
        System.arraycopy(stringArray, 0, this.colorTag, 0, this.pointer);
        nArray = this.text_length;
        this.text_length = new int[this.max];
        System.arraycopy(nArray, 0, this.text_length, 0, this.pointer);
        nArray = this.move_command;
        this.move_command = new int[this.max];
        System.arraycopy(nArray, 0, this.move_command, 0, this.pointer);
        float[] fArray = this.f_character_spacing;
        this.f_character_spacing = new float[this.max];
        System.arraycopy(fArray, 0, this.f_character_spacing, 0, this.pointer);
        nArray = this.f_end_font_size;
        this.f_end_font_size = new int[this.max];
        System.arraycopy(nArray, 0, this.f_end_font_size, 0, this.pointer);
        fArray = this.space_width;
        this.space_width = new float[this.max];
        System.arraycopy(fArray, 0, this.space_width, 0, this.pointer);
        fArray = this.f_x1;
        this.f_x1 = new float[this.max];
        System.arraycopy(fArray, 0, this.f_x1, 0, this.pointer);
        fArray = this.f_x2;
        this.f_x2 = new float[this.max];
        System.arraycopy(fArray, 0, this.f_x2, 0, this.pointer);
        fArray = this.f_y1;
        this.f_y1 = new float[this.max];
        System.arraycopy(fArray, 0, this.f_y1, 0, this.pointer);
        fArray = this.f_y2;
        this.f_y2 = new float[this.max];
        System.arraycopy(fArray, 0, this.f_y2, 0, this.pointer);
    }

    public void widthIsEmbedded() {
        this.widthIsEmbedded = true;
    }

    public boolean IsEmbedded() {
        return this.widthIsEmbedded;
    }

    public void enableTextColorDataExtraction() {
        this.isColorExtracted = true;
    }

    public boolean isColorExtracted() {
        return this.isColorExtracted;
    }

    public void dispose() {
        this.contents = null;
        this.f_writingMode = null;
        this.text_length = null;
        this.move_command = null;
        this.f_character_spacing = null;
        this.f_end_font_size = null;
        this.space_width = null;
        this.f_x1 = null;
        this.colorTag = null;
        this.f_x2 = null;
        this.f_y1 = null;
        this.f_y2 = null;
    }
}

