/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter.ccitt;

import org.jpedal.io.filter.ccitt.CCITT1D;
import org.jpedal.io.filter.ccitt.CCITTDecoder;
import org.jpedal.objects.raw.PdfObject;

public class CCITT2D
extends CCITT1D
implements CCITTDecoder {
    int changingElemSize = 0;
    boolean is2D = true;
    int bitOffset;
    int currIndex;
    static final int[] initBlack = new int[]{3226, 6412, 200, 168, 38, 38, 134, 134, 100, 100, 100, 100, 68, 68, 68, 68};
    private static final byte[] code2D = new byte[]{80, 88, 23, 71, 30, 30, 62, 62, 4, 4, 4, 4, 4, 4, 4, 4, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 35, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41};
    static final int[] black = new int[]{62, 62, 30, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 3225, 588, 588, 588, 588, 588, 588, 588, 588, 1680, 1680, 20499, 22547, 24595, 26643, 1776, 1776, 1808, 1808, -24557, -22509, -20461, -18413, 1904, 1904, 1936, 1936, -16365, -14317, 782, 782, 782, 782, 814, 814, 814, 814, -12269, -10221, 10257, 10257, 12305, 12305, 14353, 14353, 16403, 18451, 1712, 1712, 1744, 1744, 28691, 30739, -32749, -30701, -28653, -26605, 2061, 2061, 2061, 2061, 2061, 2061, 2061, 2061, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 424, 750, 750, 750, 750, 1616, 1616, 1648, 1648, 1424, 1424, 1456, 1456, 1488, 1488, 1520, 1520, 1840, 1840, 1872, 1872, 1968, 1968, 8209, 8209, 524, 524, 524, 524, 524, 524, 524, 524, 556, 556, 556, 556, 556, 556, 556, 556, 1552, 1552, 1584, 1584, 2000, 2000, 2032, 2032, 976, 976, 1008, 1008, 1040, 1040, 1072, 1072, 1296, 1296, 1328, 1328, 718, 718, 718, 718, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 456, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 326, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 358, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 490, 4113, 4113, 6161, 6161, 848, 848, 880, 880, 912, 912, 944, 944, 622, 622, 622, 622, 654, 654, 654, 654, 1104, 1104, 1136, 1136, 1168, 1168, 1200, 1200, 1232, 1232, 1264, 1264, 686, 686, 686, 686, 1360, 1360, 1392, 1392, 12, 12, 12, 12, 12, 12, 12, 12, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390, 390};
    static final int[] additionalMakeup = new int[]{28679, 28679, 31752, 32777, 33801, 34825, 35849, 36873, 29703, 29703, 30727, 30727, 37897, 38921, 39945, 40969};
    static final int[] white = new int[]{6430, 6400, 6400, 6400, 3225, 3225, 3225, 3225, 944, 944, 944, 944, 976, 976, 976, 976, 1456, 1456, 1456, 1456, 1488, 1488, 1488, 1488, 718, 718, 718, 718, 718, 718, 718, 718, 750, 750, 750, 750, 750, 750, 750, 750, 1520, 1520, 1520, 1520, 1552, 1552, 1552, 1552, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 428, 654, 654, 654, 654, 654, 654, 654, 654, 1072, 1072, 1072, 1072, 1104, 1104, 1104, 1104, 1136, 1136, 1136, 1136, 1168, 1168, 1168, 1168, 1200, 1200, 1200, 1200, 1232, 1232, 1232, 1232, 622, 622, 622, 622, 622, 622, 622, 622, 1008, 1008, 1008, 1008, 1040, 1040, 1040, 1040, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 396, 1712, 1712, 1712, 1712, 1744, 1744, 1744, 1744, 846, 846, 846, 846, 846, 846, 846, 846, 1264, 1264, 1264, 1264, 1296, 1296, 1296, 1296, 1328, 1328, 1328, 1328, 1360, 1360, 1360, 1360, 1392, 1392, 1392, 1392, 1424, 1424, 1424, 1424, 686, 686, 686, 686, 686, 686, 686, 686, 910, 910, 910, 910, 910, 910, 910, 910, 1968, 1968, 1968, 1968, 2000, 2000, 2000, 2000, 2032, 2032, 2032, 2032, 16, 16, 16, 16, 10257, 10257, 10257, 10257, 12305, 12305, 12305, 12305, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 362, 878, 878, 878, 878, 878, 878, 878, 878, 1904, 1904, 1904, 1904, 1936, 1936, 1936, 1936, -18413, -18413, -16365, -16365, -14317, -14317, -10221, -10221, 590, 590, 590, 590, 590, 590, 590, 590, 782, 782, 782, 782, 782, 782, 782, 782, 1584, 1584, 1584, 1584, 1616, 1616, 1616, 1616, 1648, 1648, 1648, 1648, 1680, 1680, 1680, 1680, 814, 814, 814, 814, 814, 814, 814, 814, 1776, 1776, 1776, 1776, 1808, 1808, 1808, 1808, 1840, 1840, 1840, 1840, 1872, 1872, 1872, 1872, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, 6157, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, -12275, 14353, 14353, 14353, 14353, 16401, 16401, 16401, 16401, 22547, 22547, 24595, 24595, 20497, 20497, 20497, 20497, 18449, 18449, 18449, 18449, 26643, 26643, 28691, 28691, 30739, 30739, -32749, -32749, -30701, -30701, -28653, -28653, -26605, -26605, -24557, -24557, -22509, -22509, -20461, -20461, 8207, 8207, 8207, 8207, 8207, 8207, 8207, 8207, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 72, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 104, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 4107, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 266, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 298, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 524, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 556, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 136, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 168, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 460, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 492, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 2059, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 200, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232, 232};
    static final int[] twoBitBlack = new int[]{292, 260, 226, 226};

    public CCITT2D(byte[] byArray, int n, int n2, PdfObject pdfObject) {
        super(byArray, n, n2, pdfObject);
    }

    CCITT2D() {
    }

    public byte[] decode() {
        this.decode2DRun();
        byte[] byArray = this.createOutputFromBitset();
        if (!this.BlackIs1) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)(255 - byArray[i]);
            }
        }
        return byArray;
    }

    private void decode2DRun() {
        int[] nArray = new int[this.width + 1];
        int[] nArray2 = new int[this.width + 1];
        this.changingElemSize = 2;
        nArray2[0] = this.width;
        nArray2[1] = this.width;
        int n = 0;
        int[] nArray3 = new int[2];
        for (int i = 0; i < this.height; ++i) {
            if (this.isByteAligned && this.bitReached > 0) {
                int n2 = this.bitReached % 8;
                int n3 = 8 - n2;
                if (n2 > 0) {
                    this.bitReached += n3;
                }
            }
            int[] nArray4 = nArray;
            nArray = nArray2;
            nArray2 = nArray4;
            this.set2D(nArray, nArray2, this.changingElemSize, nArray3);
            if (nArray2.length != this.currIndex) {
                nArray2[this.currIndex++] = this.bitOffset;
            }
            this.changingElemSize = this.currIndex;
            n += this.scanlineStride;
        }
    }

    void set2D(int[] nArray, int[] nArray2, int n, int[] nArray3) {
        this.isWhite = true;
        this.currIndex = 0;
        this.bitOffset = 0;
        int n2 = 0;
        int n3 = -1;
        block5: while (this.bitOffset < this.width) {
            int n4;
            CCITT2D.getNextChangingElement(n3, this.isWhite, nArray3, nArray, n);
            int n5 = this.get1DBits(7);
            this.bitReached += 7;
            int n6 = code2D[n5] & 0xFF;
            int n7 = (n6 & 0x78) >>> 3;
            if (!this.is2D) {
                n2 = n6 & 7;
            } else if (n7 != 11) {
                this.updatePointer(7 - (n6 & 7));
            }
            switch (n7) {
                case 0: {
                    n4 = nArray3[1] - this.bitOffset;
                    if (!this.isWhite) {
                        this.out.set(this.outPtr, this.outPtr + n4, true);
                    }
                    this.outPtr += n4;
                    this.bitOffset = nArray3[1];
                    n3 = nArray3[1];
                    if (this.is2D) continue block5;
                    this.bitReached -= 7 - n2;
                    continue block5;
                }
                case 1: {
                    if (!this.is2D) {
                        this.bitReached -= 7 - n2;
                    }
                    if (this.isWhite) {
                        n4 = this.getWhiteRunCodeWord();
                        this.outPtr += n4;
                        this.bitOffset += n4;
                        nArray2[this.currIndex++] = this.bitOffset;
                        n4 = this.getBlackRunCodeWord();
                        this.out.set(this.outPtr, this.outPtr + n4, true);
                        this.outPtr += n4;
                    } else {
                        n4 = this.getBlackRunCodeWord();
                        this.out.set(this.outPtr, this.outPtr + n4, true);
                        this.outPtr += n4;
                        this.bitOffset += n4;
                        nArray2[this.currIndex++] = this.bitOffset;
                        n4 = this.getWhiteRunCodeWord();
                        this.outPtr += n4;
                    }
                    this.bitOffset += n4;
                    nArray2[this.currIndex++] = this.bitOffset;
                    n3 = this.bitOffset;
                    continue block5;
                }
                case 11: {
                    int n8 = this.get1DBits(3);
                    this.bitReached += 3;
                    if (n8 != 7) {
                        throw new RuntimeException("Unexpected value " + n8);
                    }
                    int n9 = 0;
                    boolean bl = false;
                    while (!bl) {
                        while (true) {
                            n5 = this.get1DBits(1);
                            ++this.bitReached;
                            if (n5 == 1) break;
                            ++n9;
                        }
                        if (n9 > 5) {
                            if (!this.isWhite && (n9 -= 6) > 0) {
                                nArray2[this.currIndex++] = this.bitOffset;
                            }
                            this.bitOffset += n9;
                            if (n9 > 0) {
                                this.isWhite = true;
                            }
                            n5 = this.get1DBits(1);
                            ++this.bitReached;
                            if (n5 == 0) {
                                if (!this.isWhite) {
                                    nArray2[this.currIndex++] = this.bitOffset;
                                }
                                this.isWhite = true;
                            } else {
                                if (this.isWhite) {
                                    nArray2[this.currIndex++] = this.bitOffset;
                                }
                                this.isWhite = false;
                            }
                            bl = true;
                        }
                        if (n9 == 5) {
                            if (!this.isWhite) {
                                nArray2[this.currIndex++] = this.bitOffset;
                            }
                            this.bitOffset += n9;
                            this.isWhite = true;
                            continue;
                        }
                        this.bitOffset += n9;
                        nArray2[this.currIndex++] = this.bitOffset++;
                        this.out.set(this.outPtr, this.outPtr + 1, true);
                        ++this.outPtr;
                        this.isWhite = false;
                    }
                    continue block5;
                }
            }
            if (n7 > 8) {
                throw new RuntimeException("CCITT unexpected value");
            }
            nArray2[this.currIndex++] = nArray3[0] + (n7 - 5);
            n4 = nArray3[0] + (n7 - 5) - this.bitOffset;
            if (!this.isWhite) {
                this.out.set(this.outPtr, this.outPtr + n4, true);
            }
            this.outPtr += n4;
            this.bitOffset = n3 = nArray3[0] + (n7 - 5);
            boolean bl = this.isWhite = !this.isWhite;
            if (this.is2D) continue;
            this.bitReached -= 7 - n2;
        }
    }

    int getBlackRunCodeWord() {
        int n = 0;
        boolean bl = true;
        block4: while (bl) {
            int n2 = this.get1DBits(4);
            this.bitReached += 4;
            int n3 = initBlack[n2];
            int n4 = n3 >>> 1 & 0xF;
            int n5 = n3 >>> 5 & 0x7FF;
            switch (n5) {
                case 100: {
                    n2 = this.get1DBits(9);
                    this.bitReached += 9;
                    n3 = black[n2];
                    n4 = n3 >>> 1 & 0xF;
                    n5 = n3 >>> 5 & 0x7FF;
                    if (n4 == 12) {
                        this.updatePointer(5);
                        n2 = this.get1DBits(4);
                        this.bitReached += 4;
                        n3 = additionalMakeup[n2];
                        n4 = n3 >>> 1 & 7;
                        n5 = n3 >>> 4 & 0xFFF;
                        n += n5;
                        this.updatePointer(4 - n4);
                        continue block4;
                    }
                    if (n4 == 15) {
                        throw new RuntimeException("CCITT unexpected EOL");
                    }
                    n += n5;
                    this.updatePointer(9 - n4);
                    if ((n3 & 1) != 0) continue block4;
                    bl = false;
                    continue block4;
                }
                case 200: {
                    n2 = this.get1DBits(2);
                    this.bitReached += 2;
                    n3 = twoBitBlack[n2];
                    n5 = n3 >>> 5 & 0x7FF;
                    n += n5;
                    n4 = n3 >>> 1 & 0xF;
                    this.updatePointer(2 - n4);
                    bl = false;
                    continue block4;
                }
            }
            n += n5;
            this.updatePointer(4 - n4);
            bl = false;
        }
        return n;
    }

    int getWhiteRunCodeWord() {
        int n = 0;
        boolean bl = true;
        while (bl) {
            int n2;
            int n3 = this.get1DBits(10);
            this.bitReached += 10;
            int n4 = white[n3];
            int n5 = n4 >>> 1 & 0xF;
            if (n5 == 12) {
                int n6 = this.get1DBits(2);
                this.bitReached += 2;
                n3 = n3 << 2 & 0xC | n6;
                n4 = additionalMakeup[n3];
                n5 = n4 >>> 1 & 7;
                n2 = n4 >>> 4 & 0xFFF;
                n += n2;
                this.updatePointer(4 - n5);
                continue;
            }
            if (n5 == 0 || n5 == 15) {
                throw new RuntimeException("CCITT Error in getWhiteRunCodeWord");
            }
            n2 = n4 >>> 5 & 0x7FF;
            n += n2;
            this.updatePointer(10 - n5);
            if ((n4 & 1) != 0) continue;
            bl = false;
        }
        return n;
    }

    private static void getNextChangingElement(int n, boolean bl, int[] nArray, int[] nArray2, int n2) {
        int n3;
        int n4 = 0;
        n4 = bl ? (n4 &= 0xFFFFFFFE) : (n4 |= 1);
        for (n3 = n4; n3 < n2; n3 += 2) {
            int n5 = nArray2[n3];
            if (n5 <= n) continue;
            nArray[0] = n5;
            break;
        }
        if (n3 + 1 < n2) {
            nArray[1] = nArray2[n3 + 1];
        }
    }

    private void updatePointer(int n) {
        this.bitReached -= n;
    }
}

