/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import org.jpedal.exception.PdfSecurityException;
import org.jpedal.io.ArrayDecoder;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.raw.ColorSpaceObject;
import org.jpedal.objects.raw.FunctionObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class ColorObjectDecoder
extends ObjectDecoder {
    private static final boolean debugColorspace = false;

    public ColorObjectDecoder(PdfFileReader pdfFileReader) {
        super(pdfFileReader);
    }

    int handleColorSpaces(PdfObject pdfObject, int n, byte[] byArray) {
        int n2 = byArray.length;
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 91 || byArray[n] == 93) {
            if (byArray[n] == 91) {
                pdfObject.maybeIndirect(true);
            }
            ++n;
        }
        if (byArray[n] == 47) {
            int n3;
            ++n;
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                ++n;
            }
            int n4 = n;
            int n5 = 0;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62 && byArray[n] != 91 && byArray[n] != 93) {
                ++n5;
                if (++n != n2) continue;
            }
            if ((n3 = pdfObject.setConstant(2087749783, n4, n5, byArray)) == 25) {
                n3 = 895578984;
            }
            n = this.setColorspace(pdfObject, n, byArray, n3);
        } else if (byArray[n] == 60 && byArray[n + 1] == 60) {
            n = this.readObjectValue(pdfObject, n, byArray);
        } else if (byArray[n] == 37) {
            while (byArray[n] != 10 && byArray[n] != 13) {
                ++n;
            }
        } else {
            n = byArray[n] == 60 ? this.readHexValue(pdfObject, n, byArray) : (byArray[n] == 40 ? this.readStringValue(pdfObject, n, byArray) : this.readColorObjectValue(pdfObject, n, byArray));
        }
        if (n < n2 && (byArray[n] == 47 || byArray[n] == 62)) {
            --n;
        }
        return n;
    }

    private int setColorspace(PdfObject pdfObject, int n, byte[] byArray, int n2) {
        switch (n2) {
            case 1008872003: {
                n = this.handleColorSpaces(pdfObject, n, byArray);
                ++n;
                break;
            }
            case 391471749: {
                n = this.handleColorSpaces(pdfObject, n, byArray);
                ++n;
                break;
            }
            case 1498837125: {
                break;
            }
            case 1568372915: {
                break;
            }
            case 960981604: {
                n = this.readDeviceNvalue(pdfObject, n, byArray);
                break;
            }
            case 1785221209: {
                break;
            }
            case 1247168582: {
                n = this.readDictionaryFromRefOrDirect(-1, pdfObject, "", n, byArray, 2087749783);
                break;
            }
            case 895578984: {
                n = this.readIndexedColorspace(pdfObject, n, byArray);
                break;
            }
            case 1847602: {
                n = this.handleColorSpaces(pdfObject, n, byArray);
                ++n;
                break;
            }
            case 1146450818: {
                break;
            }
            case -2073385820: {
                n = this.readSeparationColorspace(pdfObject, n, byArray);
            }
        }
        return n;
    }

    private int readDeviceNvalue(PdfObject pdfObject, int n, byte[] byArray) {
        int n2;
        for (n2 = n; n2 < byArray.length && byArray[n2] != 93; ++n2) {
        }
        ArrayDecoder arrayDecoder = new ArrayDecoder(this.objectReader, n, n2, 20);
        n = arrayDecoder.readArray(false, byArray, pdfObject, 1920898752);
        while (byArray[n] == 93 || byArray[n] == 32 || byArray[n] == 10 || byArray[n] == 13) {
            ++n;
        }
        ColorSpaceObject colorSpaceObject = new ColorSpaceObject(-1, 0);
        n = this.handleColorSpaces(colorSpaceObject, n, byArray);
        pdfObject.setDictionary(-1247101998, colorSpaceObject);
        ++n;
        FunctionObject functionObject = new FunctionObject(-1, 0);
        n = this.handleColorSpaces(functionObject, n, byArray);
        pdfObject.setDictionary(-1313946392, functionObject);
        for (int i = n; i < byArray.length && byArray[i] != 93; ++i) {
            if (byArray[i] == 32 || byArray[i] == 10 || byArray[i] == 13) continue;
            n = i;
            ColorSpaceObject colorSpaceObject2 = new ColorSpaceObject(-1, 0);
            n = this.handleColorSpaces(colorSpaceObject2, n, byArray);
            pdfObject.setDictionary(861242754, colorSpaceObject2);
            --n;
            i = byArray.length;
        }
        return ++n;
    }

    private int readColorObjectValue(PdfObject pdfObject, int n, byte[] byArray) {
        byte[] byArray2;
        int n2 = n;
        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62 && byArray[n] != 93) {
            ++n;
        }
        int n3 = NumberUtils.parseInt(n2, n, byArray);
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
            ++n;
        }
        n2 = n;
        while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
            ++n;
        }
        int n4 = NumberUtils.parseInt(n2, n, byArray);
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
            ++n;
        }
        if (byArray[n] != 82) {
            throw new RuntimeException("3. Unexpected value in file " + (char)byArray[n] + " - please send to IDRsolutions for analysis");
        }
        ++n;
        if (pdfObject.getObjectRefID() == -1 || pdfObject.maybeIndirect()) {
            pdfObject.setRef(n3, n4);
        }
        if ((byArray2 = this.objectReader.readObjectAsByteArray(pdfObject, this.objectReader.isCompressed(n3, n4), n3, n4)) == null) {
            pdfObject.setFullyResolved(false);
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("[Linearized] " + n3 + ' ' + n4 + " R not yet available (9)");
            }
            n = byArray.length;
        } else if (byArray2[0] == 47) {
            this.handleColorSpaces(pdfObject, 0, byArray2);
        } else {
            int n5 = 0;
            if (byArray2[0] != 91 && byArray2[0] != 60) {
                n5 = 3;
                while (byArray2[n5 - 1] != 106 && byArray2[n5 - 2] != 98 && byArray2[n5 - 3] != 111) {
                    ++n5;
                }
            }
            this.handleColorSpaces(pdfObject, n5, byArray2);
        }
        return n;
    }

    private int readIndexedColorspace(PdfObject pdfObject, int n, byte[] byArray) {
        ColorSpaceObject colorSpaceObject = new ColorSpaceObject(-1, 0, true);
        pdfObject.setDictionary(895578984, colorSpaceObject);
        for (n = this.handleColorSpaces(colorSpaceObject, n, byArray); n < byArray.length && (byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10 || byArray[n] == 93 || byArray[n] == 62); ++n) {
        }
        if (byArray[n = this.setNumberValue(pdfObject, n, byArray, 960901492)] != 40) {
            ++n;
        }
        while (n < byArray.length && (byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10)) {
            ++n;
        }
        boolean bl = byArray[n] == 91 || byArray[n] == 40 || byArray[n] == 60;
        ColorSpaceObject colorSpaceObject2 = bl ? new ColorSpaceObject(pdfObject.getObjectRefAsString()) : new ColorSpaceObject(-1, 0);
        pdfObject.setDictionary(1060856191, colorSpaceObject2);
        n = this.handleColorSpaces(colorSpaceObject2, n, byArray);
        return ++n;
    }

    private int readSeparationColorspace(PdfObject pdfObject, int n, byte[] byArray) {
        int n2 = n;
        while (byArray[n2] == 47 || byArray[n2] == 32 || byArray[n2] == 10 || byArray[n2] == 13) {
            ++n2;
        }
        int n3 = n2;
        while (n2 < byArray.length && byArray[n2] != 47 && byArray[n2] != 32 && byArray[n2] != 13 && byArray[n2] != 10) {
            ++n2;
        }
        int n4 = n2 - n3;
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n3, byArray2, 0, n4);
        pdfObject.setName(506543413, byArray2);
        n = n2;
        if (byArray[n] != 47) {
            ++n;
        }
        ColorSpaceObject colorSpaceObject = new ColorSpaceObject(-1, 0);
        n = this.handleColorSpaces(colorSpaceObject, n, byArray);
        pdfObject.setDictionary(-1247101998, colorSpaceObject);
        if (byArray[n] != 60) {
            ++n;
        }
        FunctionObject functionObject = new FunctionObject(-1, 0);
        n = this.handleColorSpaces(functionObject, n, byArray);
        pdfObject.setDictionary(-1313946392, functionObject);
        return ++n;
    }

    private int readObjectValue(PdfObject pdfObject, int n, byte[] byArray) {
        n = this.convertDirectDictionaryToObject(pdfObject, "", n, byArray, -1);
        if (pdfObject.hasStream()) {
            int n2 = byArray.length;
            int n3 = 0;
            for (int i = n; i < n2 - 5; ++i) {
                if (byArray[i] == 62 && byArray[i + 1] == 62) {
                    ++n3;
                }
                if (n3 == 2) break;
                if (byArray[i] != 115 || byArray[i + 1] != 116 || byArray[i + 2] != 114 || byArray[i + 3] != 101 || byArray[i + 4] != 97 || byArray[i + 5] != 109) continue;
                this.readStreamIntoObject(pdfObject, i, byArray);
                i = n2;
            }
        }
        return n;
    }

    private int readHexValue(PdfObject pdfObject, int n, byte[] byArray) {
        byte[] byArray2;
        block20: {
            int n2 = ++n;
            int n3 = 0;
            while (byArray[n2] != 62) {
                if (byArray[n2] != 32 && byArray[n2] != 10 && byArray[n2] != 13) {
                    ++n3;
                }
                ++n2;
            }
            int n4 = n3 >> 1;
            byArray2 = new byte[n4];
            int n5 = 0;
            while (true) {
                if (byArray[n] == 32 || byArray[n] == 10 || byArray[n] == 13) {
                    ++n;
                    continue;
                }
                int n6 = byArray[n];
                if (n6 >= 65 && n6 <= 70) {
                    n6 -= 55;
                } else if (n6 >= 97 && n6 <= 102) {
                    n6 -= 87;
                } else if (n6 >= 48 && n6 <= 57) {
                    n6 -= 48;
                } else {
                    throw new RuntimeException("Unexpected number " + (char)byArray[n]);
                }
                ++n;
                while (byArray[n] == 32 || byArray[n] == 10 || byArray[n] == 13) {
                    ++n;
                }
                int n7 = byArray[n];
                if (n7 >= 65 && n7 <= 70) {
                    n7 -= 55;
                } else if (n7 >= 97 && n7 <= 102) {
                    n7 -= 87;
                } else if (n7 >= 48 && n7 <= 57) {
                    n7 -= 48;
                } else {
                    throw new RuntimeException("Unexpected number " + (char)byArray[n]);
                }
                ++n;
                int n8 = n7 + (n6 << 4);
                byArray2[n5] = (byte)n8;
                if (++n5 == n4) break;
            }
            try {
                if (this.decryption != null) {
                    byArray2 = this.decryption.decrypt(byArray2, pdfObject.getObjectRefAsString(), false, null, false, false);
                }
            }
            catch (PdfSecurityException pdfSecurityException) {
                if (!LogWriter.isOutput()) break block20;
                LogWriter.writeLog("Exception: " + pdfSecurityException.getMessage());
            }
        }
        pdfObject.setDecodedStream(byArray2);
        return n;
    }

    private int readStringValue(PdfObject pdfObject, int n, byte[] byArray) {
        byte[] byArray2;
        block4: {
            int n2 = ++n;
            while (byArray[n] != 41 || ObjectUtils.isEscaped(byArray, n) && byArray[n - 1] != 0) {
                ++n;
            }
            byArray2 = ObjectUtils.readEscapedValue(n, byArray, n2, false);
            try {
                if (this.decryption != null) {
                    byArray2 = this.decryption.decrypt(byArray2, pdfObject.getObjectRefAsString(), false, null, false, false);
                }
            }
            catch (PdfSecurityException pdfSecurityException) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Exception: " + pdfSecurityException.getMessage());
            }
        }
        pdfObject.setDecodedStream(byArray2);
        return n;
    }

    private static void showData(PdfObject pdfObject, byte[] byArray, int n) {
        System.out.println(padding + "Reading colorspace into " + pdfObject + " ref=" + pdfObject.getObjectRefAsString() + " i=" + n + " chars=" + (char)byArray[n] + (char)byArray[n + 1] + (char)byArray[n + 2] + (char)byArray[n + 3] + (char)byArray[n + 4]);
        System.out.println(padding + "------------>");
        for (int i = n; i < byArray.length; ++i) {
            System.out.print((char)byArray[i]);
            if (i <= 5 || byArray[i - 5] != 115 || byArray[i - 4] != 116 || byArray[i - 3] != 114 || byArray[i - 2] != 101 || byArray[i - 1] != 97 || byArray[i] != 109) continue;
            i = byArray.length;
        }
        System.out.println("<--------");
    }

    int processColorSpace(PdfObject pdfObject, String string, int n, byte[] byArray) {
        if (!pdfObject.ignoreRecursion()) {
            if (pdfObject.getObjectType() == 2087749783) {
                return this.handleColorSpaces(pdfObject, n, byArray);
            }
            boolean bl = byArray[n] == 47;
            ColorSpaceObject colorSpaceObject = bl ? new ColorSpaceObject(string) : new ColorSpaceObject(-1, 0);
            pdfObject.setDictionary(2087749783, colorSpaceObject);
            if (colorSpaceObject.isDataExternal()) {
                colorSpaceObject.isDataExternal(true);
                if (!this.resolveFully(colorSpaceObject)) {
                    pdfObject.setFullyResolved(false);
                }
            }
            return this.handleColorSpaces(colorSpaceObject, n, byArray);
        }
        return n;
    }
}

