/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.CMAP;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.TTFontWriter;
import org.jpedal.utils.Sorts;

public class CMAPWriter
extends CMAP
implements FontTableWriter {
    int minCharCode = 65536;
    int maxCharCode = 0;
    String fontName;
    private PdfFont originalFont;

    public CMAPWriter(FontFile2 fontFile2, int n, Glyf glyf) {
        super(fontFile2, n, glyf);
    }

    private int createFormat0MapForTT(PdfJavaGlyphs pdfJavaGlyphs) {
        int n;
        TTGlyphs tTGlyphs = (TTGlyphs)pdfJavaGlyphs;
        CMAP cMAP = (CMAP)tTGlyphs.getTable(2);
        HashMap<Integer, Integer> hashMap = null;
        if (cMAP == null) {
            hashMap = new HashMap<Integer, Integer>();
            if (this.originalFont.getToUnicode() == null) {
                n = pdfJavaGlyphs.getGlyphCount();
                for (int i = 0; i < n; ++i) {
                    hashMap.put(i, i);
                }
            } else {
                for (n = 0; n < 65536; ++n) {
                    String string;
                    int n2;
                    if (this.originalFont.getUnicodeMapping(n) == null || (n2 = this.getAdjustedUniValue(string = this.originalFont.getUnicodeMapping(n))) < 0) continue;
                    hashMap.put(n2, n);
                }
            }
        } else {
            hashMap = cMAP.buildCharStringTable();
        }
        for (n = 0; n < 256; ++n) {
            this.glyphIndexToChar[1][n] = hashMap.get(n) != null ? (Integer)hashMap.get(n) : 0;
        }
        return 262;
    }

    /*
     * WARNING - void declaration
     */
    private int createFormat4MapForTT(PdfJavaGlyphs pdfJavaGlyphs) {
        void var11_29;
        void var11_27;
        void var11_25;
        void var11_23;
        int n;
        int n2;
        int n3;
        TTGlyphs tTGlyphs = (TTGlyphs)pdfJavaGlyphs;
        CMAP cMAP = (CMAP)tTGlyphs.getTable(2);
        HashMap<Integer, Integer> hashMap = null;
        if (cMAP == null) {
            hashMap = new HashMap<Integer, Integer>();
            if (this.originalFont.getToUnicode() == null) {
                int n5 = pdfJavaGlyphs.getGlyphCount();
                for (int i = 0; i < n5; ++i) {
                    hashMap.put(i, i);
                }
            } else {
                Object object;
                int n6;
                for (int i = 0; i < 65536; ++i) {
                    if (this.originalFont.getUnicodeMapping(i) == null || (n6 = this.getAdjustedUniValue((String)(object = this.originalFont.getUnicodeMapping(i)))) < 0) continue;
                    hashMap.put(n6, i);
                }
                if (hashMap.get(32) == null) {
                    Object[] objectArray = tTGlyphs.getCharStrings().keySet().toArray();
                    object = (Hmtx)tTGlyphs.getTable(6);
                    n6 = 0;
                    for (Object object2 : objectArray) {
                        while (n6 < this.originalFont.getGlyphData().getGlyphCount() && ((Hmtx)object).getUnscaledWidth(n6) == 0.0f) {
                            ++n6;
                        }
                        if (n6 != (Integer)object2) continue;
                        ++n6;
                    }
                    hashMap.put(32, n6);
                }
            }
        } else {
            hashMap = cMAP.buildCharStringTable();
        }
        int n7 = 0;
        HashMap<Integer, Integer> hashMap2 = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> hashMap3 = new HashMap<Integer, Integer>();
        Object[] objectArray = new HashMap();
        ArrayList arrayList = new ArrayList();
        for (Object k : hashMap.keySet()) {
            n3 = (Integer)k;
            n2 = (Integer)hashMap.get(n3);
            n = cMAP == null || cMAP.hasFormat4() ? n3 : (this.originalFont.getUnicodeMapping(n3) != null ? (int)this.originalFont.getUnicodeMapping(n3).charAt(0) : n3);
            hashMap2.put(n, n3);
            hashMap3.put(n, n2);
        }
        Object[] objectArray2 = hashMap2.keySet().toArray();
        Arrays.sort(objectArray2);
        n7 = hashMap2.size() + 1;
        this.endCode = new int[n7];
        this.endCode[n7 - 1] = 65535;
        boolean bl = false;
        while (var11_23 < n7 - 1) {
            this.endCode[var11_23] = (Integer)objectArray2[var11_23];
            ++var11_23;
        }
        this.startCode = new int[n7];
        this.startCode[n7 - 1] = 65535;
        boolean bl2 = false;
        while (var11_25 < n7 - 1) {
            this.startCode[var11_25] = (Integer)objectArray2[var11_25];
            ++var11_25;
        }
        this.idDelta = new int[n7];
        this.idDelta[n7 - 1] = 1;
        boolean bl3 = false;
        while (var11_27 < n7 - 1) {
            this.idDelta[var11_27] = (Integer)hashMap3.get(this.startCode[var11_27]) - this.startCode[var11_27];
            if (this.idDelta[var11_27] >= 0) {
                this.idDelta[var11_27] = 0;
                objectArray.put((int)var11_27, 2 * (n7 - var11_27) + 2 * arrayList.size());
                arrayList.add(hashMap3.get(this.startCode[var11_27]));
            }
            ++var11_27;
        }
        this.idRangeOffset = new int[n7];
        this.idRangeOffset[n7 - 1] = 0;
        boolean bl4 = false;
        while (var11_29 < n7 - 1) {
            this.idRangeOffset[var11_29] = objectArray.get((int)var11_29) != null ? (Integer)objectArray.get((int)var11_29) : 0;
            ++var11_29;
        }
        int n4 = n7 * 2;
        n3 = (int)(2.0 * Math.pow(2.0, Math.floor(Math.log(n7) / Math.log(2.0))));
        n2 = (int)(Math.log(n3 / 2) / Math.log(2.0));
        n = 2 * n7 - n3;
        this.CMAPreserved = new int[]{0, 0, 0};
        this.CMAPsegCount = new int[]{n4, 0, n4};
        this.CMAPsearchRange = new int[]{n3, 0, n3};
        this.CMAPentrySelector = new int[]{n2, 0, n2};
        this.CMAPrangeShift = new int[]{n, 0, n};
        if (arrayList.size() > 0) {
            this.glyphIdArray = new int[arrayList.size()];
            for (int i = 0; i < this.glyphIdArray.length; ++i) {
                this.glyphIdArray[i] = (Integer)arrayList.get(i);
            }
        }
        return 16 + n7 * 8 + arrayList.size() * 2;
    }

    private int createFormat4Map(PdfJavaGlyphs pdfJavaGlyphs, boolean bl, String[] stringArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray = new int[65536];
        for (n6 = 0; n6 < nArray.length; ++n6) {
            nArray[n6] = Integer.MAX_VALUE;
        }
        if (this.originalFont.getFontType() == 1217103210) {
            n6 = stringArray.length;
            for (n5 = 0; n5 < n6; ++n5) {
                int n7;
                if (stringArray[n5] == null || (n7 = Integer.parseInt(stringArray[n5])) <= 0) continue;
                nArray[n5] = n7;
            }
        } else {
            this.getNonTTGlyphData(pdfJavaGlyphs, bl, stringArray, nArray);
        }
        int[] nArray2 = new int[40000];
        int[] nArray3 = new int[40000];
        n5 = 0;
        boolean bl2 = false;
        for (n4 = 0; n4 < 65536; ++n4) {
            if (bl2 && nArray[n4] == Integer.MAX_VALUE) {
                bl2 = false;
                nArray3[n5] = n4 - 1;
                ++n5;
                continue;
            }
            if (bl2 || nArray[n4] == Integer.MAX_VALUE) continue;
            bl2 = true;
            nArray2[n5] = n4;
        }
        if (nArray[65533] == Integer.MAX_VALUE) {
            nArray2[n5] = 65533;
            nArray3[n5] = 65533;
            nArray[65533] = 1;
            ++n5;
        }
        if (nArray[65535] == Integer.MAX_VALUE) {
            nArray2[n5] = 65535;
            nArray3[n5] = 65535;
            nArray[65535] = 1;
            ++n5;
        }
        n4 = n5 * 2;
        this.CMAPsegCount = new int[]{n4, 0, n4};
        int n8 = 1;
        while (n8 * 2 <= n5) {
            n8 *= 2;
        }
        this.CMAPsearchRange = new int[]{n8 *= 2, 0, n8};
        int n9 = 0;
        int n10 = n8 / 2;
        while (n10 > 1) {
            n10 /= 2;
            ++n9;
        }
        this.CMAPentrySelector = new int[]{n9, 0, n9};
        int n11 = n4 - n8;
        this.CMAPrangeShift = new int[]{n11, 0, n11};
        this.endCode = nArray3;
        this.CMAPreserved = new int[]{0, 0, 0};
        this.startCode = nArray2;
        this.idRangeOffset = new int[n5];
        int n12 = 0;
        block5: for (n3 = 0; n3 < n5; ++n3) {
            n2 = nArray[nArray2[n3]] - nArray2[n3];
            for (n = nArray2[n3] + 1; n <= nArray3[n3]; ++n) {
                if (nArray[n] - n == n2) continue;
                this.idRangeOffset[n3] = -1;
                n12 += nArray3[n3] + 1 - nArray2[n3];
                continue block5;
            }
        }
        this.glyphIdArray = new int[n12];
        this.idDelta = new int[n5];
        n3 = 16 + n5 * 8;
        n2 = 0;
        for (n = 0; n < this.idRangeOffset.length; ++n) {
            if (this.idRangeOffset[n] == 0) {
                this.idDelta[n] = nArray[nArray2[n]] - nArray2[n] - 1;
                continue;
            }
            this.idRangeOffset[n] = n3 - (16 + n5 * 6 + n * 2);
            for (int i = nArray2[n]; i <= nArray3[n]; ++i) {
                this.glyphIdArray[n2] = nArray[i] - 1;
                n3 += 2;
                ++n2;
            }
        }
        return 16 + n5 * 8 + n12 * 2;
    }

    private void getNonTTGlyphData(PdfJavaGlyphs pdfJavaGlyphs, boolean bl, String[] stringArray, int[] nArray) {
        int n = 0;
        for (int i = 0; i < pdfJavaGlyphs.getGlyphCount() + 1; ++i) {
            int n2;
            String string = null;
            if (this.originalFont != null && this.originalFont.getGlyphData().isIdentity() && this.originalFont.hasToUnicode() && i > 1) {
                string = this.originalFont.getUnicodeMapping(n);
                while (string == null && n < 55296) {
                    string = this.originalFont.getUnicodeMapping(++n);
                }
                if (string != null) {
                    nArray[string.charAt((int)0)] = i;
                }
                ++n;
                continue;
            }
            if (string == null && bl) {
                string = pdfJavaGlyphs.getIndexForCharString(i);
            } else if (string == null && i < stringArray.length) {
                string = stringArray[i];
            }
            if (string == null || (n2 = StandardFonts.getIDForGlyphName(this.fontName, string)) < 0 || n2 >= nArray.length) continue;
            nArray[n2] = bl ? i : i + 1;
        }
    }

    public CMAPWriter(String string, PdfFont pdfFont, PdfFont pdfFont2, PdfJavaGlyphs pdfJavaGlyphs, String[] stringArray) {
        this.fontName = string;
        this.originalFont = pdfFont2;
        this.numberSubtables = 3;
        this.CMAPformats = new int[]{4, 0, 4};
        this.glyphIndexToChar = new int[3][256];
        this.platformID = new int[]{0, 1, 3};
        this.platformSpecificID = new int[]{3, 0, 1};
        this.CMAPlang = new int[]{0, 0, 0};
        int n = 0;
        if (pdfFont2.getFontType() == 1217103210) {
            n = this.createFormat4MapForTT(pdfJavaGlyphs);
            this.createFormat0MapForTT(pdfJavaGlyphs);
        } else {
            n = this.createFormat4Map(pdfJavaGlyphs, pdfFont.is1C(), stringArray);
            int n2 = 0;
            StandardFonts.checkLoaded(n2);
            for (int i = 0; i < pdfJavaGlyphs.getGlyphCount() + 1; ++i) {
                String string2 = null;
                if (pdfFont.is1C()) {
                    string2 = pdfJavaGlyphs.getIndexForCharString(i);
                } else if (i < stringArray.length) {
                    string2 = stringArray[i];
                }
                if (string2 == null) continue;
                int n3 = StandardFonts.lookupCharacterIndex(string2, 0);
                int n4 = i;
                if (pdfFont.is1C()) {
                    --n4;
                    if (i == 1) {
                        n4 = 1;
                    }
                }
                if (n3 < 0 || n3 >= 256) continue;
                this.glyphIndexToChar[1][n3] = n4;
            }
        }
        this.CMAPlength = new int[]{n, 262, n};
        this.CMAPsubtables = new int[]{28, 28 + n * 2, 28 + n};
    }

    public byte[] writeTable() throws IOException {
        int n;
        int n2;
        int n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n4 = this.numberSubtables;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n3 = 0; n3 < n4; ++n3) {
            arrayList.add(n3);
        }
        byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.id));
        byteArrayOutputStream.write(TTFontWriter.setNextUint16(n4));
        for (n3 = 0; n3 < n4; ++n3) {
            int n5 = (Integer)arrayList.get(n3);
            int n6 = n2 = n5 < 0 ? 1 : 0;
            if (n5 < 0) {
                n5 = -n5;
            }
            if (n2 != 0) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(0));
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(3));
            } else {
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.platformID[n5]));
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.platformSpecificID[n5]));
            }
            byteArrayOutputStream.write(TTFontWriter.setNextUint32(this.CMAPsubtables[n5]));
        }
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        for (n2 = 0; n2 < n4; ++n2) {
            n = (Integer)arrayList.get(n2);
            if (n < 0) {
                n = -n;
            }
            nArray[n] = this.CMAPsubtables[n];
            nArray2[n2] = n;
        }
        nArray2 = Sorts.quicksort(nArray, nArray2);
        for (n2 = 0; n2 < n4; ++n2) {
            int n7;
            int n8;
            n = nArray2[n2];
            while (byteArrayOutputStream.size() < this.CMAPsubtables[n]) {
                byteArrayOutputStream.write(0);
            }
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPformats[n]));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPlength[n]));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPlang[n]));
            if (this.CMAPformats[n] == 0 && this.CMAPlength[n] == 262) {
                for (n8 = 0; n8 < 256; ++n8) {
                    byteArrayOutputStream.write(TTFontWriter.setNextUint8(this.glyphIndexToChar[n][n8]));
                }
                continue;
            }
            if (this.CMAPformats[n] != 4) continue;
            n8 = this.CMAPsegCount[n] / 2;
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPsegCount[n]));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPsearchRange[n]));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPentrySelector[n]));
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPrangeShift[n]));
            for (n7 = 0; n7 < n8; ++n7) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.endCode[n7]));
            }
            byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.CMAPreserved[n]));
            for (n7 = 0; n7 < n8; ++n7) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.startCode[n7]));
            }
            for (n7 = 0; n7 < n8; ++n7) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.idDelta[n7]));
            }
            for (n7 = 0; n7 < n8; ++n7) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(this.idRangeOffset[n7]));
            }
            if (this.glyphIdArray == null) continue;
            for (int n9 : this.glyphIdArray) {
                byteArrayOutputStream.write(TTFontWriter.setNextUint16(n9));
            }
        }
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public int getIntValue(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = this.minCharCode;
                break;
            }
            case 1: {
                n2 = this.maxCharCode;
            }
        }
        return n2;
    }

    private int getAdjustedUniValue(String string) {
        if (string.length() == 1) {
            return string.charAt(0);
        }
        if (string.equals("ff")) {
            return 64256;
        }
        if (string.equals("fi")) {
            return 64257;
        }
        if (string.equals("fl")) {
            return 64258;
        }
        if (string.equals("ffi")) {
            return 64259;
        }
        if (string.equals("ffl")) {
            return 64260;
        }
        return -1;
    }

    public int getMaxCharCode() {
        return this.maxCharCode;
    }
}

